using Avalonia;
using Avalonia.Controls;
using Avalonia.Markup.Xaml;
using System;
using System.IO;
using System.Runtime.InteropServices;

namespace AvaloniaApp
{
    public class MainWindow : Window
    {
        [DllImport("NotifyIcon.dll", EntryPoint = "CreateTrayIcon", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I1)]
        internal static extern bool NotifyIcon(string className, ref Guid guid, IntPtr hWnd, IntPtr hIcon);

        public MainWindow()
        {
            InitializeComponent();
        }

        private Notify Notify { get; set; }

        private void InitializeComponent()
        {
            AvaloniaXamlLoader.Load(this);
            var abc = new WindowIcon(File.OpenRead("hej.ico"));
            Icon = abc;

            Notify = new Notify(
                PlatformImpl.Handle.Handle, 
                "My ToolTip!", 
                ((Avalonia.Win32.IconImpl)abc.PlatformImpl).HIcon);
            /*
            var id = Guid.NewGuid();
            Console.WriteLine("C# " + id);
            Console.WriteLine(NotifyIcon("AvaloniaNotifyDialog" + id, ref id, PlatformImpl.Handle.Handle, ((Avalonia.Win32.IconImpl)abc.PlatformImpl).HIcon));
            this.Closed += delegate
            {

            };
            */
        }
    }

    public class Notify
    {
        private const int WM_NULL = 0x0000;
        private const int WM_CREATE = 0x0001;
        private const int WM_CONTEXTMENU = 0x007B;
        private const int WM_LBUTTONDBLCLK = 0x0203;
        private const int WM_RBUTTONDOWN = 0x0204;
        private const int WM_APP = 0x8000;
        private const int WMAPP_NOTIFYCALLBACK = WM_APP + 1;

        private const int NIF_MESSAGE = 0x01;
        private const int NIF_ICON = 0x02;
        private const int NIF_TIP = 0x04;
        private const int NIF_GUID = 0x20;

        private const int NIM_ADD = 0x00;

        private const int MF_STRING = 0x000;
        private const int MF_POPUP = 0x010;
        private const int MF_SEPARATOR = 0x800;

        private const int TPM_LEFTALIGN = 0x0000;
        private const int TPM_BOTTOMALIGN = 0x0020;
        private const int TPM_NONOTIFY = 0x0080;
        private const int TPM_RETURNCMD = 0x0100;

        public Guid Id { get; }

        public Notify(IntPtr hWndParent, string tooltip, IntPtr hIcon)
        {
            IntPtr hWnd = CreateWindow(hWndParent);
            CreateNotify(hWnd, tooltip, hIcon);
        }

        private void ShowContextMenu(IntPtr hWnd)
        {
            IntPtr hMenu = CreatePopupMenu();
            IntPtr hSubMenu = CreatePopupMenu();

            AppendMenu(hSubMenu, MF_STRING, unchecked((IntPtr)123), "Start");
            AppendMenu(hSubMenu, MF_STRING, unchecked((IntPtr)124), "Stop");

            AppendMenu(hMenu, MF_STRING, unchecked((IntPtr)125), "Tjenna");
            AppendMenu(hMenu, MF_SEPARATOR, IntPtr.Zero, null);
            AppendMenu(hMenu, MF_POPUP | MF_STRING, hSubMenu, "Play");
            AppendMenu(hMenu, MF_POPUP | MF_STRING, hSubMenu, "Game");

            POINT point = new POINT();
            GetCursorPos(ref point);

            SetForegroundWindow(hWnd);
            int iId = TrackPopupMenu(hMenu,
                TPM_BOTTOMALIGN | TPM_LEFTALIGN | TPM_NONOTIFY | TPM_RETURNCMD,
                point.x, point.y,
                0, hWnd, IntPtr.Zero);
            Console.WriteLine("Selected id: " + iId);
            PostMessage(hWnd, WM_NULL, IntPtr.Zero, IntPtr.Zero);
        }

        [DllImport("user32.dll", EntryPoint = "CreatePopupMenu")]
        public static extern IntPtr CreatePopupMenu();

        [DllImport("user32.dll", CharSet = CharSet.Unicode, EntryPoint = "AppendMenuW")]
        public static extern IntPtr AppendMenu(IntPtr hWnd, uint uFlags, IntPtr uIDNewItem, string lpNewItem);

        [DllImport("user32.dll", EntryPoint = "GetCursorPos")]
        [return: MarshalAs(UnmanagedType.Bool)]
        public static extern bool GetCursorPos(ref POINT lpPoint);

        [DllImport("user32.dll", EntryPoint = "SetForegroundWindow")]
        [return: MarshalAs(UnmanagedType.Bool)]
        public static extern bool SetForegroundWindow(IntPtr hWnd);

        [DllImport("user32.dll", EntryPoint = "TrackPopupMenu")]
        public static extern int TrackPopupMenu(
            IntPtr hMenu, uint uFlags,
            int x, int y, int nReserved,
            IntPtr hWnd, /*ref RECT*/ IntPtr prcRect);

        [DllImport("user32.dll", EntryPoint = "PostMessageW")]
        [return: MarshalAs(UnmanagedType.Bool)]
        public static extern bool PostMessage(IntPtr hWnd, uint uiMsg, IntPtr wParam, IntPtr lParam);

        private WndProc _wndProc { get; set; }

        private IntPtr CreateWindow(IntPtr hWndParent)
        {
            _wndProc = new WndProc(WndProc);
            WNDCLASS wndClass = new WNDCLASS
            {
                lpfnWndProc = _wndProc,
                hInstance = GetModuleHandle(null),
                lpszClassName = "AvaloniaNotifyWindow " + Guid.NewGuid()
            };
            ushort atom = RegisterClass(ref wndClass);
            var HWND_MESSAGE = IntPtr.Subtract(IntPtr.Zero, 3);
            return CreateWindowEx(0, atom, null, 0,
                0, 0, 0, 0,
                /*hWndParent*/HWND_MESSAGE, IntPtr.Zero, IntPtr.Zero, IntPtr.Zero);
        }

        private int LOWORD(int x)
        {
            return BitConverter.ToUInt16(BitConverter.GetBytes(x), 0);
        }

        private int HIWORD(int x)
        {
            return BitConverter.ToInt16(BitConverter.GetBytes(x), 2);
        }

        private IntPtr WndProc(IntPtr hWnd, uint uiMsg, IntPtr wParam, IntPtr lParam)
        {
            switch (uiMsg)
            {
                case WMAPP_NOTIFYCALLBACK:
                    switch (LOWORD(lParam.ToInt32()))
                    {
                        case WM_LBUTTONDBLCLK:
                            Console.WriteLine("Left double click");
                            return IntPtr.Add(IntPtr.Zero, 1);
                        case WM_RBUTTONDOWN:
                        case WM_CONTEXTMENU:
                            Console.WriteLine("Context menu");
                            ShowContextMenu(hWnd);
                            return IntPtr.Add(IntPtr.Zero, 1);
                    }
                    break;
            }
            return DefWindowProc(hWnd, uiMsg, wParam, lParam);
        }

        [DllImport("user32.dll", CharSet = CharSet.Unicode, EntryPoint = "DefWindowProcW")]
        public static extern IntPtr DefWindowProc(IntPtr hWnd, uint uiMsg, IntPtr wParam, IntPtr lParam);

        [DllImport("kernel32.dll", SetLastError = true, CharSet = CharSet.Unicode, EntryPoint = "GetModuleHandleW")]
        public static extern IntPtr GetModuleHandle(string lpModuleName);

        [DllImport("user32.dll", SetLastError = true, CharSet = CharSet.Unicode, EntryPoint = "RegisterClassW")]
        public static extern ushort RegisterClass(ref WNDCLASS lpwc);

        [DllImport("user32.dll", SetLastError = true, CharSet = CharSet.Unicode, EntryPoint = "CreateWindowExW")]
        public static extern IntPtr CreateWindowEx(
            uint dwExStyle, uint lpClassName, string lpWindowName, uint dwStyle,
            int x, int y, int nWidth, int nHeight,
            IntPtr hWndParent, IntPtr hMenu, IntPtr hInstance, IntPtr lpParam);

        private void CreateNotify(IntPtr hWnd, string tooltip, IntPtr hIcon)
        {
            NOTIFYICONDATA niData = new NOTIFYICONDATA
            {
                cbSize = Convert.ToUInt32(Marshal.SizeOf<NOTIFYICONDATA>()),
                hWnd = hWnd,
                guidItem = Id,
                hIcon = hIcon,
                szTip = tooltip,
                uCallbackMessage = WMAPP_NOTIFYCALLBACK,
                uFlags = NIF_GUID | NIF_ICON | NIF_TIP | NIF_MESSAGE
            };

            Shell_NotifyIcon(NIM_ADD, ref niData);
        }

        [DllImport("shell32.dll", CharSet = CharSet.Unicode, EntryPoint = "Shell_NotifyIconW")]
        public static extern ushort Shell_NotifyIcon(uint dwMessage, ref NOTIFYICONDATA lpData);
    }

    public delegate IntPtr WndProc(IntPtr hWnd, uint msg, IntPtr wParam, IntPtr lParam);
    
    [StructLayout(LayoutKind.Sequential)]
    public struct POINT {
        public int x;
        public int y;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
    public struct WNDCLASS
    {
        public uint style;
        public WndProc lpfnWndProc;
        public int cbClsExtra;
        public int cbWndExtra;
        public IntPtr hInstance;
        public IntPtr hIcon;
        public IntPtr hCursor;
        public IntPtr hbrBackground;
        public string lpszMenuName;
        public string lpszClassName;
    }

    
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
    public struct NOTIFYICONDATA {
        public ulong cbSize;
        public IntPtr hWnd;
        public uint uID;
        public uint uFlags;
        public uint uCallbackMessage;
        public IntPtr hIcon;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 128)]
        public string szTip;
        public ulong dwState;
        public ulong dwStateMask;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 256)]
        public string szInfo;
        public uint uTimeout_or_uVersion;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 64)]
        public string szInfoTitle;
        public ulong dwInfoFlags;
        public Guid guidItem;
        public IntPtr hBalloonIcon;
    }
}