/*
 * Decompiled with CFR 0.152.
 */
package rubikscube;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import rubikscube.SystemVariablesModifier;
import rubikscube.gui.Log;
import rubikscube.gui.RCMain;

public class Booter {
    private static final File[] dllListx86 = new File[]{new File("lib" + File.separatorChar + "x86" + File.separatorChar + "j3dcore-d3d.dll"), new File("lib" + File.separatorChar + "x86" + File.separatorChar + "j3dcore-ogl.dll"), new File("lib" + File.separatorChar + "x86" + File.separatorChar + "j3dcore-ogl-chk.dll"), new File("lib" + File.separatorChar + "x86" + File.separatorChar + "j3dcore-ogl-cg.dll")};
    private static final File[] dllListx64 = new File[]{new File("lib" + File.separatorChar + "x64" + File.separatorChar + "j3dcore-ogl.dll")};
    private static final File[] jarList = new File[]{new File("lib" + File.separatorChar + "j3dcore.jar"), new File("lib" + File.separatorChar + "j3dutils.jar"), new File("lib" + File.separatorChar + "vecmath.jar")};

    private static boolean compareResourceWithFile(URL resource, File file) {
        if (resource == null || file == null || !file.exists() || !file.isFile()) {
            return false;
        }
        try {
            int resLength;
            BufferedInputStream resIn = new BufferedInputStream(resource.openStream(), 1024);
            BufferedInputStream fileIn = new BufferedInputStream(new FileInputStream(file), 1024);
            byte[] resRead = new byte[1024];
            byte[] fileRead = new byte[1024];
            while ((resLength = resIn.read(resRead)) > 0) {
                int fileLength = fileIn.read(fileRead);
                if (resLength != fileLength) {
                    resIn.close();
                    fileIn.close();
                    return false;
                }
                for (int i = 0; i < resLength; ++i) {
                    if (resRead[i] == fileRead[i]) continue;
                    resIn.close();
                    fileIn.close();
                    return false;
                }
            }
            resIn.close();
            fileIn.close();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new RCMain());
    }

    static {
        Log.initialize(null, "Log");
        System.setOut(new PrintStream(Log.createStream("System.out")));
        System.setErr(new PrintStream(Log.createStream("System.err")));
        try {
            SystemVariablesModifier.addLibraryPath(new File(System.getProperty("java.io.tmpdir")));
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("Unable to add library path!\n\t(NoSuchFieldException)");
            System.exit(1);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("Unable to add library path!\n\t(IllegalArgumentException)");
            System.exit(2);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("Unable to add library path!\n\t(IllegalAccessException)");
            System.exit(3);
        }
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.indexOf("win") != -1) {
                os = "windows";
            } else {
                System.exit(1);
            }
            int arch = Integer.valueOf(System.getProperty("sun.arch.data.model"));
            if (arch == 32) {
                arch = 86;
            }
            System.out.println(System.getProperty("os.name") + " with a x" + arch + " architecture");
            File[] dllList = arch == 64 ? dllListx64 : dllListx86;
            for (File[] list : new File[][]{dllList, jarList}) {
                for (int i = 0; i < list.length; ++i) {
                    String jarPath = list[i].getPath();
                    File tempFile = new File(System.getProperty("java.io.tmpdir") + File.separatorChar + jarPath.substring(jarPath.lastIndexOf(File.separatorChar)));
                    boolean alreadyExists = false;
                    int a = 0;
                    while (tempFile.exists() && !(alreadyExists = Booter.compareResourceWithFile(RCMain.class.getClassLoader().getResource(jarPath.replace(File.separatorChar, '/')), tempFile)) && !tempFile.delete()) {
                        tempFile = new File(tempFile.getPath().substring(0, tempFile.getPath().lastIndexOf(46)) + a + jarPath.substring(jarPath.lastIndexOf(46)));
                        ++a;
                    }
                    tempFile.deleteOnExit();
                    if (!alreadyExists) {
                        BufferedInputStream in = new BufferedInputStream(RCMain.class.getClassLoader().getResourceAsStream(jarPath.replace(File.separatorChar, '/')), 1024);
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile), 1024);
                        byte[] read = new byte[1024];
                        int length = 0;
                        int size = 0;
                        System.out.println("Copying " + jarPath + " to\n\t" + tempFile.getPath() + "... (" + jarPath.substring(jarPath.lastIndexOf(46)) + " " + (i + 1) + " of " + list.length + ")");
                        long start = System.currentTimeMillis();
                        while ((length = in.read(read)) > 0) {
                            out.write(read, 0, length);
                            size += length;
                        }
                        long time = System.currentTimeMillis() - start;
                        float kbsec = (float)size / 1024.0f / ((float)time / 1000.0f);
                        System.out.println("Copied " + (float)size / 1024.0f + "kb in " + time + "ms with an average speed of " + kbsec + (!Float.isInfinite(kbsec) ? "kb/s" : "!!"));
                        out.flush();
                        in.close();
                        out.close();
                    } else {
                        System.out.println("Using old " + jarPath.substring(jarPath.lastIndexOf(File.separatorChar) + 1) + " located at\n\t" + tempFile.getPath() + " (" + jarPath.substring(jarPath.lastIndexOf(46)) + " " + (i + 1) + " of " + list.length + ")");
                    }
                    list[i] = tempFile;
                }
            }
            for (int i = 0; i < jarList.length; ++i) {
                SystemVariablesModifier.addClassPath(jarList[i]);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

