/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.game;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class CubeMath<T> {
    private static final int[][] edges = new int[][]{{1, 2}, {2, 3}, {3, 5}, {5, 1}, {0, 1}, {0, 2}, {0, 3}, {0, 5}, {4, 1}, {4, 2}, {4, 3}, {4, 5}};
    private static final int[][] corners = new int[][]{{0, 1, 2}, {0, 2, 3}, {0, 3, 5}, {0, 5, 1}, {4, 1, 2}, {4, 2, 3}, {4, 3, 5}, {4, 5, 1}};

    public static String extractChange(Map<String, Integer> details) {
        int method = details.get("method");
        int direction = details.get("direction");
        String s = "";
        if (method == 10) {
            s = s + "rotateFace";
        } else if (method == 11) {
            s = s + "rotateRow";
        } else if (method == 12) {
            s = s + "rotateColumn";
        }
        s = s + "(" + details.get("face");
        if (method == 11) {
            s = s + ", " + details.get("rowcolumn");
        } else if (method == 12) {
            s = s + ", " + details.get("rowcolumn");
        }
        s = s + ", " + (direction == 0 ? "left" : (direction == 1 ? "right" : (direction == 2 ? "up" : "down"))) + ")";
        return s;
    }

    public static <T> T[][][] cloneFaces(T[][][] faces) {
        int size = faces[0][0].length;
        Object[][][] tempFaces = (Object[][][])Array.newInstance(faces.getClass().getComponentType(), 6);
        for (int i = 0; i < 6; ++i) {
            tempFaces[i] = (Object[][])Array.newInstance(faces[i].getClass().getComponentType(), size);
            for (int x = 0; x < size; ++x) {
                tempFaces[i][x] = (Object[])Array.newInstance(faces[i][x].getClass().getComponentType(), size);
                System.arraycopy(faces[i][x], 0, tempFaces[i][x], 0, size);
            }
        }
        return tempFaces;
    }

    public static boolean checkCube(Integer[][][] faces) {
        int i;
        int face;
        int cubeSize = faces[0].length;
        int target = cubeSize - 2;
        int[] found = new int[6];
        for (face = 0; face < 6; ++face) {
            for (int x = 1; x < cubeSize - 1; ++x) {
                for (int y = 1; y < cubeSize - 1; ++y) {
                    int n = faces[face][x][y];
                    found[n] = found[n] + 1;
                }
            }
        }
        for (face = 0; face < 6; ++face) {
            if (found[face] == target * target) continue;
            return false;
        }
        found = new int[edges.length];
        for (i = 0; i < edges.length; ++i) {
            for (int a = 1; a <= target; ++a) {
                int c1 = -1;
                int c2 = -1;
                block0 : switch (edges[i][0]) {
                    case 1: {
                        c1 = faces[1][cubeSize - 1][a];
                        c2 = faces[2][0][a];
                        break;
                    }
                    case 2: {
                        c1 = faces[2][cubeSize - 1][a];
                        c2 = faces[3][0][a];
                        break;
                    }
                    case 3: {
                        c1 = faces[3][cubeSize - 1][a];
                        c2 = faces[5][cubeSize - 1][cubeSize - 1 - a];
                        break;
                    }
                    case 5: {
                        c1 = faces[5][0][cubeSize - 1 - a];
                        c2 = faces[1][0][a];
                        break;
                    }
                    case 0: {
                        switch (edges[i][1]) {
                            case 1: {
                                c1 = faces[0][0][a];
                                c2 = faces[1][a][0];
                                break;
                            }
                            case 2: {
                                c1 = faces[0][a][cubeSize - 1];
                                c2 = faces[2][a][0];
                                break;
                            }
                            case 3: {
                                c1 = faces[0][cubeSize - 1][cubeSize - 1 - a];
                                c2 = faces[3][a][0];
                                break;
                            }
                            case 5: {
                                c1 = faces[0][a][0];
                                c2 = faces[5][a][cubeSize - 1];
                            }
                        }
                        break;
                    }
                    case 4: {
                        switch (edges[i][1]) {
                            case 1: {
                                c1 = faces[4][0][cubeSize - 1 - a];
                                c2 = faces[1][a][cubeSize - 1];
                                break block0;
                            }
                            case 2: {
                                c1 = faces[4][a][0];
                                c2 = faces[2][a][cubeSize - 1];
                                break block0;
                            }
                            case 3: {
                                c1 = faces[4][cubeSize - 1][a];
                                c2 = faces[3][a][cubeSize - 1];
                                break block0;
                            }
                            case 5: {
                                c1 = faces[4][a][cubeSize - 1];
                                c2 = faces[5][a][0];
                            }
                        }
                    }
                }
                for (int x = 0; x < edges.length; ++x) {
                    if (!CubeMath.equalsIgnore(c1, c2, faces[edges[x][0]][cubeSize / 2][cubeSize / 2], faces[edges[x][1]][cubeSize / 2][cubeSize / 2])) continue;
                    int n = x;
                    found[n] = found[n] + 1;
                }
            }
        }
        for (i = 0; i < edges.length; ++i) {
            if (found[i] == target) continue;
            return false;
        }
        found = new int[corners.length];
        for (i = 0; i < corners.length; ++i) {
            int c1 = -1;
            int c2 = -1;
            int c3 = -1;
            block20 : switch (corners[i][0]) {
                case 0: {
                    switch (corners[i][1]) {
                        case 1: {
                            c1 = faces[0][0][cubeSize - 1];
                            c2 = faces[1][cubeSize - 1][0];
                            c3 = faces[2][0][0];
                            break;
                        }
                        case 2: {
                            c1 = faces[0][cubeSize - 1][cubeSize - 1];
                            c2 = faces[2][cubeSize - 1][0];
                            c3 = faces[3][0][0];
                            break;
                        }
                        case 3: {
                            c1 = faces[0][cubeSize - 1][0];
                            c2 = faces[3][cubeSize - 1][0];
                            c3 = faces[5][cubeSize - 1][cubeSize - 1];
                            break;
                        }
                        case 5: {
                            c1 = faces[0][0][0];
                            c2 = faces[5][0][cubeSize - 1];
                            c3 = faces[1][0][0];
                        }
                    }
                    break;
                }
                case 4: {
                    switch (corners[i][1]) {
                        case 1: {
                            c1 = faces[4][0][0];
                            c2 = faces[1][cubeSize - 1][cubeSize - 1];
                            c3 = faces[2][0][cubeSize - 1];
                            break block20;
                        }
                        case 2: {
                            c1 = faces[4][cubeSize - 1][0];
                            c2 = faces[2][cubeSize - 1][cubeSize - 1];
                            c3 = faces[3][0][cubeSize - 1];
                            break block20;
                        }
                        case 3: {
                            c1 = faces[4][cubeSize - 1][cubeSize - 1];
                            c2 = faces[3][cubeSize - 1][cubeSize - 1];
                            c3 = faces[5][cubeSize - 1][0];
                            break block20;
                        }
                        case 5: {
                            c1 = faces[4][0][cubeSize - 1];
                            c2 = faces[5][0][0];
                            c3 = faces[1][0][cubeSize - 1];
                        }
                    }
                }
            }
            for (int a = 0; a < corners.length; ++a) {
                if (!CubeMath.equalsIgnore(c1, c2, c3, faces[corners[a][0]][cubeSize / 2][cubeSize / 2], faces[corners[a][1]][cubeSize / 2][cubeSize / 2], faces[corners[a][2]][cubeSize / 2][cubeSize / 2])) continue;
                int n = a;
                found[n] = found[n] + 1;
            }
        }
        for (i = 0; i < corners.length; ++i) {
            if (found[i] == 1) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsIgnore(int c1, int c2, int e1, int e2) {
        return c1 == e1 && c2 == e2 || c2 == e1 && c1 == e2;
    }

    private static boolean equalsIgnore(int c1, int c2, int c3, int e1, int e2, int e3) {
        return c1 == e1 && c2 == e2 && c3 == e3 || c1 == e1 && c3 == e2 && c2 == e3 || c2 == e1 && c1 == e2 && c3 == e3 || c2 == e1 && c3 == e2 && c1 == e3 || c3 == e1 && c2 == e2 && c1 == e3 || c3 == e1 && c1 == e2 && c2 == e3;
    }

    public static Map<String, Integer> reverseDetails(Map<String, Integer> details) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("face", details.get("face"));
        ret.put("method", details.get("method"));
        int direction = details.get("direction");
        ret.put("direction", direction == 0 ? 1 : (direction == 1 ? 0 : (direction == 2 ? 3 : (direction == 3 ? 2 : -1))));
        if (details.containsKey("rowcolumn")) {
            ret.put("rowcolumn", details.get("rowcolumn"));
        }
        return ret;
    }

    public static <T> T[][][] rotateCube(T[][][] faces, Map<String, Integer> rotate) {
        T[][][] tempFaces = CubeMath.cloneFaces(faces);
        int method = rotate.get("method");
        if (method == 10) {
            tempFaces = CubeMath.rotateFace(faces, rotate.get("face"), rotate.get("direction"));
        } else if (method == 11) {
            tempFaces = CubeMath.rotateRow(faces, rotate.get("face"), rotate.get("rowcolumn"), rotate.get("direction"));
        } else if (method == 12) {
            tempFaces = CubeMath.rotateColumn(faces, rotate.get("face"), rotate.get("rowcolumn"), rotate.get("direction"));
        }
        return tempFaces;
    }

    public static <T> T[][][] rotateFace(T[][][] faces, int face, int direction) {
        if (faces == null) {
            throw new NullPointerException("faces == null");
        }
        if (faces.length != 6 || faces[0].length <= 0 || faces[0].length != faces[0][0].length) {
            throw new IllegalArgumentException("faces-array not valid");
        }
        int size = faces[0][0].length;
        if (face < 0 || face >= 6 || direction < 0 || direction > 1) {
            throw new IllegalArgumentException("rotate arguments not valid");
        }
        Object[][][] tempFaces = CubeMath.cloneFaces(faces);
        CubeMath.rotateFace0(faces, size, face, direction, tempFaces);
        return tempFaces;
    }

    public static <T> T[][][] rotateRow(T[][][] faces, int face, int row, int direction) {
        if (faces == null) {
            throw new NullPointerException("faces == null");
        }
        if (faces.length != 6 || faces[0].length <= 0 || faces[0].length != faces[0][0].length) {
            throw new IllegalArgumentException("faces-array not valid");
        }
        int size = faces[0][0].length;
        if (face < 0 || face >= 6 || row >= size || direction < 0 || direction > 1) {
            throw new IllegalArgumentException("rotate arguments not valid");
        }
        Object[][][] tempFaces = CubeMath.cloneFaces(faces);
        CubeMath.rotateRow0(faces, size, face, row, direction, tempFaces);
        return tempFaces;
    }

    public static <T> T[][][] rotateColumn(T[][][] faces, int face, int column, int direction) {
        if (faces == null) {
            throw new NullPointerException("faces == null");
        }
        if (faces.length != 6 || faces[0].length <= 0 || faces[0].length != faces[0][0].length) {
            throw new IllegalArgumentException("faces-array not valid");
        }
        int size = faces[0][0].length;
        if (face < 0 || face >= 6 || column >= size || direction < 2 || direction > 3) {
            throw new IllegalArgumentException("rotate arguments not valid");
        }
        Object[][][] tempFaces = CubeMath.cloneFaces(faces);
        CubeMath.rotateColumn0(faces, size, face, column, direction, tempFaces);
        return tempFaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rotateFace0(Object[][][] faces, int size, int face, int direction, Object[][][] tempFaces) {
        Object[][][] objectArray = faces;
        synchronized (faces) {
            CubeMath.rotateFace1(faces, size, face, direction, tempFaces);
            if (face == 0) {
                CubeMath.rotateRow1(faces, size, 1, 0, direction == 0 ? 1 : 0, tempFaces);
            } else if (face == 1) {
                CubeMath.rotateColumn1(faces, size, 0, 0, direction == 0 ? 2 : 3, tempFaces);
            } else if (face == 2) {
                CubeMath.rotateRow1(faces, size, 0, size - 1, direction, tempFaces);
            } else if (face == 3) {
                CubeMath.rotateColumn1(faces, size, 0, size - 1, direction == 0 ? 3 : 2, tempFaces);
            } else if (face == 4) {
                CubeMath.rotateRow1(faces, size, 1, size - 1, direction, tempFaces);
            } else if (face == 5) {
                CubeMath.rotateRow1(faces, size, 0, 0, direction == 0 ? 1 : 0, tempFaces);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rotateRow0(Object[][][] faces, int size, int face, int row, int direction, Object[][][] tempFaces) {
        Object[][][] objectArray = faces;
        synchronized (faces) {
            CubeMath.rotateRow1(faces, size, face, row, direction, tempFaces);
            if (row == 0) {
                if (face == 0) {
                    CubeMath.rotateFace1(faces, size, 5, direction == 0 ? 1 : 0, tempFaces);
                } else if (face >= 1 && face <= 3) {
                    CubeMath.rotateFace1(faces, size, 0, direction == 0 ? 1 : 0, tempFaces);
                } else if (face == 4) {
                    CubeMath.rotateFace1(faces, size, 2, direction == 0 ? 1 : 0, tempFaces);
                } else if (face == 5) {
                    CubeMath.rotateFace1(faces, size, 4, direction == 0 ? 1 : 0, tempFaces);
                }
            } else if (row == size - 1) {
                if (face == 0) {
                    CubeMath.rotateFace1(faces, size, 2, direction, tempFaces);
                } else if (face >= 1 && face <= 3) {
                    CubeMath.rotateFace1(faces, size, 4, direction, tempFaces);
                } else if (face == 4) {
                    CubeMath.rotateFace1(faces, size, 5, direction, tempFaces);
                } else if (face == 5) {
                    CubeMath.rotateFace1(faces, size, 0, direction, tempFaces);
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rotateColumn0(Object[][][] faces, int size, int face, int column, int direction, Object[][][] tempFaces) {
        Object[][][] objectArray = faces;
        synchronized (faces) {
            CubeMath.rotateColumn1(faces, size, face, column, direction, tempFaces);
            if (column == 0) {
                if (face == 0 || face == 2 || face >= 4) {
                    CubeMath.rotateFace1(faces, size, 1, direction == 3 ? 1 : 0, tempFaces);
                } else if (face == 1) {
                    CubeMath.rotateFace1(faces, size, 5, direction == 3 ? 1 : 0, tempFaces);
                } else if (face == 3) {
                    CubeMath.rotateFace1(faces, size, 2, direction == 3 ? 1 : 0, tempFaces);
                }
            } else if (column == size - 1) {
                if (face == 0 || face == 2 || face >= 4) {
                    CubeMath.rotateFace1(faces, size, 3, direction == 3 ? 0 : 1, tempFaces);
                } else if (face == 1) {
                    CubeMath.rotateFace1(faces, size, 2, direction == 3 ? 0 : 1, tempFaces);
                } else if (face == 3) {
                    CubeMath.rotateFace1(faces, size, 5, direction == 3 ? 0 : 1, tempFaces);
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    private static void rotateFace1(Object[][][] faces, int size, int face, int direction, Object[][][] tempFaces) {
        block5: {
            block4: {
                if (direction != 0) break block4;
                for (int i = 0; i < size / 2; ++i) {
                    for (int x = i; x < size - i; ++x) {
                        tempFaces[face][x][i] = faces[face][size - 1 - i][x];
                        tempFaces[face][i][x] = faces[face][size - 1 - x][i];
                        tempFaces[face][x][size - 1 - i] = faces[face][i][x];
                        tempFaces[face][size - 1 - i][size - 1 - x] = faces[face][x][size - 1 - i];
                    }
                }
                break block5;
            }
            if (direction != 1) break block5;
            for (int i = 0; i < size / 2; ++i) {
                for (int x = i; x < size - i; ++x) {
                    tempFaces[face][x][i] = faces[face][i][x];
                    tempFaces[face][i][x] = faces[face][x][size - 1 - i];
                    tempFaces[face][x][size - 1 - i] = faces[face][size - 1 - i][size - 1 - x];
                    tempFaces[face][size - 1 - i][size - 1 - x] = faces[face][size - 1 - x][i];
                }
            }
        }
    }

    private static void rotateRow1(Object[][][] faces, int size, int face, int row, int direction, Object[][][] tempFaces) {
        block18: {
            block16: {
                block20: {
                    block19: {
                        block17: {
                            if (direction != 0) break block16;
                            if (face != 0) break block17;
                            for (int i = 0; i < size; ++i) {
                                tempFaces[0][i][row] = faces[3][size - 1 - row][i];
                                tempFaces[1][row][i] = faces[0][size - 1 - i][row];
                                tempFaces[3][size - 1 - row][i] = faces[4][size - 1 - i][size - 1 - row];
                                tempFaces[4][i][size - 1 - row] = faces[1][row][i];
                            }
                            break block18;
                        }
                        if (face < 1 || face > 3) break block19;
                        for (int i = 0; i < size; ++i) {
                            tempFaces[1][i][row] = faces[2][i][row];
                            tempFaces[2][i][row] = faces[3][i][row];
                            tempFaces[3][i][row] = faces[5][size - 1 - i][size - 1 - row];
                            tempFaces[5][i][size - 1 - row] = faces[1][size - 1 - i][row];
                        }
                        break block18;
                    }
                    if (face != 4) break block20;
                    for (int i = 0; i < size; ++i) {
                        tempFaces[0][i][size - 1 - row] = faces[1][size - 1 - row][size - 1 - i];
                        tempFaces[1][size - 1 - row][i] = faces[4][i][row];
                        tempFaces[3][row][i] = faces[0][i][size - 1 - row];
                        tempFaces[4][i][row] = faces[3][row][size - 1 - i];
                    }
                    break block18;
                }
                if (face != 5) break block18;
                for (int i = 0; i < size; ++i) {
                    tempFaces[1][i][size - 1 - row] = faces[5][size - 1 - i][row];
                    tempFaces[2][i][size - 1 - row] = faces[1][i][size - 1 - row];
                    tempFaces[3][i][size - 1 - row] = faces[2][i][size - 1 - row];
                    tempFaces[5][i][row] = faces[3][size - 1 - i][size - 1 - row];
                }
                break block18;
            }
            if (direction == 1) {
                if (face == 0) {
                    for (int i = 0; i < size; ++i) {
                        tempFaces[0][i][row] = faces[1][row][size - 1 - i];
                        tempFaces[1][row][i] = faces[4][i][size - 1 - row];
                        tempFaces[3][size - 1 - row][i] = faces[0][i][row];
                        tempFaces[4][i][size - 1 - row] = faces[3][size - 1 - row][size - 1 - i];
                    }
                } else if (face >= 1 && face <= 3) {
                    for (int i = 0; i < size; ++i) {
                        tempFaces[1][i][row] = faces[5][size - 1 - i][size - 1 - row];
                        tempFaces[2][i][row] = faces[1][i][row];
                        tempFaces[3][i][row] = faces[2][i][row];
                        tempFaces[5][i][size - 1 - row] = faces[3][size - 1 - i][row];
                    }
                } else if (face == 4) {
                    for (int i = 0; i < size; ++i) {
                        tempFaces[0][i][size - 1 - row] = faces[3][row][i];
                        tempFaces[1][size - 1 - row][i] = faces[0][size - 1 - i][size - 1 - row];
                        tempFaces[3][row][i] = faces[4][size - 1 - i][row];
                        tempFaces[4][i][row] = faces[1][size - 1 - row][i];
                    }
                } else if (face == 5) {
                    for (int i = 0; i < size; ++i) {
                        tempFaces[1][i][size - 1 - row] = faces[2][i][size - 1 - row];
                        tempFaces[2][i][size - 1 - row] = faces[3][i][size - 1 - row];
                        tempFaces[3][i][size - 1 - row] = faces[5][size - 1 - i][row];
                        tempFaces[5][i][row] = faces[1][size - 1 - i][size - 1 - row];
                    }
                }
            }
        }
    }

    private static void rotateColumn1(Object[][][] faces, int size, int face, int column, int direction, Object[][][] tempFaces) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (face != 1) break block2;
                        CubeMath.rotateRow1(faces, size, 0, column, direction == 2 ? 1 : 0, tempFaces);
                        break block3;
                    }
                    if (face != 3) break block4;
                    CubeMath.rotateRow1(faces, size, 0, size - 1 - column, direction == 2 ? 0 : 1, tempFaces);
                    break block3;
                }
                if (direction != 2) break block5;
                for (int i = 0; i < size; ++i) {
                    tempFaces[0][column][i] = faces[2][column][i];
                    tempFaces[2][column][i] = faces[4][column][i];
                    tempFaces[4][column][i] = faces[5][column][i];
                    tempFaces[5][column][i] = faces[0][column][i];
                }
                break block3;
            }
            if (direction != 3) break block3;
            for (int i = 0; i < size; ++i) {
                tempFaces[0][column][i] = faces[5][column][i];
                tempFaces[2][column][i] = faces[0][column][i];
                tempFaces[4][column][i] = faces[2][column][i];
                tempFaces[5][column][i] = faces[4][column][i];
            }
        }
    }
}

