/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.game;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import rubikscube.game.CubeMath;
import rubikscube.game.RubiksCubeListener;

public class RubiksCube {
    public static final Color[] FACE_COLORS = new Color[]{Color.WHITE, Color.RED, new Color(255, 140, 0), Color.YELLOW, Color.BLUE, Color.GREEN};
    public static final String[] COLOR_NAMES = new String[]{"Vit", "R\u00f6d", "Orange", "Gul", "Bl\u00e5", "Gr\u00f6n"};
    public static final int DIR_LEFT = 0;
    public static final int DIR_RIGHT = 1;
    public static final int DIR_UP = 2;
    public static final int DIR_DOWN = 3;
    public static final int TOP = 0;
    public static final int LEFT = 1;
    public static final int FRONT = 2;
    public static final int RIGHT = 3;
    public static final int BOTTOM = 4;
    public static final int BACK = 5;
    public static final int NUM_FACES = 6;
    public static final String DETAILS_METHOD = "method";
    public static final String DETAILS_FACE = "face";
    public static final String DETAILS_ROWCOLUMN = "rowcolumn";
    public static final String DETAILS_DIRECTION = "direction";
    public static final int DETAILS_ROTATE_FACE = 10;
    public static final int DETAILS_ROTATE_ROW = 11;
    public static final int DETAILS_ROTATE_COLUMN = 12;
    private Integer[][][] faces;
    private final Object facesBlock = new Object();
    private int size;
    private final List<RubiksCubeListener> cListeners = new ArrayList<RubiksCubeListener>();
    private Thread rotationThread;
    private boolean bRThreadRun = true;
    private final List<Map<String, Integer>> rotationQueue = new ArrayList<Map<String, Integer>>();
    private boolean godMode = false;

    public static boolean isSolved(Integer[][][] cube) {
        int size = cube[0].length;
        for (int face = 0; face < 6; ++face) {
            int c = cube[face][0][0];
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < size; ++y) {
                    if (cube[face][x][y] == c) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public RubiksCube(int size) {
        this(new Integer[6][size][size]);
        this.reset();
    }

    public RubiksCube(Integer[][][] faces) {
        if (faces.length != 6 || faces[0].length != faces[0][0].length) {
            throw new IllegalArgumentException("Troll faces");
        }
        this.faces = faces;
        this.size = faces[0].length;
        this.rotationThread = new RotationThread();
        this.rotationThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRotationQueueSize() {
        List<Map<String, Integer>> list = this.rotationQueue;
        synchronized (list) {
            return this.rotationQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.facesBlock;
        synchronized (object) {
            for (int face = 0; face < 6; ++face) {
                for (int x = 0; x < this.size; ++x) {
                    for (int y = 0; y < this.size; ++y) {
                        this.faces[face][x][y] = face;
                    }
                }
            }
        }
        this.fireCubeEdited();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCubeEdited() {
        List<RubiksCubeListener> list = this.cListeners;
        synchronized (list) {
            for (RubiksCubeListener cl : this.cListeners) {
                cl.cubeEdited();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCube(File file) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(this.size);
        Object object = this.facesBlock;
        synchronized (object) {
            for (int face = 0; face < 6; ++face) {
                for (int x = 0; x < this.size; ++x) {
                    for (int y = 0; y < this.size; ++y) {
                        fos.write(this.faces[face][x][y]);
                    }
                }
            }
        }
        fos.flush();
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCube(File file) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        int s = fis.read();
        if (s != this.size) {
            fis.close();
            throw new IllegalArgumentException("Size of loaded cube is not equal to " + this.size);
        }
        Object object = this.facesBlock;
        synchronized (object) {
            for (int face = 0; face < 6; ++face) {
                for (int x = 0; x < this.size; ++x) {
                    for (int y = 0; y < this.size; ++y) {
                        this.faces[face][x][y] = fis.read();
                    }
                }
            }
        }
        fis.close();
        this.fireCubeEdited();
    }

    public int getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer[][][] getFaces() {
        Integer[][][] tempFaces = new Integer[6][this.size][this.size];
        Object object = this.facesBlock;
        synchronized (object) {
            for (int face = 0; face < 6; ++face) {
                for (int x = 0; x < this.getSize(); ++x) {
                    System.arraycopy(this.faces[face][x], 0, tempFaces[face][x], 0, this.getSize());
                }
            }
        }
        return tempFaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFacelet(int face, int x, int y) {
        Object object = this.facesBlock;
        synchronized (object) {
            return this.faces[face][x][y];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCubeListener(RubiksCubeListener cl) {
        List<RubiksCubeListener> list = this.cListeners;
        synchronized (list) {
            if (cl != null && !this.cListeners.contains(cl)) {
                this.cListeners.add(cl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCubeListener(RubiksCubeListener cl) {
        List<RubiksCubeListener> list = this.cListeners;
        synchronized (list) {
            this.cListeners.remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCubeListener(int cl) {
        List<RubiksCubeListener> list = this.cListeners;
        synchronized (list) {
            this.cListeners.remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCubeChange(Map<String, Integer> details) {
        List<RubiksCubeListener> list = this.cListeners;
        synchronized (list) {
            for (int i = 0; i < this.cListeners.size(); ++i) {
                this.cListeners.get(i).cubeChanged(details);
            }
        }
    }

    public void shuffle(int steps) {
        Random r = new Random();
        for (int i = 0; i < steps; ++i) {
            int r1 = r.nextInt(3);
            int r2 = r.nextInt(6);
            int r3 = r.nextInt(this.getSize());
            int r4 = r.nextInt(2);
            if (r1 == 0) {
                this.rotateFace(r2, r4);
                continue;
            }
            if (r1 == 1) {
                this.rotateRow(r2, r3, r4);
                continue;
            }
            this.rotateColumn(r2, r3, r4 + 2);
        }
    }

    public Map<String, Integer> rotateFace(int face, int direction) {
        if (face < 0 || face >= 6 || direction < 0 || direction > 1) {
            return null;
        }
        HashMap<String, Integer> details = new HashMap<String, Integer>();
        details.put(DETAILS_METHOD, 10);
        details.put(DETAILS_FACE, face);
        details.put(DETAILS_DIRECTION, direction);
        return this.rotateCube(details);
    }

    public Map<String, Integer> rotateRow(int face, int row, int direction) {
        if (face < 0 || face >= 6 || row < 0 || row > this.getSize() - 1 || direction < 0 || direction > 1) {
            return null;
        }
        HashMap<String, Integer> details = new HashMap<String, Integer>();
        details.put(DETAILS_METHOD, 11);
        details.put(DETAILS_FACE, face);
        details.put(DETAILS_ROWCOLUMN, row);
        details.put(DETAILS_DIRECTION, direction);
        return this.rotateCube(details);
    }

    public Map<String, Integer> rotateColumn(int face, int column, int direction) {
        if (face < 0 || face >= 6 || column < 0 || column > this.getSize() - 1 || direction < 2 || direction > 3) {
            return null;
        }
        HashMap<String, Integer> details = new HashMap<String, Integer>();
        details.put(DETAILS_METHOD, 12);
        details.put(DETAILS_FACE, face);
        details.put(DETAILS_ROWCOLUMN, column);
        details.put(DETAILS_DIRECTION, direction);
        return this.rotateCube(details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> rotateCube(Map<String, Integer> details) {
        List<Map<String, Integer>> list = this.rotationQueue;
        synchronized (list) {
            this.rotationQueue.add(details);
        }
        return details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRotating() {
        List<Map<String, Integer>> list = this.rotationQueue;
        synchronized (list) {
            return !this.rotationQueue.isEmpty();
        }
    }

    public void waitForRotation() {
        try {
            while (this.isRotating()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(RubiksCube.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setGodMode(boolean newGod) {
        if (newGod != this.godMode) {
            if (!newGod) {
                Object object = this.facesBlock;
                synchronized (object) {
                    if (!CubeMath.checkCube(this.faces)) {
                        return false;
                    }
                }
            }
            this.godMode = newGod;
            for (RubiksCubeListener cl : this.cListeners) {
                cl.godModeSet(this.godMode);
            }
        }
        return true;
    }

    public boolean isGodMode() {
        return this.godMode;
    }

    public void scrollFacelet(int[] facelet, boolean forward) {
        this.scrollFacelet(facelet[0], facelet[1], facelet[2], forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollFacelet(int face, int x, int y, boolean forward) {
        Object object = this.facesBlock;
        synchronized (object) {
            int c = this.getFacelet(face, x, y) + (forward ? 1 : -1);
            if (c < 0) {
                c = 5;
            }
            if (c >= 6) {
                c = 0;
            }
            this.setFacelet0(face, x, y, c);
        }
        this.fireCubeEdited();
    }

    public void setFacelet(int[] facelet, int c) {
        this.setFacelet(facelet[0], facelet[1], facelet[2], c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacelet(int face, int x, int y, int c) {
        Object object = this.facesBlock;
        synchronized (object) {
            this.setFacelet0(face, x, y, c);
        }
        this.fireCubeEdited();
    }

    private void setFacelet0(int face, int x, int y, int c) {
        if (c < 0 || c >= FACE_COLORS.length) {
            throw new IllegalArgumentException("Facelet color");
        }
        this.faces[face][x][y] = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.bRThreadRun = false;
        }
        finally {
            super.finalize();
        }
    }

    static /* synthetic */ Integer[][][] access$402(RubiksCube x0, Integer[][][] x1) {
        x0.faces = x1;
        return x1;
    }

    private class RotationThread
    extends Thread {
        private RotationThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map currentJob = null;
            while (RubiksCube.this.bRThreadRun) {
                boolean isEmpty;
                Object object = RubiksCube.this.rotationQueue;
                synchronized (object) {
                    isEmpty = RubiksCube.this.rotationQueue.isEmpty();
                    if (!isEmpty) {
                        currentJob = (Map)RubiksCube.this.rotationQueue.get(0);
                    }
                }
                if (isEmpty) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                object = RubiksCube.this.facesBlock;
                synchronized (object) {
                    RubiksCube.access$402(RubiksCube.this, CubeMath.rotateCube(RubiksCube.this.faces, currentJob));
                }
                RubiksCube.this.fireCubeChange(currentJob);
                object = RubiksCube.this.rotationQueue;
                synchronized (object) {
                    RubiksCube.this.rotationQueue.remove(currentJob);
                }
                currentJob = null;
            }
        }
    }
}

