/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.game.solver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SolutionStep {
    public static final int FRONT = 0;
    public static final int FRONT_UPSIDEDOWN = 1;
    public static final int SIDE = 2;
    public static final int SIDE_UPSIDEDOWN = 3;
    private String description;
    private List<Integer> rotationType = new ArrayList<Integer>();
    private List<Integer> rotationFace = new ArrayList<Integer>();
    private List<Integer> stepTypes = new ArrayList<Integer>();
    private int[][] highlights;
    private boolean still;
    private List<Map<String, Integer>> steps = new ArrayList<Map<String, Integer>>();

    public SolutionStep(int[][] high, boolean still) {
        this.highlights = high;
        this.still = still;
    }

    public SolutionStep(String desc, int[][] high, boolean still) {
        this.description = desc;
        this.highlights = high;
        this.still = still;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public void addRotation(int type, int face) {
        this.rotationType.add(type);
        this.rotationFace.add(face);
    }

    public int getRotations() {
        return this.rotationType.size();
    }

    public int getRotationType(int index) {
        return this.rotationType.get(index);
    }

    public int getRotationFace(int index) {
        return this.rotationFace.get(index);
    }

    public boolean hasHighlights() {
        return this.highlights != null && this.highlights.length > 0;
    }

    public int[][] getHighlights() {
        return this.highlights;
    }

    public boolean isHighlightsStill() {
        return this.still;
    }

    public void addStep(Map<String, Integer> map, int type) {
        this.addStep(this.getSteps(), map, type);
    }

    public void addStep(int index, Map<String, Integer> map, int type) {
        if (map != null) {
            this.steps.add(index, map);
            this.stepTypes.add(index, type);
        }
    }

    public int getSteps() {
        return this.steps.size();
    }

    public Map<String, Integer> getStep(int step) {
        return this.steps.get(step);
    }

    public int getStepType(int step) {
        return this.stepTypes.get(step);
    }
}

