/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.game.solver.brute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import rubikscube.game.CubeMath;
import rubikscube.game.RubiksCube;
import rubikscube.game.solver.brute.BruteCallbackThread;
import rubikscube.game.solver.brute.SolverJob;
import rubikscube.game.solver.brute.SolverListener;
import rubikscube.game.solver.brute.SolverThread;
import rubikscube.gui.RCMain;

public class Solver
implements Runnable {
    protected RubiksCube cube;
    protected List<SolverListener> solverListeners;
    protected boolean solving = false;
    protected Integer[][][] facesToSolve;
    protected SolverThread[] solvers;
    protected BruteCallbackThread bruteCallbackThread;
    protected int bruteMinimumSteps;
    protected List<List<Map<String, Integer>>> solvedJobs;
    protected List<String> foundlist;
    protected List<SolverJob> jobList;

    public static boolean checkFaces(Integer[][][] faces) {
        for (int i = 0; i < 6; ++i) {
            int faceColor = faces[i][0][0];
            for (int x = 1; x < faces[i].length; ++x) {
                for (int y = 0; y < faces[i][x].length; ++y) {
                    if (faces[i][x][y] == faceColor) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static Map<String, Integer>[] createPossibilities(Integer[][][] faces) {
        int size = faces[0][0].length;
        int possibilities = size * 3 * 2;
        Map[] ret = new Map[possibilities];
        for (int i = 0; i < possibilities; ++i) {
            ret[i] = new HashMap();
            int method = i % 3;
            int face = i % 3;
            int rowcolumn = i / (size * 2);
            int direction = i / 3 % 2;
            ret[i].put("method", method == 1 ? 12 : 11);
            ret[i].put("face", face == 2 ? 2 : 0);
            ret[i].put("rowcolumn", rowcolumn);
            ret[i].put("direction", method == 1 ? 2 + direction : direction);
        }
        return ret;
    }

    public Solver(RubiksCube cube) {
        if (cube == null) {
            throw new NullPointerException("Cube == null");
        }
        this.cube = cube;
        this.solverListeners = new ArrayList<SolverListener>();
        this.foundlist = new ArrayList<String>();
        this.jobList = new ArrayList<SolverJob>();
    }

    @Override
    public void run() {
        this.cube.shuffle(5);
        while (this.cube.isRotating()) {
            try {
                System.out.println("Waiting...");
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        final long start = System.currentTimeMillis();
        this.addSolverListener(new SolverListener(){

            @Override
            public void bruteSolveDone(Integer[][][] faces, List<Map<String, Integer>> solution) {
                System.out.println("Solution found in " + (System.currentTimeMillis() - start) + "ms.");
                System.out.println(solution.size() + " steps was needed.");
                for (int i = 0; i < solution.size(); ++i) {
                    System.out.println(CubeMath.extractChange(solution.get(i)));
                    int method = solution.get(i).get("method");
                    int face = solution.get(i).get("face");
                    int direction = solution.get(i).get("direction");
                    if (method == 10) {
                        faces = CubeMath.rotateFace(faces, face, direction);
                        continue;
                    }
                    if (method == 11) {
                        faces = CubeMath.rotateRow(faces, face, solution.get(i).get("rowcolumn"), direction);
                        continue;
                    }
                    if (method != 12) continue;
                    faces = CubeMath.rotateColumn(faces, face, solution.get(i).get("rowcolumn"), direction);
                }
            }
        });
        if (this.bruteSolve()) {
            System.out.println("Go!");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            System.out.println("Nothing to solve!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSolverListener(SolverListener sl) {
        List<SolverListener> list = this.solverListeners;
        synchronized (list) {
            if (sl != null && !this.solverListeners.contains(sl)) {
                this.solverListeners.add(sl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSolverListener(SolverListener sl) {
        List<SolverListener> list = this.solverListeners;
        synchronized (list) {
            this.solverListeners.remove(sl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSolverListener(int sl) {
        List<SolverListener> list = this.solverListeners;
        synchronized (list) {
            this.solverListeners.remove(sl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bruteSolve() {
        if (this.solving) {
            return true;
        }
        this.facesToSolve = this.cube.getFaces();
        if (!Solver.checkFaces(this.facesToSolve)) {
            Integer[][][] integerArray = this.facesToSolve;
            synchronized (this.facesToSolve) {
                int i;
                this.solving = true;
                this.bruteMinimumSteps = Integer.MAX_VALUE;
                this.solvedJobs = new ArrayList<List<Map<String, Integer>>>();
                this.foundlist.clear();
                this.jobList.clear();
                for (Map<String, Integer> job : Solver.createPossibilities(this.facesToSolve)) {
                    this.jobList.add(new SolverJob(this.facesToSolve, job));
                }
                int numThreads = Runtime.getRuntime().availableProcessors();
                this.solvers = new SolverThread[numThreads];
                for (i = 0; i < numThreads; ++i) {
                    this.solvers[i] = new SolverThread(this);
                    this.solvers[i].setName("Solver " + i);
                }
                System.out.println("All threads created");
                for (i = 0; i < numThreads; ++i) {
                    this.solvers[i].start();
                }
                System.out.println("All threads running");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bruteCallback(List<Map<String, Integer>> solvedJob) {
        if (solvedJob != null) {
            List<List<Map<String, Integer>>> list = this.solvedJobs;
            synchronized (list) {
                this.solvedJobs.add(solvedJob);
            }
        }
        if (this.bruteCallbackThread != null && this.bruteCallbackThread.isAlive()) {
            return;
        }
        this.bruteCallbackThread = new BruteCallbackThread(this);
        this.bruteCallbackThread.start();
    }

    protected int getBruteMinimumSteps() {
        return this.bruteMinimumSteps;
    }
}

