/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.game.solver.brute;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import rubikscube.game.CubeMath;

class SolverJob {
    private Integer[][][] faces;
    private List<Map<String, Integer>> history;

    public SolverJob(Integer[][][] faces, Map<String, Integer> history) {
        this.faces = CubeMath.rotateCube(faces, history);
        this.history = new ArrayList<Map<String, Integer>>();
        this.history.add(history);
    }

    public SolverJob(Integer[][][] faces, List<Map<String, Integer>> history) {
        int x;
        int face;
        this.faces = new Integer[6][faces[0].length][faces[0].length];
        for (face = 0; face < 6; ++face) {
            for (x = 0; x < faces[0].length; ++x) {
                System.arraycopy(faces[face][x], 0, this.faces[face][x], 0, faces[0].length);
            }
        }
        for (face = 0; face < 6; ++face) {
            for (x = 0; x < faces[0].length; ++x) {
                System.arraycopy(faces[face][x], 0, this.faces[face][x], 0, faces[0].length);
            }
        }
        this.history = new ArrayList<Map<String, Integer>>();
        for (int i = 0; i < history.size(); ++i) {
            this.history.add(history.get(i));
        }
    }

    public void setFaces(Integer[][][] newFaces) {
        this.faces = newFaces;
    }

    public Integer[][][] getFaces() {
        return this.faces;
    }

    public void addHistory(Map<String, Integer> newHistory) {
        this.history.add(newHistory);
    }

    public List<Map<String, Integer>> getHistory() {
        return this.history;
    }
}

