/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.game.solver.brute;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import rubikscube.game.CubeMath;
import rubikscube.game.solver.brute.Solver;
import rubikscube.game.solver.brute.SolverJob;

class SolverThread
extends Thread {
    private boolean run = true;
    private boolean pause = false;
    private boolean running = false;
    private Solver owner;

    public SolverThread(Solver owner) {
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SolverJob currentJob = null;
        while (this.run) {
            int i;
            if (this.pause) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(SolverThread.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            this.running = true;
            if (this.owner.jobList.isEmpty()) {
                this.running = false;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {}
                continue;
            }
            List<SolverJob> ex = this.owner.jobList;
            synchronized (ex) {
                currentJob = this.owner.jobList.get(0);
                this.owner.jobList.remove(currentJob);
            }
            Integer[][][] faces = currentJob.getFaces();
            List<Map<String, Integer>> history = currentJob.getHistory();
            Map<String, Integer>[] possibilities = Solver.createPossibilities(faces);
            SolverJob[] newJobs = new SolverJob[possibilities.length];
            List<String> list = this.owner.foundlist;
            synchronized (list) {
                for (i = 0; i < possibilities.length; ++i) {
                    SolverJob newJob = new SolverJob(faces, history);
                    newJob.setFaces(CubeMath.rotateCube(newJob.getFaces(), possibilities[i]));
                    newJob.addHistory(possibilities[i]);
                    String sfaces = this.facetostring(newJob.getFaces());
                    if (this.owner.foundlist.contains(sfaces)) continue;
                    newJobs[i] = newJob;
                    this.owner.foundlist.add(sfaces);
                }
            }
            boolean[] solved = new boolean[possibilities.length];
            for (i = 0; i < possibilities.length; ++i) {
                if (newJobs[i] == null || !Solver.checkFaces(newJobs[i].getFaces())) continue;
                this.owner.bruteCallback(newJobs[i].getHistory());
                solved[i] = true;
            }
            int steps = this.owner.getBruteMinimumSteps();
            List<SolverJob> list2 = this.owner.jobList;
            synchronized (list2) {
                for (int i2 = 0; i2 < possibilities.length; ++i2) {
                    if (newJobs[i2] == null || solved[i2] || newJobs[i2].getHistory().size() >= steps) continue;
                    this.owner.jobList.add(newJobs[i2]);
                }
                if (this.owner.jobList.isEmpty()) {
                    this.owner.bruteCallback(null);
                }
            }
            currentJob = null;
            this.running = false;
        }
    }

    private String facetostring(Integer[][][] faces) {
        String ret = "";
        for (int face = 0; face < 6; ++face) {
            for (int x = 0; x < faces[0][0].length; ++x) {
                for (int y = 0; y < faces[0][0].length; ++y) {
                    ret = ret + faces[face][x][y];
                }
            }
        }
        return ret;
    }

    public void requestPause() {
        this.pause = true;
    }

    public boolean pauseRequested() {
        return this.pause;
    }

    public void waitForPause() throws InterruptedException {
        if (this.pauseRequested()) {
            while (this.running) {
                Thread.sleep(10L);
            }
        }
    }

    public void requestContinue() {
        this.pause = false;
    }

    public boolean continueRequested() {
        return !this.pause;
    }

    public void requestStop() {
        this.run = false;
    }

    public boolean stopRequested() {
        return !this.run;
    }

    public void waitForStop() throws InterruptedException {
        if (this.stopRequested()) {
            while (this.running) {
                Thread.sleep(10L);
            }
        }
    }
}

