/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.game.solver.howtocube;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rubikscube.game.CubeMath;
import rubikscube.game.RubiksCube;
import rubikscube.game.solver.Solution;
import rubikscube.game.solver.SolutionStep;
import rubikscube.game.solver.Solver;
import rubikscube.game.solver.SolverManager;

public class HTCSolver
extends Solver {
    private static boolean registered = false;
    private JPanel description = new JPanel();
    private RubiksCube rc;

    public static void registerSolver() {
        if (registered) {
            return;
        }
        SolverManager.addSolver(new HTCSolver());
        registered = true;
    }

    private HTCSolver() {
        this.description.setBackground(Color.WHITE);
        this.description.setLayout(new BoxLayout(this.description, 1));
        this.description.add(Box.createVerticalGlue());
        for (String s : new String[]{"L\u00f6ser 3x3x3 kuber med hj\u00e4lp av guiden fr\u00e5n", "www.howtocube.com"}) {
            Box b = Box.createHorizontalBox();
            JLabel label = new JLabel(s);
            label.setHorizontalAlignment(0);
            b.add(Box.createHorizontalGlue());
            b.add(label);
            b.add(Box.createHorizontalGlue());
            this.description.add(b);
        }
        this.description.add(Box.createVerticalGlue());
    }

    @Override
    public String getName() {
        return "How to cube";
    }

    @Override
    public JPanel getDescription() {
        return this.description;
    }

    @Override
    public void init(RubiksCube rc) {
        this.rc = rc;
    }

    @Override
    public boolean canSolve() {
        return this.rc.getSize() == 3;
    }

    @Override
    public Solution solveCube() {
        this.rc.waitForRotation();
        Integer[][][] cube = this.rc.getFaces();
        Solution sol = new Solution();
        if (RubiksCube.isSolved(cube)) {
            SolutionStep ss = new SolutionStep("Kuben \u00e4r redan l\u00f6st!", null, false);
            sol.addSolutionStep(ss);
            return sol;
        }
        if ((cube = this.step1(cube, sol)) == null) {
            return sol;
        }
        if ((cube = this.step2(cube, sol)) == null) {
            return sol;
        }
        if ((cube = this.step3(cube, sol)) == null) {
            return sol;
        }
        if ((cube = this.step4(cube, sol)) == null) {
            return sol;
        }
        if ((cube = this.step5(cube, sol)) == null) {
            return sol;
        }
        cube = this.step6(cube, sol);
        return sol;
    }

    private String clr(int c) {
        return RubiksCube.COLOR_NAMES[c].toLowerCase();
    }

    private Map<String, Integer> createDetailsFace(int face, int direction) {
        HashMap<String, Integer> details = new HashMap<String, Integer>();
        details.put("method", 10);
        details.put("face", face);
        details.put("direction", direction);
        return details;
    }

    private Map<String, Integer> createDetailsRow(int face, int row, int direction) {
        HashMap<String, Integer> details = new HashMap<String, Integer>();
        details.put("method", 11);
        details.put("face", face);
        details.put("rowcolumn", row);
        details.put("direction", direction);
        return details;
    }

    private Map<String, Integer> createDetailsColumn(int face, int column, int direction) {
        HashMap<String, Integer> details = new HashMap<String, Integer>();
        details.put("method", 12);
        details.put("face", face);
        details.put("rowcolumn", column);
        details.put("direction", direction);
        return details;
    }

    private Map<String, Integer> reverseDetails(Map<String, Integer> details) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("method", details.get("method"));
        ret.put("face", details.get("face"));
        switch (details.get("direction")) {
            case 0: {
                ret.put("direction", 1);
                break;
            }
            case 1: {
                ret.put("direction", 0);
                break;
            }
            case 2: {
                ret.put("direction", 3);
                break;
            }
            case 3: {
                ret.put("direction", 2);
            }
        }
        return ret;
    }

    private Integer[][][] step1(Integer[][][] cube, Solution sol) {
        int targetColor = cube[0][1][1];
        SolutionStep ss = new SolutionStep("V\u00e4lj en centerf\u00e4rg som ska vara din \u00f6versta sida, i det h\u00e4r fallet har jag valt " + this.clr(targetColor) + ".", new int[][]{{0, 1, 1}}, true);
        ss.addRotation(0, 2);
        sol.addSolutionStep(ss);
        ss = new SolutionStep("Av denna f\u00e4rg ska vi nu g\u00f6ra ett kors d\u00e4r kanterna st\u00e4mmer \u00f6verens med sina respektive centerf\u00e4rger.", new int[][]{{0, 1, 1}, {1, 1, 1}, {2, 1, 1}, {3, 1, 1}, {5, 1, 1}, {0, 1, 0}, {0, 1, 2}, {0, 0, 1}, {0, 2, 1}}, true);
        ss.addRotation(0, 1);
        ss.addRotation(0, 2);
        ss.addRotation(0, 3);
        ss.addRotation(0, 5);
        sol.addSolutionStep(ss);
        for (int i : new int[]{1, 2, 3, 5}) {
            if (!RubiksCube.isSolved(cube = this.step1a(targetColor, cube[i][1][1], i, cube, sol))) continue;
            ss = new SolutionStep("Kuben \u00e4r l\u00f6st!", null, false);
            sol.addSolutionStep(ss);
            return null;
        }
        ss = new SolutionStep("Nu n\u00e4r korset \u00e4r f\u00e4rdigt forts\u00e4tter vi med att l\u00f6sa \u00f6versta lagret.", new int[][]{{0, 0, 0}, {0, 2, 0}, {0, 0, 2}, {0, 2, 2}}, true);
        ss.addRotation(0, 1);
        ss.addRotation(0, 2);
        ss.addRotation(0, 3);
        ss.addRotation(0, 5);
        sol.addSolutionStep(ss);
        for (int[] i : new int[][]{{1, 2}, {2, 3}, {3, 5}, {5, 1}}) {
            int face1Color = cube[i[0]][1][1];
            int face2Color = cube[i[1]][1][1];
            ss = new SolutionStep("Leta efter h\u00f6rnet med f\u00e4rgerna " + this.clr(targetColor) + ", " + this.clr(face1Color) + " och " + this.clr(face2Color) + ".", null, true);
            sol.addSolutionStep(ss);
            cube = this.step1b(targetColor, face1Color, i[0], face2Color, i[1], cube, sol);
            if (!RubiksCube.isSolved(cube)) continue;
            ss = new SolutionStep("Kuben \u00e4r l\u00f6st!", null, false);
            sol.addSolutionStep(ss);
            return null;
        }
        return cube;
    }

    private int checkEdge(int targetColor, int faceColor, int face, Integer[][][] cube) {
        int tc = -1;
        int fc = -1;
        switch (face) {
            case 1: {
                tc = cube[0][0][1];
                fc = cube[1][1][0];
                break;
            }
            case 2: {
                tc = cube[0][1][2];
                fc = cube[2][1][0];
                break;
            }
            case 3: {
                tc = cube[0][2][1];
                fc = cube[3][1][0];
                break;
            }
            case 5: {
                tc = cube[0][1][0];
                fc = cube[5][1][2];
            }
        }
        return tc == targetColor && fc == faceColor ? 1 : (tc == faceColor && fc == targetColor ? 2 : 0);
    }

    private void fixEdge(int face, SolutionStep ss, int type) {
        if (face == 5) {
            ss.addStep(this.createDetailsFace(face, 0), type);
            ss.addStep(this.createDetailsRow(face, 2, 1), type);
            ss.addStep(this.createDetailsColumn(face, 2, 3), type);
            ss.addStep(this.createDetailsRow(face, 2, 0), type);
            return;
        }
        ss.addStep(this.createDetailsFace(face, 0), type);
        ss.addStep(this.createDetailsRow(face, 0, 0), type);
        ss.addStep(this.createDetailsColumn(face, 0, 2), type);
        ss.addStep(this.createDetailsRow(face, 0, 1), type);
    }

    private int[][] findEdge(Integer[][][] cube, int c1, int c2) {
        int f1 = 0;
        int x1 = 0;
        int y1 = 0;
        int f2 = 0;
        int x2 = 0;
        int y2 = 0;
        for (int i : new int[]{1, 2, 3, 5}) {
            switch (i) {
                case 1: {
                    f1 = 1;
                    x1 = 0;
                    y1 = 1;
                    f2 = 5;
                    x2 = 0;
                    y2 = 1;
                    break;
                }
                case 2: {
                    f1 = 2;
                    x1 = 0;
                    y1 = 1;
                    f2 = 1;
                    x2 = 2;
                    y2 = 1;
                    break;
                }
                case 3: {
                    f1 = 3;
                    x1 = 0;
                    y1 = 1;
                    f2 = 2;
                    x2 = 2;
                    y2 = 1;
                    break;
                }
                case 5: {
                    f1 = 5;
                    x1 = 2;
                    y1 = 1;
                    f2 = 3;
                    x2 = 2;
                    y2 = 1;
                }
            }
            int r1 = cube[f1][x1][y1];
            int r2 = cube[f2][x2][y2];
            if (r1 == c1 && r2 == c2 || r1 == c2 && r2 == c1) {
                return new int[][]{{f1, x1, y1}, {f2, x2, y2}};
            }
            switch (i) {
                case 1: {
                    f1 = 1;
                    x1 = 1;
                    y1 = 0;
                    f2 = 0;
                    x2 = 0;
                    y2 = 1;
                    break;
                }
                case 2: {
                    f1 = 2;
                    x1 = 1;
                    y1 = 0;
                    f2 = 0;
                    x2 = 1;
                    y2 = 2;
                    break;
                }
                case 3: {
                    f1 = 3;
                    x1 = 1;
                    y1 = 0;
                    f2 = 0;
                    x2 = 2;
                    y2 = 1;
                    break;
                }
                case 5: {
                    f1 = 5;
                    x1 = 1;
                    y1 = 2;
                    f2 = 0;
                    x2 = 1;
                    y2 = 0;
                }
            }
            r1 = cube[f1][x1][y1];
            r2 = cube[f2][x2][y2];
            if (r1 == c1 && r2 == c2 || r1 == c2 && r2 == c1) {
                return new int[][]{{f1, x1, y1}, {f2, x2, y2}};
            }
            switch (i) {
                case 1: {
                    f1 = 1;
                    x1 = 1;
                    y1 = 2;
                    f2 = 4;
                    x2 = 0;
                    y2 = 1;
                    break;
                }
                case 2: {
                    f1 = 2;
                    x1 = 1;
                    y1 = 2;
                    f2 = 4;
                    x2 = 1;
                    y2 = 0;
                    break;
                }
                case 3: {
                    f1 = 3;
                    x1 = 1;
                    y1 = 2;
                    f2 = 4;
                    x2 = 2;
                    y2 = 1;
                    break;
                }
                case 5: {
                    f1 = 5;
                    x1 = 1;
                    y1 = 0;
                    f2 = 4;
                    x2 = 1;
                    y2 = 2;
                }
            }
            r1 = cube[f1][x1][y1];
            r2 = cube[f2][x2][y2];
            if ((r1 != c1 || r2 != c2) && (r1 != c2 || r2 != c1)) continue;
            return new int[][]{{f1, x1, y1}, {f2, x2, y2}};
        }
        return null;
    }

    private Integer[][][] step1a(int targetColor, int faceColor, int face, Integer[][][] cube, Solution sol) {
        SolutionStep ss = new SolutionStep("Leta efter en kant, inte ett h\u00f6rn, som \u00e4r b\u00e5de " + this.clr(targetColor) + " och " + this.clr(faceColor) + ".", null, true);
        sol.addSolutionStep(ss);
        int[][] high = new int[1][3];
        high[0][0] = 0;
        switch (face) {
            case 1: {
                high[0][1] = 0;
                high[0][2] = 1;
                break;
            }
            case 2: {
                high[0][1] = 1;
                high[0][2] = 2;
                break;
            }
            case 3: {
                high[0][1] = 2;
                high[0][2] = 1;
                break;
            }
            case 5: {
                high[0][1] = 1;
                high[0][2] = 0;
            }
        }
        int edgeState = this.checkEdge(targetColor, faceColor, face, cube);
        if (edgeState == 1) {
            ss = new SolutionStep("Kanten ligger redan p\u00e5 r\u00e4tt plats, vi kan g\u00e5 vidare!", high, true);
            ss.addRotation(0, face);
            sol.addSolutionStep(ss);
            return cube;
        }
        if (edgeState == 2) {
            ss = new SolutionStep("Kanten ligger p\u00e5 r\u00e4tt plats, men \u00e4r felvriden. Snurra kuben p\u00e5 f\u00f6ljande 4 s\u00e4tt f\u00f6r att fixa den!", high, false);
            ss.addRotation(0, face);
            this.fixEdge(face, ss, 0);
            for (int i = 0; i < ss.getSteps(); ++i) {
                cube = CubeMath.rotateCube(cube, ss.getStep(i));
            }
            sol.addSolutionStep(ss);
            return cube;
        }
        int[][] edge = this.findEdge(cube, targetColor, faceColor);
        ss = new SolutionStep("H\u00f6rnet finns h\u00e4r men beh\u00f6ver flyttas till r\u00e4tt plats. Gl\u00f6m inte att snurra tillbaks sidor som du anv\u00e4nt f\u00f6r att f\u00f6rflytta kanten!", edge, false);
        ss.addRotation(0, edge[0][0]);
        ArrayList<Integer[][][]> cubes = new ArrayList<Integer[][][]>();
        ArrayList<Integer> details = new ArrayList<Integer>();
        Integer[][][] backup = cube;
        for (int i = 0; i < 4; ++i) {
            int x;
            int a;
            int floor = 0;
            for (int a2 = 0; a2 < i; ++a2) {
                floor += (int)Math.pow(4.0, a2 + 1);
            }
            int n = (int)Math.pow(4.0, i + 1);
            for (a = 0; a < n; ++a) {
                x = floor - (int)Math.pow(4.0, i) + a / 4;
                Integer[][][] integerArray = cube = i == 0 ? cube : (Integer[][][])cubes.get(x);
                if (cube == null) {
                    cubes.add(null);
                    details.add(0);
                    details.add(0);
                    continue;
                }
                edge = this.findEdge(cube, targetColor, faceColor);
                if (a % 4 < 2) {
                    if (edge[0][0] != 0) {
                        cubes.add(CubeMath.rotateFace(cube, edge[0][0], a % 4 == 0 ? 0 : 1));
                        details.add(edge[0][0]);
                        details.add(a % 4 == 0 ? 0 : 1);
                        continue;
                    }
                    cubes.add(null);
                    details.add(0);
                    details.add(0);
                    continue;
                }
                if (edge[1][0] != 0) {
                    cubes.add(CubeMath.rotateFace(cube, edge[1][0], a % 4 == 2 ? 0 : 1));
                    details.add(edge[1][0]);
                    details.add(a % 4 == 2 ? 0 : 1);
                    continue;
                }
                cubes.add(null);
                details.add(0);
                details.add(0);
            }
            for (a = floor; a < floor + n; ++a) {
                if (cubes.get(a) == null || (edgeState = this.checkEdge(targetColor, faceColor, face, (Integer[][][])cubes.get(a))) != 1 && edgeState != 2) continue;
                edge = this.findEdge((Integer[][][])cubes.get(a), targetColor, faceColor);
                a -= floor;
                for (x = i; x >= 0; --x) {
                    floor = 0;
                    for (int b = 0; b < x; ++b) {
                        floor += (int)Math.pow(4.0, b + 1);
                    }
                    ss.addStep(0, this.createDetailsFace((Integer)details.get((floor + a) * 2), (Integer)details.get((floor + a) * 2 + 1)), 0);
                    a /= 4;
                }
                for (x = ss.getSteps() - 1; x >= 0; --x) {
                    if (ss.getStep(x).get("face") >= face || ss.getStep(x).get("face") == 4) continue;
                    ss.addStep(this.reverseDetails(ss.getStep(x)), 0);
                }
                cube = backup;
                for (x = 0; x < ss.getSteps(); ++x) {
                    cube = CubeMath.rotateCube(cube, ss.getStep(x));
                }
                sol.addSolutionStep(ss);
                if (edgeState == 2) {
                    ss = new SolutionStep("Kanten \u00e4r nu p\u00e5 r\u00e4tt plats, men \u00e4r felvriden. G\u00f6r f\u00f6ljande fyra steg f\u00f6r att fixa detta!", edge, false);
                    this.fixEdge(face, ss, 0);
                    for (x = 0; x < ss.getSteps(); ++x) {
                        cube = CubeMath.rotateCube(cube, ss.getStep(x));
                    }
                } else {
                    ss = new SolutionStep("Kanten \u00e4r nu p\u00e5 r\u00e4tt plats, vi kan g\u00e5 vidare!", edge, false);
                }
                ss.addRotation(0, face);
                sol.addSolutionStep(ss);
                return cube;
            }
        }
        throw new IllegalArgumentException("Detta ska inte h\u00e4nda :(");
    }

    private int[][] findBottomCorner(int c1, int c2, int c3, Integer[][][] cube) {
        int r3;
        int r2;
        int r1 = cube[5][0][0];
        if (this.findCorner_0(c1, c2, c3, r1, r2 = cube[1][0][2].intValue(), r3 = cube[4][0][2].intValue())) {
            return new int[][]{{1, 0, 2}, {5, 0, 0}, {4, 0, 2}};
        }
        r1 = cube[1][2][2];
        if (this.findCorner_0(c1, c2, c3, r1, r2 = cube[2][0][2].intValue(), r3 = cube[4][0][0].intValue())) {
            return new int[][]{{2, 0, 2}, {1, 2, 2}, {4, 0, 0}};
        }
        r1 = cube[2][2][2];
        if (this.findCorner_0(c1, c2, c3, r1, r2 = cube[3][0][2].intValue(), r3 = cube[4][2][0].intValue())) {
            return new int[][]{{3, 0, 2}, {2, 2, 2}, {4, 2, 0}};
        }
        r1 = cube[3][2][2];
        if (this.findCorner_0(c1, c2, c3, r1, r2 = cube[4][2][2].intValue(), r3 = cube[5][2][0].intValue())) {
            return new int[][]{{5, 2, 0}, {3, 2, 2}, {4, 2, 2}};
        }
        return null;
    }

    private int[][] findTopCorner(int c1, int c2, int c3, Integer[][][] cube) {
        int r3;
        int r2;
        int r1 = cube[0][0][0];
        if (this.findCorner_0(c1, c2, c3, r1, r2 = cube[1][0][0].intValue(), r3 = cube[5][0][2].intValue())) {
            return new int[][]{{0, 0, 0}, {5, 0, 2}, {1, 0, 0}};
        }
        r1 = cube[0][0][2];
        if (this.findCorner_0(c1, c2, c3, r1, r2 = cube[1][2][0].intValue(), r3 = cube[2][0][0].intValue())) {
            return new int[][]{{0, 0, 2}, {1, 2, 0}, {2, 0, 0}};
        }
        r1 = cube[0][2][2];
        if (this.findCorner_0(c1, c2, c3, r1, r2 = cube[2][2][0].intValue(), r3 = cube[3][0][0].intValue())) {
            return new int[][]{{0, 2, 2}, {2, 2, 0}, {3, 0, 0}};
        }
        r1 = cube[0][2][0];
        if (this.findCorner_0(c1, c2, c3, r1, r2 = cube[3][2][0].intValue(), r3 = cube[5][2][2].intValue())) {
            return new int[][]{{0, 2, 0}, {3, 2, 0}, {5, 2, 2}};
        }
        return null;
    }

    private boolean findCorner_0(int c1, int c2, int c3, int r1, int r2, int r3) {
        return r1 == c1 && r2 == c2 && r3 == c3 || r1 == c1 && r3 == c2 && r2 == c3 || r2 == c1 && r3 == c2 && r1 == c3 || r2 == c1 && r1 == c2 && r3 == c3 || r3 == c1 && r1 == c2 && r2 == c3 || r3 == c1 && r2 == c2 && r1 == c3;
    }

    private boolean cornerInPlace(int a0, int a1, int a2, int f1, int f2) {
        return a0 == f1 && a1 == f2 || a0 == f2 && a1 == f1 || a0 == f1 && a2 == f2 || a0 == f2 && a2 == f1 || a1 == f1 && a2 == f2 || a1 == f2 && a2 == f1;
    }

    private Integer[][][] step1b(int targetColor, int face1Color, int face1, int face2Color, int face2, Integer[][][] cube, Solution sol) {
        int[][] arr = this.findBottomCorner(targetColor, face1Color, face2Color, cube);
        if (arr != null) {
            SolutionStep ss;
            if (!this.cornerInPlace(arr[0][0], arr[1][0], arr[2][0], face1, face2)) {
                String snurr;
                ss = new SolutionStep(arr, false);
                ss.addRotation(0, arr[0][0]);
                Map<String, Integer> details = this.createDetailsFace(4, 0);
                cube = CubeMath.rotateCube(cube, details);
                arr = this.findBottomCorner(targetColor, face1Color, face2Color, cube);
                if (this.cornerInPlace(arr[0][0], arr[1][0], arr[2][0], face1, face2)) {
                    snurr = "\u00e5t v\u00e4nster.";
                    ss.addStep(details, 0);
                } else {
                    arr = this.findBottomCorner(targetColor, face1Color, face2Color, cube = CubeMath.rotateCube(cube, details));
                    if (this.cornerInPlace(arr[0][0], arr[1][0], arr[2][0], face1, face2)) {
                        snurr = "180 grader.";
                        ss.addStep(details, 0);
                        ss.addStep(details, 0);
                    } else {
                        cube = CubeMath.rotateCube(cube, details);
                        arr = this.findBottomCorner(targetColor, face1Color, face2Color, cube);
                        details.put("direction", 1);
                        snurr = "\u00e5t h\u00f6ger.";
                        ss.addStep(details, 0);
                    }
                }
                ss.setDescription("H\u00f6rnet finns h\u00e4r, i det nedersta lagret, men egentligen borde den ligga rakt under sin r\u00e4tta plats. Snurra det understa lagret " + snurr);
                sol.addSolutionStep(ss);
            } else {
                ss = new SolutionStep("H\u00f6rnet finns h\u00e4r, rakt under sin egentliga position, perfekt!", arr, false);
                ss.addRotation(0, arr[0][0]);
                sol.addSolutionStep(ss);
            }
            if (cube[arr[0][0]][arr[0][1]][arr[0][2]] == targetColor) {
                ss = new SolutionStep("Som du ser st\u00e4mmer f\u00e4rgen p\u00e5 undersidan av h\u00f6rnet \u00f6verens med siden till h\u00f6ger(Upp och ner).", new int[][]{arr[0], {face2, 1, 1}}, false);
                ss.addRotation(3, face2);
                sol.addSolutionStep(ss);
                ss = new SolutionStep("G\u00f6r f\u00f6ljande tre steg f\u00f6r att flytta h\u00f6rnet till sin r\u00e4tta plats.", arr, false);
                this.rotateCorner0(arr[1][0], ss, 2);
            } else if (cube[arr[1][0]][arr[1][1]][arr[1][2]] == targetColor) {
                ss = new SolutionStep("Som du ser st\u00e4mmer f\u00e4rgen p\u00e5 undersidan av h\u00f6rnet \u00f6verens med siden till v\u00e4nster(Upp och ner).", new int[][]{arr[0], {face1, 1, 1}}, false);
                ss.addRotation(1, face1);
                sol.addSolutionStep(ss);
                ss = new SolutionStep("G\u00f6r f\u00f6ljande tre steg f\u00f6r att flytta h\u00f6rnet till sin r\u00e4tta plats.", arr, false);
                this.rotateCorner1(arr[1][0], ss, 2);
            } else if (cube[arr[2][0]][arr[2][1]][arr[2][2]] == targetColor) {
                ss = new SolutionStep("Som du ser st\u00e4mmer f\u00e4rgen p\u00e5 undersidan av h\u00f6rnet \u00f6verens med v\u00e5rt \u00f6versta lager. Vi m\u00e5ste d\u00e4rf\u00f6r g\u00f6ra f\u00f6ljande fyra steg f\u00f6r att f\u00f6rs\u00e4tta.", new int[][]{arr[0], {0, 1, 1}}, false);
                ss.addRotation(2, face1);
                this.rotateCorner2(arr[1][0], ss, 2);
                for (int i = 0; i < ss.getSteps(); ++i) {
                    cube = CubeMath.rotateCube(cube, ss.getStep(i));
                }
                sol.addSolutionStep(ss);
                ss = new SolutionStep("Leta nu upp samma h\u00f6rn igen med f\u00e4rgerna " + this.clr(targetColor) + ", " + this.clr(face1Color) + " och " + this.clr(face2Color) + ".", null, false);
                sol.addSolutionStep(ss);
                return this.step1b(targetColor, face1Color, face1, face2Color, face2, cube, sol);
            }
            ss.addRotation(2, arr[1][0]);
            for (int i = 0; i < ss.getSteps(); ++i) {
                cube = CubeMath.rotateCube(cube, ss.getStep(i));
            }
            sol.addSolutionStep(ss);
            return cube;
        }
        arr = this.findTopCorner(targetColor, face1Color, face2Color, cube);
        if (arr[0][0] != 0 || arr[1][0] != face1 || arr[2][0] != face2 || cube[0][arr[0][1]][arr[0][2]] != targetColor || cube[face1][arr[1][1]][arr[1][2]] != face1Color || cube[face2][arr[2][1]][arr[2][2]] != face2Color) {
            SolutionStep ss = new SolutionStep("H\u00f6rnet finns h\u00e4r i det \u00f6versta lagret, men den \u00e4r p\u00e5 fel plats! G\u00f6r dessa tre steg med h\u00f6rnet mot dig f\u00f6r att f\u00e5 ner h\u00f6rnet.", arr, false);
            ss.addRotation(0, arr[1][0]);
            this.rotateCorner0(arr[1][0], ss, 0);
            for (int i = 0; i < ss.getSteps(); ++i) {
                cube = CubeMath.rotateCube(cube, ss.getStep(i));
            }
            sol.addSolutionStep(ss);
            ss = new SolutionStep("Leta nu upp samma h\u00f6rn igen med f\u00e4rgerna " + this.clr(targetColor) + ", " + this.clr(face1Color) + " och " + this.clr(face2Color) + ".", null, false);
            sol.addSolutionStep(ss);
            return this.step1b(targetColor, face1Color, face1, face2Color, face2, cube, sol);
        }
        SolutionStep ss = new SolutionStep("H\u00f6rnet finns h\u00e4r, p\u00e5 sin r\u00e4tta plats! Vi kan f\u00f6rs\u00e4tta.", arr, false);
        ss.addRotation(0, face2);
        sol.addSolutionStep(ss);
        return cube;
    }

    private void rotateCorner0(int face, SolutionStep ss, int type) {
        if (face == 5) {
            ss.addStep(this.createDetailsColumn(face, 0, 2), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsColumn(face, 0, 3), type);
            return;
        }
        ss.addStep(this.createDetailsColumn(face, 2, 3), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsColumn(face, 2, 2), type);
    }

    private void rotateCorner1(int face, SolutionStep ss, int type) {
        if (face == 5) {
            ss.addStep(this.createDetailsFace(face, 1), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsFace(face, 0), type);
            return;
        }
        ss.addStep(this.createDetailsFace(face, 1), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsFace(face, 0), type);
    }

    private void rotateCorner2(int face, SolutionStep ss, int type) {
        if (face == 5) {
            ss.addStep(this.createDetailsColumn(face, 0, 2), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsColumn(face, 0, 3), type);
            return;
        }
        ss.addStep(this.createDetailsColumn(face, 2, 3), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsColumn(face, 2, 2), type);
    }

    private Integer[][][] step2(Integer[][][] cube, Solution sol) {
        SolutionStep ss = new SolutionStep("\u00d6versta lagret \u00e4r nu f\u00e4rdigt, dags att l\u00f6sa det andra!", new int[][]{{1, 0, 1}, {2, 0, 1}, {3, 0, 1}, {5, 2, 1}}, false);
        ss.addRotation(0, 1);
        ss.addRotation(0, 2);
        ss.addRotation(0, 3);
        ss.addRotation(0, 5);
        sol.addSolutionStep(ss);
        for (int[] i : new int[][]{{1, 2}, {2, 3}, {3, 5}, {5, 1}}) {
            int c1 = cube[i[0]][1][1];
            int c2 = cube[i[1]][1][1];
            ss = new SolutionStep("Leta efter en kant, inte ett h\u00f6rn med f\u00e4rgerna " + this.clr(c1) + " och " + this.clr(c2) + ".", null, false);
            sol.addSolutionStep(ss);
            cube = this.step2_0(c1, i[0], c2, i[1], cube, sol);
            if (!RubiksCube.isSolved(cube)) continue;
            ss = new SolutionStep("Kuben \u00e4r l\u00f6st!", null, false);
            sol.addSolutionStep(ss);
            return null;
        }
        return cube;
    }

    private int[][] findMiddleEdge(int c1, int c2, Integer[][][] cube) {
        int r1 = cube[1][2][1];
        int r2 = cube[2][0][1];
        if (r1 == c1 && r2 == c2 || r2 == c1 && r1 == c2) {
            return new int[][]{{1, 2, 1}, {2, 0, 1}};
        }
        r1 = cube[2][2][1];
        r2 = cube[3][0][1];
        if (r1 == c1 && r2 == c2 || r2 == c1 && r1 == c2) {
            return new int[][]{{2, 2, 1}, {3, 0, 1}};
        }
        r1 = cube[3][2][1];
        r2 = cube[5][2][1];
        if (r1 == c1 && r2 == c2 || r2 == c1 && r1 == c2) {
            return new int[][]{{3, 2, 1}, {5, 2, 1}};
        }
        r1 = cube[5][0][1];
        r2 = cube[1][0][1];
        if (r1 == c1 && r2 == c2 || r2 == c1 && r1 == c2) {
            return new int[][]{{5, 0, 1}, {1, 0, 1}};
        }
        return null;
    }

    private int[][] findBottomEdge(int c1, int c2, Integer[][][] cube) {
        int r1 = cube[1][1][2];
        int r2 = cube[4][0][1];
        if (r1 == c1 && r2 == c2 || r2 == c1 && r1 == c2) {
            return new int[][]{{1, 1, 2}, {4, 0, 1}};
        }
        r1 = cube[2][1][2];
        r2 = cube[4][1][0];
        if (r1 == c1 && r2 == c2 || r2 == c1 && r1 == c2) {
            return new int[][]{{2, 1, 2}, {4, 1, 0}};
        }
        r1 = cube[3][1][2];
        r2 = cube[4][2][1];
        if (r1 == c1 && r2 == c2 || r2 == c1 && r1 == c2) {
            return new int[][]{{3, 1, 2}, {4, 2, 1}};
        }
        r1 = cube[5][1][0];
        r2 = cube[4][1][2];
        if (r1 == c1 && r2 == c2 || r2 == c1 && r1 == c2) {
            return new int[][]{{5, 1, 0}, {4, 1, 2}};
        }
        return null;
    }

    private boolean middleEdgeInPlace(int[][] edge, int c1, int f1, int c2, int f2, Integer[][][] cube) {
        return edge[0][0] == f1 && edge[1][0] == f2 && cube[edge[0][0]][edge[0][1]][edge[0][2]] == c1 && cube[edge[1][0]][edge[1][1]][edge[1][2]] == c2;
    }

    private boolean bottomEdgeInPlace(int[][] edge, int c1, int f1, int c2, int f2, Integer[][][] cube) {
        return edge[0][0] == f1 && cube[edge[0][0]][edge[0][1]][edge[0][2]] == c1 || edge[0][0] == f2 && cube[edge[0][0]][edge[0][1]][edge[0][2]] == c2;
    }

    private Integer[][][] step2_0(int c1, int f1, int c2, int f2, Integer[][][] cube, Solution sol) {
        int[][] edge = this.findBottomEdge(c1, c2, cube);
        if (edge == null) {
            edge = this.findMiddleEdge(c1, c2, cube);
            if (this.middleEdgeInPlace(edge, c1, f1, c2, f2, cube)) {
                SolutionStep ss = new SolutionStep("Kanten \u00e4r redan p\u00e5 r\u00e4tt plats, vi kan g\u00e5 vidare!", edge, false);
                ss.addRotation(0, edge[1][0]);
                sol.addSolutionStep(ss);
                return cube;
            }
            SolutionStep ss = new SolutionStep("Kanten \u00e4r h\u00e4r, men den \u00e4r inte r\u00e4tt! F\u00f6r att f\u00e5 ner den i understa lagret g\u00f6r f\u00f6ljande 8 steg med kanten mot dig.", edge, false);
            ss.addRotation(0, edge[1][0]);
            this.rotateT0(edge[1][0], ss, 0);
            for (int i = 0; i < ss.getSteps(); ++i) {
                cube = CubeMath.rotateCube(cube, ss.getStep(i));
            }
            sol.addSolutionStep(ss);
            ss = new SolutionStep("Leta upp samma kant igen med f\u00e4rgerna " + this.clr(c1) + " och " + this.clr(c2) + ".", null, false);
            sol.addSolutionStep(ss);
            return this.step2_0(c1, f1, c2, f2, cube, sol);
        }
        SolutionStep ss = new SolutionStep(edge, false);
        ss.addRotation(0, edge[0][0]);
        if (!this.bottomEdgeInPlace(edge, c1, f1, c2, f2, cube)) {
            String snurr;
            Map<String, Integer> details = this.createDetailsFace(4, 0);
            edge = this.findBottomEdge(c1, c2, cube = CubeMath.rotateCube(cube, details));
            if (!this.bottomEdgeInPlace(edge, c1, f1, c2, f2, cube)) {
                edge = this.findBottomEdge(c1, c2, cube = CubeMath.rotateCube(cube, details));
                if (!this.bottomEdgeInPlace(edge, c1, f1, c2, f2, cube)) {
                    cube = CubeMath.rotateCube(cube, details);
                    edge = this.findBottomEdge(c1, c2, cube);
                    details.put("direction", 1);
                    snurr = "\u00e5t h\u00f6ger";
                    ss.addStep(details, 0);
                } else {
                    snurr = "180 grader";
                    ss.addStep(details, 0);
                    ss.addStep(details, 0);
                }
            } else {
                snurr = "\u00e5r v\u00e4nster";
                ss.addStep(details, 0);
            }
            ss.setDescription("Kanten finns h\u00e4r, i det understa lagret. Rotera det understa lagret " + snurr + " f\u00f6r att skapa ett T av f\u00e4rgen " + this.clr(cube[edge[0][0]][edge[0][1]][edge[0][2]]) + ".");
        } else {
            ss.setDescription("Kanten finns h\u00e4r och skapar ett T av f\u00e4rgen " + this.clr(cube[edge[0][0]][edge[0][1]][edge[0][2]]) + ".");
        }
        sol.addSolutionStep(ss);
        if (edge[0][0] == f1) {
            ss = new SolutionStep("Kantens undersida \u00e4r " + this.clr(cube[edge[1][0]][edge[1][1]][edge[1][2]]) + ", vilket st\u00e4mmer \u00f6verens med sidan till h\u00f6ger(Upp och ner).", new int[][]{edge[0], {edge[0][0] == 5 ? 1 : (edge[0][0] == 3 ? 5 : edge[0][0] + 1), 1, 1}}, false);
            ss.addRotation(1, f1);
            sol.addSolutionStep(ss);
            ss = new SolutionStep("Snurra kuben p\u00e5 f\u00f6ljande \u00e5tta s\u00e4tt f\u00f6r att placera kanten r\u00e4tt.", edge, false);
            ss.addRotation(2, f1);
            this.rotateT1(f2, ss, 2);
        } else if (edge[0][0] == f2) {
            ss = new SolutionStep("Kantens undersida \u00e4r " + this.clr(cube[edge[1][0]][edge[1][1]][edge[1][2]]) + ", vilket st\u00e4mmer \u00f6verens med sidan till v\u00e4nster(Upp och ner).", new int[][]{edge[0], {edge[0][0] == 5 ? 3 : (edge[0][0] == 1 ? 5 : edge[0][0] - 1), 1, 1}}, false);
            ss.addRotation(3, f2);
            sol.addSolutionStep(ss);
            ss = new SolutionStep("Snurra kuben p\u00e5 f\u00f6ljande \u00e5tta s\u00e4tt f\u00f6r att placera kanten r\u00e4tt.", edge, false);
            ss.addRotation(0, f2);
            this.rotateT0(f2, ss, 0);
        }
        for (int i = 0; i < ss.getSteps(); ++i) {
            cube = CubeMath.rotateCube(cube, ss.getStep(i));
        }
        sol.addSolutionStep(ss);
        return cube;
    }

    private void rotateT0(int face, SolutionStep ss, int type) {
        if (face == 5) {
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsColumn(face, 2, 3), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsFace(face, 0), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsFace(face, 1), type);
            return;
        }
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsColumn(face, 0, 2), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsFace(face, 0), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsFace(face, 1), type);
    }

    private void rotateT1(int face, SolutionStep ss, int type) {
        if (face == 5) {
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsFace(face, 0), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsFace(face, 1), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsColumn(face, 2, 3), type);
            return;
        }
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsFace(face, 0), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsFace(face, 1), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsColumn(face, 0, 2), type);
    }

    private int[][] findBottomCross(int targetColor, Integer[][][] cube) {
        int r1 = cube[4][1][0];
        int r2 = cube[4][2][1];
        if (r1 == targetColor && r2 == targetColor) {
            return new int[][]{{4, 1, 0}, {4, 2, 1}};
        }
        r1 = cube[4][1][2];
        if (r1 == targetColor && r2 == targetColor) {
            return new int[][]{{4, 2, 1}, {4, 1, 2}};
        }
        r2 = cube[4][0][1];
        if (r1 == targetColor && r2 == targetColor) {
            return new int[][]{{4, 1, 2}, {4, 0, 1}};
        }
        r1 = cube[4][1][0];
        if (r1 == targetColor && r2 == targetColor) {
            return new int[][]{{4, 0, 1}, {4, 1, 0}};
        }
        return null;
    }

    private boolean isBottomCross(int targetColor, Integer[][][] cube) {
        return targetColor == cube[4][1][0] && targetColor == cube[4][2][1] && targetColor == cube[4][1][2] && targetColor == cube[4][0][1];
    }

    private Integer[][][] step3(Integer[][][] cube, Solution sol) {
        int targetColor = cube[4][1][1];
        SolutionStep ss = new SolutionStep("N\u00e4r de \u00f6versta lagren \u00e4r klara \u00e4r det dags att b\u00f6rja jobba p\u00e5 det sista.", null, false);
        sol.addSolutionStep(ss);
        ss = new SolutionStep("Vi b\u00f6rjar med att f\u00f6rs\u00f6ka g\u00f6ra ett kors av " + this.clr(targetColor) + ", men den h\u00e4r g\u00e5ngen beh\u00f6ver den inte g\u00e5 ner \u00f6ver kanterna.", new int[][]{{4, 0, 1}, {4, 1, 2}, {4, 2, 1}, {4, 1, 0}, {4, 1, 1}}, false);
        ss.addRotation(1, 2);
        ss.addRotation(1, 3);
        ss.addRotation(1, 5);
        ss.addRotation(1, 1);
        sol.addSolutionStep(ss);
        if (this.isBottomCross(targetColor, cube)) {
            ss = new SolutionStep("Korset \u00e4r redan f\u00e4rdigt, d\u00e5 kan vi forts\u00e4tta!", null, false);
            sol.addSolutionStep(ss);
            return cube;
        }
        if (RubiksCube.isSolved(cube = this.step3_0(targetColor, cube, sol))) {
            ss = new SolutionStep("Kuben \u00e4r l\u00f6st!", null, false);
            sol.addSolutionStep(ss);
            return null;
        }
        return cube;
    }

    private Integer[][][] step3_0(int targetColor, Integer[][][] cube, Solution sol) {
        if (this.isBottomCross(targetColor, cube)) {
            SolutionStep ss = new SolutionStep("Nu \u00e4r korset klart, dags f\u00f6r n\u00e4st sista steget!", null, false);
            sol.addSolutionStep(ss);
            return cube;
        }
        int[][] bottomCross = this.findBottomCross(targetColor, cube);
        if (bottomCross != null) {
            int face = -1;
            switch (bottomCross[1][1]) {
                case 0: {
                    face = 3;
                    break;
                }
                case 1: {
                    switch (bottomCross[1][2]) {
                        case 0: {
                            face = 5;
                            break;
                        }
                        case 2: {
                            face = 2;
                        }
                    }
                    break;
                }
                case 2: {
                    face = 1;
                }
            }
            SolutionStep ss = new SolutionStep("Med de tre l\u00f6sta bitarna av korset bort fr\u00e5n dig, g\u00f6r f\u00f6ljande sex steg f\u00f6r att f\u00e5 resten av korset p\u00e5 plats.", new int[][]{bottomCross[0], bottomCross[1], {4, 1, 1}}, false);
            ss.addRotation(3, face);
            this.turnCross(face, ss, 3);
            for (int i = 0; i < ss.getSteps(); ++i) {
                cube = CubeMath.rotateCube(cube, ss.getStep(i));
            }
            sol.addSolutionStep(ss);
            return cube;
        }
        SolutionStep ss = new SolutionStep("Eftersom inget kors har b\u00f6rjat visa sig kan du g\u00f6ra dessa sex steg med vilken sida som helst mot dig, bara undersidan fortfarande \u00e4r \u00f6verst. H\u00e4r har vi den " + this.clr(cube[2][1][1]) + " sidan mot oss.", null, false);
        this.turnCross(2, ss, 1);
        for (int i = 0; i < ss.getSteps(); ++i) {
            cube = CubeMath.rotateCube(cube, ss.getStep(i));
        }
        sol.addSolutionStep(ss);
        return this.step3_0(targetColor, cube, sol);
    }

    private void turnCross(int face, SolutionStep ss, int type) {
        if (face == 5) {
            ss.addStep(this.createDetailsFace(face, 1), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsColumn(face, 2, 3), type);
            ss.addStep(this.createDetailsFace(face, 0), type);
            return;
        }
        ss.addStep(this.createDetailsFace(face, 1), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsColumn(face, 0, 2), type);
        ss.addStep(this.createDetailsFace(face, 0), type);
    }

    private Integer[][][] step4(Integer[][][] cube, Solution sol) {
        SolutionStep ss = new SolutionStep("Nu ska vi placera kanterna r\u00e4tt, de beh\u00f6ver inte vara r\u00e4ttvridna, bara ha sina egentliga platser.", new int[][]{{4, 0, 0}, {4, 2, 0}, {4, 0, 2}, {4, 2, 2}}, false);
        ss.addRotation(1, 2);
        ss.addRotation(1, 3);
        ss.addRotation(1, 5);
        ss.addRotation(1, 1);
        sol.addSolutionStep(ss);
        int targetColor = cube[4][1][1];
        cube = this.step4_0(cube, targetColor, sol);
        if (RubiksCube.isSolved(cube)) {
            ss = new SolutionStep("Kuben \u00e4r l\u00f6st!", null, false);
            sol.addSolutionStep(ss);
            return null;
        }
        return cube;
    }

    private Integer[][][] step4_0(Integer[][][] cube, int targetColor, Solution sol) {
        SolutionStep ss;
        int[][] high;
        int[][][] cornersInPlace = this.cornersInPlace(targetColor, cube);
        if (cornersInPlace.length <= 1) {
            String snurr;
            high = new int[cornersInPlace.length][3];
            for (int i = 0; i < high.length; ++i) {
                high[i] = cornersInPlace[i][0];
            }
            ss = new SolutionStep(high, false);
            Map<String, Integer> details = this.createDetailsFace(4, 0);
            cornersInPlace = this.cornersInPlace(targetColor, cube = CubeMath.rotateCube(cube, details));
            if (cornersInPlace.length <= 1) {
                cornersInPlace = this.cornersInPlace(targetColor, cube = CubeMath.rotateCube(cube, details));
                if (cornersInPlace.length <= 1) {
                    cube = CubeMath.rotateCube(cube, details);
                    cornersInPlace = this.cornersInPlace(targetColor, cube);
                    details.put("direction", 1);
                    snurr = "\u00e5t h\u00f6ger.";
                    ss.addStep(details, 1);
                } else {
                    snurr = "180 grader.";
                    ss.addStep(details, 1);
                    ss.addStep(details, 1);
                }
            } else {
                snurr = "\u00e5t v\u00e4nster.";
                ss.addStep(details, 1);
            }
            ss.setDescription("Tv\u00e5 h\u00f6rn kan alltid bli r\u00e4tt placerade, oavsett vad. Snurra det understa lagret " + snurr);
            sol.addSolutionStep(ss);
        }
        if (cornersInPlace.length == 2) {
            int i;
            int face = -1;
            int[][] high2 = new int[cornersInPlace.length][3];
            for (i = 0; i < high2.length; ++i) {
                high2[i] = cornersInPlace[i][0];
            }
            if (cornersInPlace[0][2][1] == cornersInPlace[1][2][1]) {
                switch (cornersInPlace[0][2][1]) {
                    case 0: {
                        face = 5;
                        break;
                    }
                    case 2: {
                        face = 2;
                    }
                }
            } else if (cornersInPlace[0][2][2] == cornersInPlace[1][2][2]) {
                switch (cornersInPlace[0][2][2]) {
                    case 0: {
                        face = 1;
                        break;
                    }
                    case 2: {
                        face = 3;
                    }
                }
            }
            if (face == -1) {
                ss = new SolutionStep("Tv\u00e5 h\u00f6rn \u00e4r r\u00e4tt placerade men de ligger inte intill varandra. Snurra kuben p\u00e5 f\u00f6ljande nio s\u00e4tt med vilken sida som helst mot dig bara undersidan \u00e4r \u00f6verst. H\u00e4r har vi den " + this.clr(cube[2][1][1]) + " sidan mot oss.", high2, false);
                ss.addRotation(1, 2);
                this.turnAdjacentCorners(2, ss, 1);
            } else {
                ss = new SolutionStep("Tv\u00e5 h\u00f6rn \u00e4r r\u00e4tt placerade och de \u00e4r intill varandra. Snurra kuben p\u00e5 f\u00f6ljande nio s\u00e4tt med de r\u00e4tta h\u00f6rnen till v\u00e4nster och bort fr\u00e5n dig.", high2, false);
                ss.addRotation(1, face);
                this.turnAdjacentCorners(face, ss, 1);
            }
            for (i = 0; i < ss.getSteps(); ++i) {
                cube = CubeMath.rotateCube(cube, ss.getStep(i));
            }
            sol.addSolutionStep(ss);
            if (face == -1) {
                return this.step4_0(cube, targetColor, sol);
            }
            return cube;
        }
        high = new int[cornersInPlace.length][3];
        for (int i = 0; i < high.length; ++i) {
            high[i] = cornersInPlace[i][0];
        }
        ss = new SolutionStep("H\u00f6rnen \u00e4r r\u00e4ttplacerade, vi kan g\u00e5 vidare!", high, false);
        sol.addSolutionStep(ss);
        return cube;
    }

    private void turnAdjacentCorners(int face, SolutionStep ss, int type) {
        if (face == 5) {
            ss.addStep(this.createDetailsColumn(face, 0, 3), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsColumn(face, 2, 3), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsColumn(face, 0, 2), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            return;
        }
        ss.addStep(this.createDetailsColumn(face, 2, 2), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsColumn(face, 0, 2), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsColumn(face, 2, 3), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
    }

    private int[][][] cornersInPlace(int targetColor, Integer[][][] cube) {
        ArrayList<int[][]> corners = new ArrayList<int[][]>();
        for (int[] i : new int[][]{{1, 2}, {2, 3}, {3, 5}, {5, 1}}) {
            int c2;
            int c1 = cube[i[0]][1][1];
            int[][] corner = this.findBottomCorner(c1, c2 = cube[i[1]][1][1].intValue(), targetColor, cube);
            if (!this.bottomCornerInPlace(corner[0][0], corner[1][0], corner[2][0], i[0], i[1])) continue;
            corners.add(corner);
        }
        return (int[][][])corners.toArray((T[])new int[corners.size()][3][3]);
    }

    private boolean bottomCornerInPlace(int m1, int m2, int m3, int c1, int c2) {
        return m1 == c1 && (m2 == c2 && m3 == 4 || m3 == c2 && m2 == 4) || m2 == c1 && (m1 == c2 && m3 == 4 || m3 == c2 && m1 == 4) || m3 == c1 && (m2 == c2 && m1 == 4 || m1 == c2 && m2 == 4);
    }

    private Integer[][][] step5(Integer[][][] cube, Solution sol) {
        SolutionStep ss = new SolutionStep("N\u00e4r alla h\u00f6rn \u00e4r r\u00e4tt placerade ska vi vrida dem r\u00e4tt.", new int[][]{{4, 0, 0}, {4, 2, 0}, {4, 2, 2}, {4, 0, 2}}, false);
        ss.addRotation(1, 2);
        ss.addRotation(1, 3);
        ss.addRotation(1, 5);
        ss.addRotation(1, 1);
        sol.addSolutionStep(ss);
        cube = this.step5_0(cube, cube[4][1][1], sol);
        if (RubiksCube.isSolved(cube)) {
            ss = new SolutionStep("Kuben \u00e4r l\u00f6st!", null, false);
            sol.addSolutionStep(ss);
            return null;
        }
        return cube;
    }

    private Integer[][][] step5_0(Integer[][][] cube, int targetColor, Solution sol) {
        SolutionStep ss = null;
        int[][][][] corners = this.getCorrectBottomCorners(targetColor, cube);
        if (corners[0].length == 0) {
            int i;
            int face = -1;
            for (i = 0; i < 4; ++i) {
                if (cube[corners[1][i][0][0]][corners[1][i][0][1]][corners[1][i][0][2]] != targetColor) continue;
                ss = new SolutionStep("Inga h\u00f6rn \u00e4r r\u00e4tt vridna, leta upp ett h\u00f6rn med en " + this.clr(targetColor) + " v\u00e4nstersida och g\u00f6r f\u00f6ljande tio steg med det h\u00f6rnet mot dig.", new int[][]{corners[1][i][0], {4, 1, 1}}, false);
                face = corners[1][i][1][0];
                break;
            }
            ss.addRotation(1, face);
            this.move4(face, ss, 1);
            for (i = 0; i < ss.getSteps(); ++i) {
                cube = CubeMath.rotateCube(cube, ss.getStep(i));
            }
            sol.addSolutionStep(ss);
            return this.step5_0(cube, targetColor, sol);
        }
        if (corners[0].length == 1) {
            do {
                ss = new SolutionStep("Ett h\u00f6rn \u00e4r r\u00e4tt vriden, g\u00f6r f\u00f6ljande tio steg med det h\u00f6rnet mot dig.", corners[0][0], false);
                ss.addRotation(1, corners[0][0][1][0]);
                this.move4(corners[0][0][1][0], ss, 1);
                for (int i = 0; i < ss.getSteps(); ++i) {
                    cube = CubeMath.rotateCube(cube, ss.getStep(i));
                }
                sol.addSolutionStep(ss);
            } while ((corners = this.getCorrectBottomCorners(targetColor, cube))[0].length == 1);
            ss = new SolutionStep("Nu \u00e4r alla h\u00f6rn r\u00e4tt vridna, vi kan g\u00e5 vidare!", null, false);
            sol.addSolutionStep(ss);
            return cube;
        }
        if (corners[0].length == 2) {
            int i;
            int face = -1;
            for (i = 0; i < 4; ++i) {
                if (cube[corners[1][i][1][0]][corners[1][i][1][1]][corners[1][i][1][2]] != targetColor) continue;
                ss = new SolutionStep("Tv\u00e5 h\u00f6rn \u00e4r r\u00e4tt vridna, leta upp ett h\u00f6rn med en " + this.clr(targetColor) + " framsida och g\u00f6r f\u00f6ljande tio steg med det h\u00f6rnet mot dig.", new int[][]{corners[1][i][1], {4, 1, 1}}, false);
                face = corners[1][i][1][0];
                break;
            }
            ss.addRotation(1, face);
            this.move4(face, ss, 1);
            for (i = 0; i < ss.getSteps(); ++i) {
                cube = CubeMath.rotateCube(cube, ss.getStep(i));
            }
            sol.addSolutionStep(ss);
            return this.step5_0(cube, targetColor, sol);
        }
        ss = new SolutionStep("Alla h\u00f6rn \u00e4r redan r\u00e4tt, vi kan g\u00e5 vidare!", null, false);
        sol.addSolutionStep(ss);
        return cube;
    }

    private void move4(int face, SolutionStep ss, int type) {
        if (face == 5) {
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsColumn(face, 2, 3), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsColumn(face, 2, 3), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            return;
        }
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsColumn(face, 0, 2), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsColumn(face, 0, 2), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
    }

    private int[][][][] getCorrectBottomCorners(int targetColor, Integer[][][] cube) {
        ArrayList<int[][]> correct = new ArrayList<int[][]>();
        ArrayList<int[][]> incorrect = new ArrayList<int[][]>();
        for (int[] i : new int[][]{{1, 2}, {2, 3}, {3, 5}, {5, 1}}) {
            int c2;
            int c1 = cube[i[0]][1][1];
            int[][] corner = this.findBottomCorner(targetColor, c1, c2 = cube[i[1]][1][1].intValue(), cube);
            if (cube[corner[0][0]][corner[0][1]][corner[0][2]] == cube[corner[0][0]][1][1] && cube[corner[1][0]][corner[1][1]][corner[1][2]] == cube[corner[1][0]][1][1] && cube[corner[2][0]][corner[2][1]][corner[2][2]] == cube[corner[2][0]][1][1]) {
                correct.add(corner);
                continue;
            }
            incorrect.add(corner);
        }
        return new int[][][][]{(int[][][])correct.toArray((T[])new int[correct.size()][3][3]), (int[][][])incorrect.toArray((T[])new int[incorrect.size()][3][3])};
    }

    private Integer[][][] step6(Integer[][][] cube, Solution sol) {
        SolutionStep ss = new SolutionStep("Nu ska vi bara fixa de sista kanterna ocks\u00e5!", new int[][]{{4, 0, 1}, {4, 1, 2}, {4, 2, 1}, {4, 1, 0}}, false);
        ss.addRotation(1, 2);
        ss.addRotation(1, 3);
        ss.addRotation(1, 5);
        ss.addRotation(1, 1);
        sol.addSolutionStep(ss);
        return this.step6_0(cube, cube[4][1][1], sol);
    }

    private Integer[][][] step6_0(Integer[][][] cube, int targetColor, Solution sol) {
        int[][][][] edges = this.findBottomEdges(targetColor, cube);
        if (edges[0].length == 0) {
            SolutionStep ss = new SolutionStep("Inga kanter \u00e4r r\u00e4tt, g\u00f6r f\u00f6ljande tolv steg med vilken sida som helst mot dig, bara undersidan fortfarande \u00e4r \u00f6verst. H\u00e4r har vi den " + this.clr(cube[2][1][1]) + " sidan mot oss.", null, false);
            this.move5(2, ss, 1);
            for (int i = 0; i < ss.getSteps(); ++i) {
                cube = CubeMath.rotateCube(cube, ss.getStep(i));
            }
            sol.addSolutionStep(ss);
            return this.step6_0(cube, targetColor, sol);
        }
        if (edges[0].length == 1) {
            int f1 = -1;
            switch (edges[0][0][0][0]) {
                case 1: {
                    f1 = 5;
                    break;
                }
                case 2: {
                    f1 = 1;
                    break;
                }
                case 3: {
                    f1 = 2;
                    break;
                }
                case 5: {
                    f1 = 3;
                }
            }
            int f2 = -1;
            switch (f1) {
                case 1: {
                    f2 = 3;
                    break;
                }
                case 2: {
                    f2 = 5;
                    break;
                }
                case 3: {
                    f2 = 1;
                    break;
                }
                case 5: {
                    f2 = 2;
                }
            }
            for (int i = 0; i < 3; ++i) {
                if (edges[1][i][0][0] != f1) continue;
                for (int a = 0; a < 3; ++a) {
                    SolutionStep ss;
                    if (edges[1][a][0][0] != f2) continue;
                    if (cube[edges[1][i][0][0]][edges[1][i][0][1]][edges[1][i][0][2]] == cube[edges[1][a][0][0]][1][1]) {
                        ss = new SolutionStep("En kant \u00e4r r\u00e4tt, men som du ser borde det fr\u00e4mre h\u00f6rnet vara l\u00e4ngst bak.", new int[][]{edges[1][i][0], {f2, 1, 1}}, false);
                        ss.addRotation(1, f1);
                        ss.addRotation(1, f2);
                        sol.addSolutionStep(ss);
                        ss = new SolutionStep("G\u00f6r f\u00f6ljande tolv steg med den l\u00f6sta kanten till v\u00e4nster f\u00f6r att l\u00f6sa kuben!", edges[1][i], false);
                        this.move5(f1, ss, 3);
                    } else {
                        switch (f1) {
                            case 1: {
                                f2 = 5;
                                break;
                            }
                            case 2: {
                                f2 = 1;
                                break;
                            }
                            case 3: {
                                f2 = 2;
                                break;
                            }
                            case 5: {
                                f2 = 3;
                            }
                        }
                        ss = new SolutionStep("En kant \u00e4r r\u00e4tt, men som du ser borde det fr\u00e4mre h\u00f6rnet vara till h\u00f6ger.", new int[][]{edges[1][i][0], {f2, 1, 1}}, false);
                        ss.addRotation(1, f1);
                        ss.addRotation(1, f2);
                        sol.addSolutionStep(ss);
                        ss = new SolutionStep("G\u00f6r f\u00f6ljande tolv steg med den l\u00f6sta kanten till v\u00e4nster f\u00f6r att l\u00f6sa kuben!", edges[1][i], false);
                        this.move5b(f1, ss, 3);
                    }
                    ss.addRotation(3, f1);
                    for (int x = 0; x < ss.getSteps(); ++x) {
                        cube = CubeMath.rotateCube(cube, ss.getStep(x));
                    }
                    sol.addSolutionStep(ss);
                    return cube;
                }
            }
        }
        SolutionStep ss = new SolutionStep("Alla kanterna \u00e4r r\u00e4tt, kuben \u00e4r l\u00f6st!", null, false);
        sol.addSolutionStep(ss);
        return cube;
    }

    private int[][][][] findBottomEdges(int targetColor, Integer[][][] cube) {
        ArrayList<int[][]> correct = new ArrayList<int[][]>();
        ArrayList<int[][]> incorrect = new ArrayList<int[][]>();
        for (int i : new int[]{1, 2, 3, 5}) {
            int c2 = cube[i][1][1];
            int[][] edge = this.findBottomEdge(targetColor, c2, cube);
            if (this.bottomEdgeInPlace(edge, targetColor, 4, c2, i, cube)) {
                correct.add(edge);
                continue;
            }
            incorrect.add(edge);
        }
        return new int[][][][]{(int[][][])correct.toArray((T[])new int[correct.size()][2][3]), (int[][][])incorrect.toArray((T[])new int[incorrect.size()][2][3])};
    }

    private void move5(int face, SolutionStep ss, int type) {
        if (face == 5) {
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsFace(face, 1), type);
            ss.addStep(this.createDetailsFace(2, 0), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsFace(face, 0), type);
            ss.addStep(this.createDetailsFace(2, 1), type);
            ss.addStep(this.createDetailsRow(face, 0, 0), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            return;
        }
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsFace(face, 1), type);
        ss.addStep(this.createDetailsFace(face == 1 ? 3 : (face == 2 ? 5 : 1), 0), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsFace(face, 0), type);
        ss.addStep(this.createDetailsFace(face == 1 ? 3 : (face == 2 ? 5 : 1), 1), type);
        ss.addStep(this.createDetailsRow(face, 2, 1), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
    }

    private void move5b(int face, SolutionStep ss, int type) {
        if (face == 5) {
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsFace(face, 1), type);
            ss.addStep(this.createDetailsFace(2, 0), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsFace(face, 0), type);
            ss.addStep(this.createDetailsFace(2, 1), type);
            ss.addStep(this.createDetailsRow(face, 0, 1), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            ss.addStep(this.createDetailsColumn(face, 2, 2), type);
            return;
        }
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsFace(face, 1), type);
        ss.addStep(this.createDetailsFace(face == 1 ? 3 : (face == 2 ? 5 : 1), 0), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsFace(face, 0), type);
        ss.addStep(this.createDetailsFace(face == 1 ? 3 : (face == 2 ? 5 : 1), 1), type);
        ss.addStep(this.createDetailsRow(face, 2, 0), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
        ss.addStep(this.createDetailsColumn(face, 0, 3), type);
    }
}

