/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rubikscube.game.RubiksCube;
import rubikscube.game.RubiksCubeListener;
import rubikscube.gui.graphics2d.CubeViewerPseudo3D;
import rubikscube.gui.graphics3d.CubeViewer3D;
import rubikscube.gui.graphics3d.RubiksCube3D;

public class ControlPanel
extends JPanel
implements ActionListener,
MouseListener {
    private RubiksCube cube;
    private CubeViewer3D cube3D;
    private int currentFace;
    private Box topBox;
    private Box topLeftBox;
    private Box topLeftUpperBox;
    private Box topRightBox;
    private JLabel faceL;
    private JComboBox faceCB;
    private JButton shuffleB;
    private JButton faceLeftB;
    private JButton faceRightB;
    private Box[] bottomBox;
    private JButton[] rowLeftB;
    private JButton[] rowRightB;
    private JButton[] columnUpB;
    private JButton[] columnDownB;
    private UUID lastHigh;

    public ControlPanel(RubiksCube cb, CubeViewer3D cb3D) {
        if (cb == null) {
            throw new NullPointerException("cube == null");
        }
        if (cb3D == null) {
            throw new NullPointerException("cube3D == null");
        }
        this.cube = cb;
        this.cube3D = cb3D;
        this.currentFace = 0;
        this.createGUI();
        this.cube.addCubeListener(new RubiksCubeListener(){

            @Override
            public void cubeChanged(Map<String, Integer> details) {
                ControlPanel.this.fixButtons();
            }

            @Override
            public void cubeEdited() {
                System.out.println("CONTROLPANEL RESET");
            }

            @Override
            public void godModeSet(boolean godMode) {
                System.out.println("CONTROLPANEL GODMODE");
            }
        });
    }

    private void fixButtons() {
        BufferedImage img = CubeViewerPseudo3D.createFaceInFront(100, 100, this.currentFace, this.cube.getFaces());
        this.faceLeftB.setIcon(new ImageIcon(CubeViewerPseudo3D.addFrontFace(img, 0, this.cube.getSize())));
        this.faceRightB.setIcon(new ImageIcon(CubeViewerPseudo3D.addFrontFace(img, 1, this.cube.getSize())));
        for (int i = 0; i < this.cube.getSize(); ++i) {
            this.rowLeftB[i].setIcon(new ImageIcon(CubeViewerPseudo3D.addFrontRow(img, this.currentFace, i, 0, this.cube.getSize())));
            this.rowRightB[i].setIcon(new ImageIcon(CubeViewerPseudo3D.addFrontRow(img, this.currentFace, i, 1, this.cube.getSize())));
            this.columnUpB[i].setIcon(new ImageIcon(CubeViewerPseudo3D.addFrontColumn(img, this.currentFace, i, 2, this.cube.getSize())));
            this.columnDownB[i].setIcon(new ImageIcon(CubeViewerPseudo3D.addFrontColumn(img, this.currentFace, i, 3, this.cube.getSize())));
        }
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.topBox = Box.createHorizontalBox();
        this.topLeftBox = Box.createVerticalBox();
        this.topLeftUpperBox = Box.createHorizontalBox();
        this.topLeftUpperBox.setAlignmentX(1.0f);
        this.topRightBox = Box.createHorizontalBox();
        this.faceL = new JLabel("Face:");
        this.topLeftUpperBox.add(this.faceL);
        this.topLeftUpperBox.add(Box.createRigidArea(new Dimension(8, 0)));
        this.faceCB = new JComboBox<Integer>(new Integer[]{0, 1, 2, 3, 4, 5});
        this.faceCB.setMaximumSize(this.faceCB.getPreferredSize());
        this.faceCB.setActionCommand("set face");
        this.faceCB.addActionListener(this);
        this.faceCB.addMouseListener(this);
        this.topLeftUpperBox.add(this.faceCB);
        this.topLeftBox.add(this.topLeftUpperBox);
        this.topLeftBox.add(Box.createRigidArea(new Dimension(0, 5)));
        this.shuffleB = new JButton("Shuffle");
        this.shuffleB.setAlignmentX(1.0f);
        this.shuffleB.setMaximumSize(this.shuffleB.getPreferredSize());
        this.shuffleB.setActionCommand("shuffle");
        this.shuffleB.addActionListener(this);
        this.shuffleB.addMouseListener(this);
        this.topLeftBox.add(this.shuffleB);
        this.topBox.add(this.topLeftBox);
        this.topBox.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(10, 0)));
        this.faceLeftB = new JButton();
        this.faceLeftB.setActionCommand("face left");
        this.faceLeftB.addActionListener(this);
        this.faceLeftB.addMouseListener(this);
        this.topRightBox.add(this.faceLeftB);
        this.topRightBox.add(Box.createRigidArea(new Dimension(5, 0)));
        this.faceRightB = new JButton();
        this.faceRightB.setActionCommand("face right");
        this.faceRightB.addActionListener(this);
        this.faceRightB.addMouseListener(this);
        this.topRightBox.add(this.faceRightB);
        this.topBox.add(this.topRightBox);
        this.add(this.topBox);
        this.bottomBox = new Box[this.cube.getSize()];
        this.rowLeftB = new JButton[this.cube.getSize()];
        this.rowRightB = new JButton[this.cube.getSize()];
        this.columnUpB = new JButton[this.cube.getSize()];
        this.columnDownB = new JButton[this.cube.getSize()];
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        for (int i = 0; i < this.cube.getSize(); ++i) {
            this.bottomBox[i] = Box.createHorizontalBox();
            this.rowLeftB[i] = new JButton();
            this.rowLeftB[i].setActionCommand("row " + i + " left");
            this.rowLeftB[i].addActionListener(this);
            this.rowLeftB[i].addMouseListener(this);
            this.bottomBox[i].add(this.rowLeftB[i]);
            this.bottomBox[i].add(Box.createRigidArea(new Dimension(5, 0)));
            this.rowRightB[i] = new JButton();
            this.rowRightB[i].setActionCommand("row " + i + " right");
            this.rowRightB[i].addActionListener(this);
            this.rowRightB[i].addMouseListener(this);
            this.bottomBox[i].add(this.rowRightB[i]);
            this.bottomBox[i].add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(10, 0)));
            this.columnUpB[i] = new JButton();
            this.columnUpB[i].setActionCommand("column " + i + " up");
            this.columnUpB[i].addActionListener(this);
            this.columnUpB[i].addMouseListener(this);
            this.bottomBox[i].add(this.columnUpB[i]);
            this.bottomBox[i].add(Box.createRigidArea(new Dimension(5, 0)));
            this.columnDownB[i] = new JButton();
            this.columnDownB[i].setActionCommand("column " + i + " down");
            this.columnDownB[i].addActionListener(this);
            this.columnDownB[i].addMouseListener(this);
            this.bottomBox[i].add(this.columnDownB[i]);
            this.add(this.bottomBox[i]);
            if (i == this.cube.getSize() - 1) continue;
            this.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        this.setCurrentFace0(0);
    }

    public void setCube(RubiksCube newCube) {
        if (newCube == null) {
            throw new NullPointerException("cube == null");
        }
        this.cube = newCube;
        this.createGUI();
    }

    public RubiksCube getCube() {
        return this.cube;
    }

    public void setCurrentFace(int face) {
        this.setCurrentFace0(face);
        this.faceCB.setSelectedIndex(face);
    }

    private void setCurrentFace0(int face) {
        if (face < 0 || face > 6) {
            throw new IllegalArgumentException("face is invalid");
        }
        this.currentFace = face;
        this.cube3D.makeFaceInFront(face);
        this.fixButtons();
    }

    public int getCurrentFace() {
        return this.faceCB.getSelectedIndex();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String aCMD = e.getActionCommand();
        if (aCMD.equals("set face")) {
            this.setCurrentFace0(this.faceCB.getSelectedIndex());
        } else if (aCMD.startsWith("face")) {
            this.cube.rotateFace(this.currentFace, aCMD.endsWith("left") ? 0 : 1);
        } else if (aCMD.startsWith("row")) {
            this.cube.rotateRow(this.currentFace, Integer.parseInt(aCMD.split(" ")[1]), aCMD.endsWith("left") ? 0 : 1);
        } else if (aCMD.startsWith("column")) {
            this.cube.rotateColumn(this.currentFace, Integer.parseInt(aCMD.split(" ")[1]), aCMD.endsWith("up") ? 2 : 3);
        } else if (aCMD.equals("shuffle")) {
            this.cube.shuffle(10 + new Random().nextInt(6));
        } else {
            System.out.println("Unknown command: " + aCMD);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Object source = e.getSource();
        if (!(source instanceof JButton)) {
            return;
        }
        String aCMD = ((JButton)source).getActionCommand();
        RubiksCube3D rc3D = this.cube3D.getCube3D();
        if (aCMD.startsWith("face")) {
            this.lastHigh = rc3D.highlightFace(this.currentFace, Color.YELLOW, 0, true);
        } else if (aCMD.startsWith("row")) {
            this.lastHigh = rc3D.highlightRow(this.currentFace, Integer.parseInt(aCMD.split(" ")[1]), Color.YELLOW, 0, true);
        } else if (aCMD.startsWith("column")) {
            this.lastHigh = rc3D.highlightColumn(this.currentFace, Integer.parseInt(aCMD.split(" ")[1]), Color.YELLOW, 0, true);
        } else if (aCMD.equals("shuffle")) {
            this.lastHigh = rc3D.highlightCube(Color.YELLOW, 0);
        } else {
            System.out.println("Unknown command: " + aCMD);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Object source = e.getSource();
        if (!(source instanceof JButton)) {
            return;
        }
        String aCMD = ((JButton)source).getActionCommand();
        if (aCMD.startsWith("face") || aCMD.startsWith("row") || aCMD.startsWith("column") || aCMD.equals("shuffle")) {
            this.cube3D.getCube3D().removeHighlight(this.lastHigh);
        }
    }
}

