/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class Log {
    private static JDialog logDialog;
    private static final JPanel rootPanel;
    private static final JScrollPane logScroll;
    private static final JTextArea log;
    private static final List<Integer> logPos;
    private static final List<Long> logStamp;

    public static void initialize(Frame owner, String title) {
        if (logDialog != null) {
            return;
        }
        logDialog = new JDialog(owner, title, false);
        logDialog.add(rootPanel);
        logDialog.pack();
    }

    public static JDialog getDialog() {
        return logDialog;
    }

    public static void log(String source, String s) {
        Log.log(System.currentTimeMillis(), source, s);
    }

    public static void log(long stamp, String source, String s) {
        if (s.trim().isEmpty()) {
            return;
        }
        Document doc = log.getDocument();
        try {
            int i;
            int len = doc.getLength();
            String[] split = s.split("\n");
            if (split.length == 0) {
                s = "[" + Log.stampToString(stamp) + "](" + Log.ensure(source, 10) + "): " + s;
            } else {
                s = "[" + Log.stampToString(stamp) + "](" + Log.ensure(source, 10) + "): " + split[0];
                for (i = 1; i < split.length; ++i) {
                    s = s + "\n" + split[i];
                }
            }
            for (i = logPos.size() - 1; i >= -1; --i) {
                if (i != -1 && logStamp.get(i) > stamp) continue;
                if (i >= logPos.size() - 1) break;
                len = logPos.get(i + 1);
                if (!s.endsWith("\n")) {
                    s = s + "\n";
                }
                for (int a = i + 1; a < logPos.size(); ++a) {
                    logPos.set(a, logPos.get(a) + s.length());
                }
                break;
            }
            if (i == logPos.size() - 1 && len > 0) {
                doc.insertString(len++, "\n", null);
            }
            logPos.add(i + 1, len);
            logStamp.add(i + 1, stamp);
            doc.insertString(len, s, null);
            log.setCaretPosition(len += s.length());
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Log.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static String stampToString(long stamp) {
        long now = System.currentTimeMillis();
        long diff = now - stamp;
        Calendar c = Calendar.getInstance();
        int hh = c.get(11);
        int mm = c.get(12);
        int ss = c.get(13);
        int ms = c.get(14);
        ms = (int)((long)ms - diff);
        while (ms < 0) {
            ms += 1000;
            --ss;
        }
        while (ss < 0) {
            ss += 60;
            --mm;
        }
        while (mm < 0) {
            mm += 60;
            --hh;
        }
        while (hh < 0) {
            hh += 24;
        }
        return Log.ensure(hh, 2) + ":" + Log.ensure(mm, 2) + ":" + Log.ensure(ss, 2) + "." + Log.ensure(ms, 4);
    }

    private static String ensure(int n, int len) {
        String ret = "";
        int a = 10;
        int i = 1;
        while (a - 1 < n) {
            a *= 10;
            ++i;
        }
        while (i < len) {
            ret = ret + "0";
            ++i;
        }
        return ret + n;
    }

    private static String ensure(String s, int len) {
        for (int i = s.length(); i < len; ++i) {
            s = " " + s;
        }
        return s;
    }

    public static OutputStream createStream(final String name) {
        if (name.length() > 10) {
            throw new IllegalArgumentException("name too long");
        }
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                Log.log(name, String.valueOf((char)b));
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                Log.log(name, new String(b, off, len));
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }
        };
    }

    private Log() {
    }

    static {
        rootPanel = new JPanel(new GridBagLayout());
        rootPanel.setLayout(new BoxLayout(rootPanel, 1));
        log = new JTextArea();
        logScroll = new JScrollPane(log);
        rootPanel.add(logScroll);
        logScroll.setPreferredSize(new Dimension(600, 350));
        logScroll.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        log.setFont(new Font("Monospaced", 0, 12));
        log.setEditable(false);
        logPos = new ArrayList<Integer>();
        logStamp = new ArrayList<Long>();
    }
}

