/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import rubikscube.game.CubeMath;
import rubikscube.game.RubiksCube;
import rubikscube.game.RubiksCubeListener;
import rubikscube.game.solver.Solution;
import rubikscube.game.solver.SolutionStep;
import rubikscube.game.solver.Solver;
import rubikscube.game.solver.SolverManager;
import rubikscube.gui.Log;
import rubikscube.gui.PleaseWaitPane;
import rubikscube.gui.graphics2d.CubeViewerPseudo3D;
import rubikscube.gui.graphics3d.CubeViewer3D;

public class RCMain
implements Runnable,
ListSelectionListener,
ActionListener,
WindowListener,
RubiksCubeListener,
KeyListener {
    public static boolean UNLOCKED;
    public static final String HIDDEN_SEAL_PATH = "/res/fluttershy_approved_by_ambris-d4ivleb.png";
    public static final String UNLOCK = "Sonic Rainboom";
    public static final String[] MANE6_PATH;
    public static final BufferedImage HIDDEN_SEAL;
    public static final BufferedImage[] MANE6;
    public static final int PSEUDO_3D_DIM = 100;
    public static final int HISTORY_SIZE = 100;
    public static final int N_LINES = 6769;
    private RubiksCube cube;
    private final List<Map<String, Integer>> undoHistory = new ArrayList(){

        @Override
        public boolean contains(Object o) {
            for (int i = 0; i < this.size(); ++i) {
                if (o != this.get(i)) continue;
                return true;
            }
            return false;
        }
    };
    private final List<Map<String, Integer>> redoHistory = new ArrayList(){

        @Override
        public boolean contains(Object o) {
            for (int i = 0; i < this.size(); ++i) {
                if (o != this.get(i)) continue;
                return true;
            }
            return false;
        }
    };
    private Map<Map<String, Integer>, Map<String, Integer>> undoRedoLinks = new HashMap<Map<String, Integer>, Map<String, Integer>>();
    private Solver[] solvers;
    private Solution currentSolution;
    private int currentStep;
    private int currentStepStep;
    private JLabel[] currentStepSteps;
    private UUID stepHighlight;
    private UUID rotationBlock;
    private JFileChooser fileChooser;
    private FileFilter cubeFilter;
    private PleaseWaitPane pleaseWaitPane;
    private Thread autoSolver;
    private boolean autoSolve;
    private boolean unlocking = false;
    private Thread unlocker;
    private String hiddenTyped = "";
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem saveCubeItem;
    private JMenuItem loadCubeItem;
    private JMenuItem exitItem;
    private JMenu editMenu;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    private JMenuItem shuffleItem;
    private JCheckBoxMenuItem godModeItem;
    private JMenuItem resetItem;
    private JMenu viewMenu;
    private JCheckBoxMenuItem autoRotItem;
    private JCheckBoxMenuItem autoSolveItem;
    private JMenu helpMenu;
    private JMenuItem showLogItem;
    private JMenuItem aboutItem;
    private JFrame mainWindow;
    private JPanel rootPanel;
    private JPanel solversPanel;
    private JScrollPane solversScroll;
    private JList solversList;
    private DefaultListModel solversListModel;
    private JScrollPane descriptionScroll;
    private JLabel solvableLabel;
    private JButton solveButton;
    private JPanel stepsPanel;
    private JButton prevStepButton;
    private JLabel currentStepLabel;
    private TitledBorder currentStepBorder;
    private JButton nextStepButton;
    private JPanel stepStepsPanel;
    private JButton nextStepStepButton;
    private JScrollPane currentStepStepScroll;
    private JPanel currentStepStepBorderFix;
    private TitledBorder currentStepStepBorder;
    private JPanel currentStepStepPanel;
    private JButton prevStepStepButton;
    private CubeViewer3D cube3D;
    private JLabel statusLabel;
    private JDialog aboutDialog;
    private JPanel aboutRootPanel;
    private JScrollPane hiddenSealScroll;
    private JLabel hiddenSealLabel;
    private JButton aboutCloseButton;

    @Override
    public void run() {
        this.mainWindow = new JFrame("RRobot");
        this.mainWindow.setDefaultCloseOperation(0);
        this.mainWindow.addWindowListener(this);
        this.cube = new RubiksCube(3);
        this.cube.addCubeListener(this);
        this.menuBar = new JMenuBar();
        this.mainWindow.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu("Arkiv");
        this.menuBar.add(this.fileMenu);
        this.fileMenu.setMnemonic('A');
        this.saveCubeItem = new JMenuItem("Spara kub...");
        this.fileMenu.add(this.saveCubeItem);
        this.saveCubeItem.setMnemonic('S');
        this.saveCubeItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.saveCubeItem.addActionListener(this);
        this.loadCubeItem = new JMenuItem("Ladda kub...");
        this.fileMenu.add(this.loadCubeItem);
        this.loadCubeItem.setMnemonic('L');
        this.loadCubeItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.loadCubeItem.addActionListener(this);
        this.fileMenu.addSeparator();
        this.exitItem = new JMenuItem("Avsluta");
        this.fileMenu.add(this.exitItem);
        this.exitItem.setMnemonic('A');
        this.exitItem.addActionListener(this);
        this.editMenu = new JMenu("Redigera");
        this.menuBar.add(this.editMenu);
        this.editMenu.setMnemonic('e');
        this.undoItem = new JMenuItem("\u00c5ngra");
        this.editMenu.add(this.undoItem);
        this.undoItem.setEnabled(false);
        this.undoItem.setMnemonic('\u00c5');
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.undoItem.addActionListener(this);
        this.redoItem = new JMenuItem("G\u00f6r om");
        this.editMenu.add(this.redoItem);
        this.redoItem.setEnabled(false);
        this.redoItem.setMnemonic('G');
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        this.redoItem.addActionListener(this);
        this.editMenu.addSeparator();
        this.shuffleItem = new JMenuItem("Snurra slumpm\u00e4ssigt");
        this.editMenu.add(this.shuffleItem);
        this.shuffleItem.setMnemonic('L');
        this.shuffleItem.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        this.shuffleItem.addActionListener(this);
        this.godModeItem = new JCheckBoxMenuItem("Skapa-l\u00e4ge", false);
        this.editMenu.add(this.godModeItem);
        this.godModeItem.setMnemonic('S');
        this.godModeItem.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        this.godModeItem.addActionListener(this);
        this.resetItem = new JMenuItem("\u00c5terst\u00e4ll kub");
        this.editMenu.add(this.resetItem);
        this.resetItem.setMnemonic('\u00c5');
        this.resetItem.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.resetItem.addActionListener(this);
        this.viewMenu = new JMenu("Visa");
        this.menuBar.add(this.viewMenu);
        this.viewMenu.setMnemonic('V');
        this.autoRotItem = new JCheckBoxMenuItem("Rotera automatiskt", false);
        this.viewMenu.add(this.autoRotItem);
        this.autoRotItem.setMnemonic('R');
        this.autoRotItem.addActionListener(this);
        this.autoSolveItem = new JCheckBoxMenuItem("L\u00f6s automatiskt", false);
        this.viewMenu.add(this.autoSolveItem);
        this.autoSolveItem.setMnemonic('L');
        this.autoSolveItem.addActionListener(this);
        this.helpMenu = new JMenu("Hj\u00e4lp");
        this.menuBar.add(this.helpMenu);
        this.helpMenu.setMnemonic('H');
        this.showLogItem = new JMenuItem("\u00d6ppna log");
        this.helpMenu.add(this.showLogItem);
        this.showLogItem.setMnemonic('o');
        this.showLogItem.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        this.showLogItem.addActionListener(this);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem("Om The RRobot");
        this.helpMenu.add(this.aboutItem);
        this.aboutItem.setMnemonic('R');
        this.aboutItem.addActionListener(this);
        this.rootPanel = new JPanel();
        this.rootPanel.setLayout(new BoxLayout(this.rootPanel, 1));
        Box b0 = Box.createHorizontalBox();
        b0.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 3));
        this.solversPanel = new JPanel();
        this.solversPanel.setLayout(new BoxLayout(this.solversPanel, 1));
        Box b = Box.createHorizontalBox();
        this.solversListModel = new DefaultListModel();
        this.solversList = new JList(this.solversListModel);
        this.solversList.addListSelectionListener(this);
        this.solversScroll = new JScrollPane(this.solversList, 22, 30);
        this.solversScroll.setPreferredSize(new Dimension(200, 100));
        this.solversScroll.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.solversScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "L\u00f6sare"), BorderFactory.createEtchedBorder()));
        b.add(this.solversScroll);
        b.add(Box.createHorizontalStrut(3));
        Box b2 = Box.createVerticalBox();
        b2.add(Box.createVerticalGlue());
        this.descriptionScroll = new JScrollPane();
        this.descriptionScroll.setPreferredSize(new Dimension(300, 150));
        this.descriptionScroll.setMaximumSize(this.descriptionScroll.getPreferredSize());
        this.descriptionScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Beskrivning"), BorderFactory.createEtchedBorder()));
        b2.add(this.descriptionScroll);
        b2.add(Box.createVerticalGlue());
        Box b3 = Box.createHorizontalBox();
        this.solvableLabel = new JLabel();
        this.solvableLabel.setPreferredSize(new Dimension(125, 50));
        this.solvableLabel.setMaximumSize(this.solvableLabel.getPreferredSize());
        this.solvableLabel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Kan kuben l\u00f6sas?"));
        this.solvableLabel.setHorizontalAlignment(0);
        b3.add(this.solvableLabel);
        b2.add(b3);
        b2.add(Box.createVerticalGlue());
        b3 = Box.createHorizontalBox();
        this.solveButton = new JButton("L\u00f6s kuben \u00e5t mig");
        this.solveButton.addActionListener(this);
        this.solveButton.setFont(new Font(this.solveButton.getFont().getName(), this.solveButton.getFont().getStyle(), (int)((double)this.solveButton.getFont().getSize() * 1.25)));
        this.solveButton.setPreferredSize(new Dimension(this.solveButton.getPreferredSize().width, (int)((double)this.solveButton.getPreferredSize().height * 1.5)));
        this.solveButton.setMaximumSize(this.solveButton.getPreferredSize());
        b3.add(this.solveButton);
        b2.add(b3);
        b2.add(Box.createVerticalGlue());
        b.add(b2);
        this.solversPanel.add(b);
        this.solversPanel.add(Box.createVerticalStrut(3));
        this.stepsPanel = new JPanel();
        this.stepsPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.stepsPanel.setLayout(new BoxLayout(this.stepsPanel, 0));
        this.stepsPanel.setPreferredSize(new Dimension(b.getPreferredSize().width, 75));
        this.stepsPanel.setMinimumSize(this.stepsPanel.getPreferredSize());
        this.stepsPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.stepsPanel.getPreferredSize().height));
        this.prevStepButton = new JButton("<");
        this.prevStepButton.setFont(new Font("Arial", 1, 20));
        this.prevStepButton.addActionListener(this);
        this.prevStepButton.setEnabled(false);
        this.prevStepButton.setPreferredSize(new Dimension(50, 70));
        this.prevStepButton.setMinimumSize(this.prevStepButton.getPreferredSize());
        this.prevStepButton.setMaximumSize(this.prevStepButton.getPreferredSize());
        this.stepsPanel.add(this.prevStepButton);
        this.currentStepLabel = new JLabel();
        this.currentStepLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.currentStepLabel.setHorizontalAlignment(0);
        this.currentStepBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Steg N/A");
        this.currentStepLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), this.currentStepBorder));
        this.stepsPanel.add(this.currentStepLabel);
        this.nextStepButton = new JButton(">");
        this.nextStepButton.setFont(this.prevStepButton.getFont());
        this.nextStepButton.addActionListener(this);
        this.nextStepButton.setEnabled(false);
        this.nextStepButton.setPreferredSize(this.prevStepButton.getPreferredSize());
        this.nextStepButton.setMinimumSize(this.prevStepButton.getPreferredSize());
        this.nextStepButton.setMaximumSize(this.prevStepButton.getPreferredSize());
        this.stepsPanel.add(this.nextStepButton);
        this.solversPanel.add(this.stepsPanel);
        this.solversPanel.add(Box.createVerticalStrut(3));
        this.stepStepsPanel = new JPanel();
        this.stepStepsPanel.setLayout(new BoxLayout(this.stepStepsPanel, 0));
        this.stepStepsPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.prevStepStepButton = new JButton("<");
        this.prevStepStepButton.setFont(new Font("Arial", 1, 12));
        this.prevStepStepButton.addActionListener(this);
        this.prevStepStepButton.setEnabled(false);
        this.prevStepStepButton.setPreferredSize(new Dimension(45, 110));
        this.prevStepStepButton.setMinimumSize(this.prevStepStepButton.getPreferredSize());
        this.prevStepStepButton.setMaximumSize(this.prevStepStepButton.getPreferredSize());
        this.stepStepsPanel.add(this.prevStepStepButton);
        this.currentStepStepPanel = new JPanel();
        this.currentStepStepPanel.setBackground(Color.WHITE);
        this.currentStepStepPanel.setLayout(new BoxLayout(this.currentStepStepPanel, 0));
        this.currentStepStepPanel.setPreferredSize(new Dimension(0, 100));
        this.currentStepStepScroll = new JScrollPane(this.currentStepStepPanel, 20, 31);
        this.currentStepStepScroll.setMinimumSize(this.currentStepStepScroll.getPreferredSize());
        this.currentStepStepScroll.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.currentStepStepScroll.getPreferredSize().height));
        this.currentStepStepBorderFix = new JPanel();
        this.currentStepStepBorderFix.setLayout(new BoxLayout(this.currentStepStepBorderFix, 0));
        this.currentStepStepBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Snurr N/A");
        this.currentStepStepBorderFix.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), this.currentStepStepBorder));
        this.currentStepStepBorderFix.add(this.currentStepStepScroll);
        this.stepStepsPanel.add(this.currentStepStepBorderFix);
        this.nextStepStepButton = new JButton(">");
        this.nextStepStepButton.setFont(this.prevStepStepButton.getFont());
        this.nextStepStepButton.addActionListener(this);
        this.nextStepStepButton.setEnabled(false);
        this.nextStepStepButton.setPreferredSize(this.prevStepStepButton.getPreferredSize());
        this.nextStepStepButton.setMinimumSize(this.prevStepStepButton.getPreferredSize());
        this.nextStepStepButton.setMaximumSize(this.prevStepStepButton.getPreferredSize());
        this.stepStepsPanel.add(this.nextStepStepButton);
        this.solversPanel.add(this.stepStepsPanel);
        b0.add(this.solversPanel);
        this.cube3D = new CubeViewer3D(this.cube);
        this.cube3D.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "3D-kub"), BorderFactory.createBevelBorder(1)));
        this.cube3D.setPreferredSize(new Dimension(500, 500));
        b0.add(this.cube3D);
        this.rootPanel.add(b0);
        this.rootPanel.add(new JSeparator());
        this.statusLabel = new JLabel(this.cube.getRotationQueueSize() + " snurrningar i k\u00f6");
        this.statusLabel.setHorizontalAlignment(4);
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        this.statusLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.statusLabel.getPreferredSize().height));
        this.rootPanel.add(this.statusLabel);
        this.mainWindow.add(this.rootPanel);
        this.aboutDialog = new JDialog(this.mainWindow, "Om The RRobot", true);
        this.aboutDialog.setDefaultCloseOperation(0);
        this.aboutDialog.setResizable(false);
        this.aboutDialog.addWindowListener(this);
        this.aboutDialog.addKeyListener(this);
        this.aboutRootPanel = new JPanel();
        this.aboutRootPanel.setLayout(new BoxLayout(this.aboutRootPanel, 1));
        this.aboutRootPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        this.hiddenSealLabel = new JLabel(new ImageIcon(HIDDEN_SEAL));
        this.hiddenSealLabel.setPreferredSize(new Dimension(HIDDEN_SEAL.getWidth() + 20, HIDDEN_SEAL.getHeight() + 20));
        this.hiddenSealScroll = new JScrollPane(this.hiddenSealLabel, 21, 31);
        this.hiddenSealScroll.setPreferredSize(new Dimension(this.hiddenSealScroll.getPreferredSize().width, 0));
        this.hiddenSealScroll.setMinimumSize(this.hiddenSealScroll.getPreferredSize());
        this.hiddenSealScroll.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        b.add(this.hiddenSealScroll);
        b.add(Box.createHorizontalGlue());
        this.aboutRootPanel.add(b);
        this.aboutRootPanel.add(Box.createVerticalStrut(10));
        for (String s : new String[]{"Skriven av Rafael Mohlin", "under v\u00e5ren 2012 som projektarbete.", " ", "Antal rader kod: 6769"}) {
            b = Box.createHorizontalBox();
            b.add(Box.createHorizontalGlue());
            JLabel label = new JLabel(s);
            label.setHorizontalAlignment(0);
            label.setFont(new Font(label.getFont().getName(), 1, 14));
            b.add(label);
            b.add(Box.createHorizontalGlue());
            this.aboutRootPanel.add(b);
        }
        this.aboutRootPanel.add(Box.createVerticalStrut(10));
        b = Box.createHorizontalBox();
        b.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        b.add(Box.createHorizontalGlue());
        this.aboutCloseButton = new JButton("St\u00e4ng");
        this.aboutCloseButton.setFocusable(false);
        this.aboutCloseButton.addActionListener(this);
        b.add(this.aboutCloseButton);
        b.add(Box.createHorizontalGlue());
        this.aboutRootPanel.add(b);
        this.aboutRootPanel.add(Box.createVerticalStrut(10));
        this.aboutDialog.add(this.aboutRootPanel);
        this.fileChooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (this.getDialogType() == 1) {
                    if (f.exists()) {
                        int res = JOptionPane.showConfirmDialog(this, f.getName() + " existerar redan.\n Vill du ers\u00e4tta den?", "Bekr\u00e4fta spara", 1);
                        switch (res) {
                            case 0: {
                                super.approveSelection();
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                this.cancelSelection();
                            }
                        }
                    }
                    return;
                }
                if (!(this.getDialogType() != 0 || f.exists() && this.getFileFilter().accept(f))) {
                    return;
                }
                super.approveSelection();
            }
        };
        this.cubeFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".rc");
            }

            @Override
            public String getDescription() {
                return "Rubiks kub-filer (*.rc)";
            }
        };
        this.fileChooser.setFileFilter(this.cubeFilter);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.pleaseWaitPane = new PleaseWaitPane(this.mainWindow, "V\u00e4nligen v\u00e4nta...", "RRobot");
        this.autoSolver = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (RCMain.this.autoSolve) {
                                Solver solver = RCMain.this.solvers[RCMain.this.solversList.getSelectedIndex()];
                                Solution sol = null;
                                RCMain.this.cube.waitForRotation();
                                Solver solver2 = solver;
                                synchronized (solver2) {
                                    solver.init(RCMain.this.cube);
                                    if (solver.canSolve()) {
                                        sol = solver.solveCube();
                                    }
                                }
                                if (sol != null) {
                                    int i;
                                    for (i = 0; RCMain.this.autoSolve && i < sol.getSteps(); ++i) {
                                        SolutionStep ss = sol.getStep(i);
                                        for (int a = 0; RCMain.this.autoSolve && a < ss.getSteps(); ++a) {
                                            RCMain.this.cube.rotateCube(ss.getStep(a));
                                            RCMain.this.cube.waitForRotation();
                                        }
                                    }
                                    for (i = 0; RCMain.this.autoSolve && i < 500; ++i) {
                                        Thread.sleep(10L);
                                    }
                                }
                                for (int i = 0; RCMain.this.autoSolve && i < 20; ++i) {
                                    RCMain.this.cube.shuffle(1);
                                    RCMain.this.cube.waitForRotation();
                                }
                            }
                            Thread.sleep(10L);
                        }
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                        continue;
                    }
                    break;
                }
            }
        };
        this.autoSolver.start();
        this.unlocker = new Thread(){

            @Override
            public void run() {
                try {
                    int target = ((RCMain)RCMain.this).hiddenSealLabel.getPreferredSize().height;
                    JScrollBar vertBar = RCMain.this.hiddenSealScroll.getVerticalScrollBar();
                    if (target % 2 == 1) {
                        ++target;
                    }
                    while (target > 0) {
                        RCMain.this.aboutDialog.setLocation(RCMain.this.aboutDialog.getX(), RCMain.this.aboutDialog.getY() - 1);
                        RCMain.this.aboutDialog.setSize(RCMain.this.aboutDialog.getWidth(), RCMain.this.aboutDialog.getHeight() + 2);
                        vertBar.setValue(vertBar.getMaximum() / 2 - vertBar.getVisibleAmount() / 2);
                        target -= 2;
                        Thread.sleep(15L);
                    }
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                }
                RCMain.this.aboutCloseButton.setEnabled(true);
                RCMain.this.unlocking = false;
            }
        };
        this.solvers = SolverManager.getSolvers();
        for (Solver sol : this.solvers) {
            this.solversListModel.addElement(sol);
        }
        if (this.solvers.length > 0) {
            this.solversList.setSelectedIndex(0);
        }
        this.aboutDialog.pack();
        this.mainWindow.pack();
        this.mainWindow.setLocationRelativeTo(null);
        this.mainWindow.setVisible(true);
        this.mainWindow.setMinimumSize(this.mainWindow.getPreferredSize());
    }

    private void exit() {
        int res = JOptionPane.showConfirmDialog(this.mainWindow, "\u00c4r du s\u00e4ker p\u00e5 att du vill avsluta?", "RRobot", 0);
        if (res == 0) {
            System.exit(0);
        }
    }

    private void closeDialog() {
        if (!this.unlocking) {
            this.aboutDialog.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undo() {
        List<Map<String, Integer>> list = this.undoHistory;
        synchronized (list) {
            this.redoHistory.add(0, CubeMath.reverseDetails(this.undoHistory.get(0)));
            this.undoRedoLinks.put(this.redoHistory.get(0), this.undoHistory.remove(0));
            this.cube.rotateCube(this.redoHistory.get(0));
            if (this.cube.isRotating()) {
                this.statusLabel.setText(this.cube.getRotationQueueSize() - 1 + " snurrningar i k\u00f6");
            } else {
                this.statusLabel.setText("0 snurrningar i k\u00f6");
            }
            this.undoItem.setEnabled(!this.undoHistory.isEmpty());
            this.redoItem.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redo() {
        List<Map<String, Integer>> list = this.undoHistory;
        synchronized (list) {
            this.undoHistory.add(0, this.undoRedoLinks.remove(this.redoHistory.remove(0)));
            this.cube.rotateCube(this.undoHistory.get(0));
            if (this.cube.isRotating()) {
                this.statusLabel.setText(this.cube.getRotationQueueSize() - 1 + " snurrningar i k\u00f6");
            } else {
                this.statusLabel.setText("0 snurrningar i k\u00f6");
            }
            this.undoItem.setEnabled(true);
            this.redoItem.setEnabled(!this.redoHistory.isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void godModeSet() {
        if (this.currentSolution == null) {
            if (this.cube.isRotating() || this.cube3D.isRotating()) {
                PleaseWaitPane pleaseWaitPane = this.pleaseWaitPane;
                synchronized (pleaseWaitPane) {
                    this.pleaseWaitPane.setCanCancel(true);
                    this.pleaseWaitPane.init();
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                while (RCMain.this.pleaseWaitPane.pleaseWait() && (RCMain.this.cube.isRotating() || RCMain.this.cube3D.isRotating())) {
                                    if ("Avbryt".equals(RCMain.this.pleaseWaitPane.getValue())) {
                                        RCMain.this.pleaseWaitPane.setCanceled(true);
                                        RCMain.this.pleaseWaitPane.setValue(null);
                                        break;
                                    }
                                    Thread.sleep(10L);
                                }
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            RCMain.this.pleaseWaitPane.setVisible(false);
                        }
                    }.start();
                    this.pleaseWaitPane.setLocationRelativeTo(this.mainWindow);
                    this.pleaseWaitPane.setVisible(true);
                    if (this.pleaseWaitPane.canceled()) {
                        return;
                    }
                }
            }
            if (!this.cube.setGodMode(this.godModeItem.isSelected())) {
                int res = JOptionPane.showConfirmDialog(this.mainWindow, "Kan inte g\u00e5 ur skapa-l\u00e4get, kuben \u00e4r inte korrekt. Vill du \u00e5terst\u00e4lla kuben?", "RRobot", 0, 0);
                if (res == 0) {
                    this.cube.reset();
                    this.godModeSet();
                    return;
                }
                this.godModeItem.setSelected(true);
            }
            if (this.godModeItem.isSelected() && (this.autoRotItem.isSelected() || this.autoSolveItem.isSelected())) {
                this.autoRotItem.setSelected(false);
                this.autoSolveItem.setSelected(false);
                this.cube3D.setAutoRotate(false);
                this.autoSolveSet();
            }
            this.solveButton.setEnabled(!this.godModeItem.isSelected());
            this.saveCubeItem.setEnabled(!this.godModeItem.isSelected());
            this.loadCubeItem.setEnabled(!this.godModeItem.isSelected());
            this.shuffleItem.setEnabled(!this.godModeItem.isSelected());
            List<Map<String, Integer>> list = this.undoHistory;
            synchronized (list) {
                this.undoItem.setEnabled(this.godModeItem.isSelected() ? false : !this.undoHistory.isEmpty());
                this.redoItem.setEnabled(this.godModeItem.isSelected() ? false : !this.redoHistory.isEmpty());
            }
            if (this.godModeItem.isSelected()) {
                this.statusLabel.setText("Skapa-l\u00e4ge");
            } else if (this.cube.isRotating()) {
                this.statusLabel.setText(this.cube.getRotationQueueSize() - 1 + " snurrningar i k\u00f6");
            } else {
                this.statusLabel.setText("0 snurrningar i k\u00f6");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoSolveSet() {
        Object object;
        if (this.autoSolveItem.isSelected() && this.godModeItem.isSelected()) {
            this.godModeItem.setSelected(false);
            this.godModeSet();
            if (this.godModeItem.isSelected()) {
                this.autoSolveItem.setSelected(false);
                return;
            }
        } else if (this.cube.isRotating() || this.cube3D.isRotating()) {
            object = this.pleaseWaitPane;
            synchronized (object) {
                this.pleaseWaitPane.setCanCancel(true);
                this.pleaseWaitPane.init();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            while (RCMain.this.pleaseWaitPane.pleaseWait() && (RCMain.this.cube.isRotating() || RCMain.this.cube3D.isRotating())) {
                                if ("Avbryt".equals(RCMain.this.pleaseWaitPane.getValue())) {
                                    RCMain.this.pleaseWaitPane.setCanceled(true);
                                    RCMain.this.pleaseWaitPane.setValue(null);
                                    break;
                                }
                                Thread.sleep(10L);
                            }
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        RCMain.this.pleaseWaitPane.setVisible(false);
                    }
                }.start();
                this.pleaseWaitPane.setLocationRelativeTo(this.mainWindow);
                this.pleaseWaitPane.setVisible(true);
                if (this.pleaseWaitPane.canceled()) {
                    return;
                }
            }
        }
        this.solveButton.setEnabled(!this.autoRotItem.isSelected() && !this.autoSolveItem.isSelected());
        this.shuffleItem.setEnabled(!this.autoRotItem.isSelected() && !this.autoSolveItem.isSelected());
        this.resetItem.setEnabled(!this.autoRotItem.isSelected() && !this.autoSolveItem.isSelected());
        this.loadCubeItem.setEnabled(!this.autoRotItem.isSelected() && !this.autoSolveItem.isSelected());
        object = this.undoHistory;
        synchronized (object) {
            this.undoItem.setEnabled(this.autoSolveItem.isSelected() ? false : !this.undoHistory.isEmpty());
            this.redoItem.setEnabled(this.autoSolveItem.isSelected() ? false : !this.redoHistory.isEmpty());
        }
        this.autoSolve = this.autoSolveItem.isSelected();
        this.cube3D.unblockMouseRotation(this.rotationBlock);
        if (this.autoRotItem.isSelected() || this.autoSolveItem.isSelected()) {
            this.rotationBlock = this.cube3D.blockMouseRotation();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (UNLOCKED) {
            return;
        }
        this.hiddenTyped = this.hiddenTyped + e.getKeyChar();
        if (this.hiddenTyped.length() > UNLOCK.length()) {
            this.hiddenTyped = this.hiddenTyped.substring(this.hiddenTyped.length() - UNLOCK.length(), this.hiddenTyped.length());
        }
        if (this.hiddenTyped.equalsIgnoreCase(UNLOCK)) {
            UNLOCKED = true;
            this.unlocking = true;
            System.out.println("Ponies!");
            this.aboutCloseButton.setEnabled(false);
            if (this.currentSolution != null) {
                SolutionStep ss = this.currentSolution.getStep(this.currentStep);
                this.currentStepStepPanel.removeAll();
                this.createStepSteps();
                if (ss.getSteps() > 0) {
                    for (int i = this.currentStepStep; i <= ss.getSteps(); ++i) {
                        this.currentStepStepPanel.add(this.currentStepSteps[i]);
                    }
                }
                this.currentStepStepPanel.revalidate();
            }
            this.unlocker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cubeChanged(Map<String, Integer> details) {
        if (this.currentSolution == null) {
            List<Map<String, Integer>> list = this.undoHistory;
            synchronized (list) {
                if (!this.undoHistory.contains(details) && !this.redoHistory.contains(details)) {
                    this.redoHistory.clear();
                    this.undoRedoLinks.clear();
                    this.undoHistory.add(0, details);
                    while (this.undoHistory.size() > 100) {
                        this.undoHistory.remove(this.undoHistory.size() - 1);
                    }
                    this.undoItem.setEnabled(!this.autoSolve);
                    this.redoItem.setEnabled(false);
                }
            }
        }
        this.statusLabel.setText(this.cube.getRotationQueueSize() - 1 + " snurrningar i k\u00f6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cubeEdited() {
        List<Map<String, Integer>> list = this.undoHistory;
        synchronized (list) {
            this.undoHistory.clear();
            this.redoHistory.clear();
            this.undoItem.setEnabled(false);
            this.redoItem.setEnabled(false);
            this.resetSolution();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this.mainWindow) {
            this.exit();
        } else {
            this.closeDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        Solver sol;
        this.resetSolution();
        Solver solver = sol = this.solvers[this.solversList.getSelectedIndex()];
        synchronized (solver) {
            sol.init(this.cube);
            this.descriptionScroll.setViewportView(sol.getDescription());
            if (sol.canSolve()) {
                this.solvableLabel.setText("Ja");
                this.solveButton.setEnabled(true);
            } else {
                this.solvableLabel.setText("Nej");
                this.solveButton.setEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.saveCubeItem) {
            int res = this.fileChooser.showSaveDialog(this.mainWindow);
            if (res == 0 && this.cubeFilter.accept(this.fileChooser.getSelectedFile())) {
                try {
                    this.cube.saveCube(this.fileChooser.getSelectedFile());
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else if (src == this.loadCubeItem) {
            int res2 = this.fileChooser.showOpenDialog(this.mainWindow);
            if (res2 == 0 && this.cubeFilter.accept(this.fileChooser.getSelectedFile())) {
                try {
                    this.cube.loadCube(this.fileChooser.getSelectedFile());
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else if (src == this.exitItem) {
            this.exit();
        } else if (src == this.undoItem) {
            if (this.currentSolution == null) {
                this.undo();
            } else {
                this.prevStepStep();
            }
        } else if (src == this.redoItem) {
            if (this.currentSolution == null) {
                this.redo();
            } else {
                this.nextStepStep();
            }
        } else if (src == this.shuffleItem) {
            this.cube.shuffle(1);
            if (this.cube.isRotating()) {
                this.statusLabel.setText(this.cube.getRotationQueueSize() - 1 + " snurrningar i k\u00f6");
            } else {
                this.statusLabel.setText("0 snurrningar i k\u00f6");
            }
        } else if (src == this.godModeItem) {
            this.godModeSet();
        } else if (src == this.resetItem) {
            int res;
            if (this.cube.isRotating()) {
                PleaseWaitPane res2 = this.pleaseWaitPane;
                synchronized (res2) {
                    this.pleaseWaitPane.setCanCancel(true);
                    this.pleaseWaitPane.init();
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                while (RCMain.this.pleaseWaitPane.pleaseWait() && RCMain.this.cube.isRotating()) {
                                    if ("Avbryt".equals(RCMain.this.pleaseWaitPane.getValue())) {
                                        RCMain.this.pleaseWaitPane.setCanceled(true);
                                        RCMain.this.pleaseWaitPane.setValue(null);
                                        break;
                                    }
                                    Thread.sleep(10L);
                                }
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            RCMain.this.pleaseWaitPane.setVisible(false);
                        }
                    }.start();
                    this.pleaseWaitPane.setLocationRelativeTo(this.mainWindow);
                    this.pleaseWaitPane.setVisible(true);
                    if (this.pleaseWaitPane.canceled()) {
                        return;
                    }
                }
            }
            if ((res = JOptionPane.showConfirmDialog(this.mainWindow, "\u00c4r du s\u00e4ker p\u00e5 att du vill \u00e5terst\u00e4lla kuben?", "RRobot", 0)) == 0) {
                this.cube.reset();
            }
        } else if (src == this.autoRotItem) {
            Object res;
            if (this.godModeItem.isSelected()) {
                this.godModeItem.setSelected(false);
                this.godModeSet();
                if (this.godModeItem.isSelected()) {
                    this.autoRotItem.setSelected(false);
                    return;
                }
            } else if (this.cube3D.isRotating()) {
                res = this.pleaseWaitPane;
                synchronized (res) {
                    this.pleaseWaitPane.setCanCancel(true);
                    this.pleaseWaitPane.init();
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                while (RCMain.this.pleaseWaitPane.pleaseWait() && RCMain.this.cube3D.isRotating()) {
                                    if ("Avbryt".equals(RCMain.this.pleaseWaitPane.getValue())) {
                                        RCMain.this.pleaseWaitPane.setCanceled(true);
                                        RCMain.this.pleaseWaitPane.setValue(null);
                                        break;
                                    }
                                    Thread.sleep(10L);
                                }
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            RCMain.this.pleaseWaitPane.setVisible(false);
                        }
                    }.start();
                    this.pleaseWaitPane.setLocationRelativeTo(this.mainWindow);
                    this.pleaseWaitPane.setVisible(true);
                    if (this.pleaseWaitPane.canceled()) {
                        return;
                    }
                }
            }
            this.solveButton.setEnabled(!this.autoRotItem.isSelected() && !this.autoSolveItem.isSelected());
            this.shuffleItem.setEnabled(!this.autoRotItem.isSelected() && !this.autoSolveItem.isSelected());
            res = this.undoHistory;
            synchronized (res) {
                this.undoItem.setEnabled(this.autoRotItem.isSelected() ? false : !this.undoHistory.isEmpty());
                this.redoItem.setEnabled(this.autoRotItem.isSelected() ? false : !this.redoHistory.isEmpty());
            }
            this.cube3D.setAutoRotate(this.autoRotItem.isSelected());
            this.cube3D.unblockMouseRotation(this.rotationBlock);
            if (this.autoRotItem.isSelected() || this.autoSolveItem.isSelected()) {
                this.rotationBlock = this.cube3D.blockMouseRotation();
            }
        } else if (src == this.autoSolveItem) {
            this.autoSolveSet();
        } else if (src == this.showLogItem) {
            if (Log.getDialog().isVisible()) {
                Log.getDialog().requestFocus();
            } else {
                Log.getDialog().setLocationRelativeTo(this.mainWindow);
                Log.getDialog().setVisible(true);
            }
        } else if (src == this.aboutItem) {
            this.aboutDialog.setLocationRelativeTo(this.mainWindow);
            this.aboutDialog.setVisible(true);
        } else if (src == this.aboutCloseButton) {
            this.closeDialog();
        } else if (src == this.solveButton) {
            if (this.currentSolution == null) {
                if (this.cube.isRotating() || this.cube3D.isRotating()) {
                    PleaseWaitPane res = this.pleaseWaitPane;
                    synchronized (res) {
                        this.pleaseWaitPane.setCanCancel(true);
                        this.pleaseWaitPane.init();
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    while (RCMain.this.pleaseWaitPane.pleaseWait() && (RCMain.this.cube.isRotating() || RCMain.this.cube3D.isRotating())) {
                                        if ("Avbryt".equals(RCMain.this.pleaseWaitPane.getValue())) {
                                            RCMain.this.pleaseWaitPane.setCanceled(true);
                                            RCMain.this.pleaseWaitPane.setValue(null);
                                            break;
                                        }
                                        Thread.sleep(10L);
                                    }
                                }
                                catch (InterruptedException ex) {
                                    Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                RCMain.this.pleaseWaitPane.setVisible(false);
                            }
                        }.start();
                        this.pleaseWaitPane.setLocationRelativeTo(this.mainWindow);
                        this.pleaseWaitPane.setVisible(true);
                        if (this.pleaseWaitPane.canceled()) {
                            return;
                        }
                    }
                }
                this.solveButton.setText("Avbryt l\u00f6sning");
                Solver sol = this.solvers[this.solversList.getSelectedIndex()];
                this.loadCubeItem.setEnabled(false);
                this.godModeItem.setEnabled(false);
                this.autoRotItem.setEnabled(false);
                this.autoSolveItem.setEnabled(false);
                this.resetItem.setEnabled(false);
                this.shuffleItem.setEnabled(false);
                Solver solver = sol;
                synchronized (solver) {
                    this.rotationBlock = this.cube3D.blockMouseRotation();
                    sol.init(this.cube);
                    this.currentSolution = sol.solveCube();
                    this.currentStep = -1;
                    this.nextStep();
                }
            }
            this.resetSolution();
        } else if (src == this.prevStepButton) {
            this.prevStep();
        } else if (src == this.nextStepButton) {
            this.nextStep();
        } else if (src == this.prevStepStepButton) {
            this.prevStepStep();
        } else if (src == this.nextStepStepButton) {
            this.nextStepStep();
        }
    }

    private void nextStep() {
        if (this.currentStep >= 0) {
            SolutionStep ss = this.currentSolution.getStep(this.currentStep);
            while (this.currentStepStep < ss.getSteps()) {
                this.nextStepStep();
            }
        }
        if (this.currentStep + 1 == this.currentSolution.getSteps()) {
            this.resetSolution();
        } else if (this.currentStep + 1 < this.currentSolution.getSteps()) {
            ++this.currentStep;
            this.calcStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prevStep() {
        if (this.currentStep > 0) {
            int i2;
            while (this.currentStepStep > 0) {
                this.prevStepStep();
            }
            --this.currentStep;
            this.calcStep();
            SolutionStep ss = this.currentSolution.getStep(this.currentStep);
            this.currentStepStep = ss.getSteps();
            for (i2 = 0; i2 < this.currentStepStep; ++i2) {
                this.currentStepStepPanel.remove(0);
            }
            while (this.currentStepStep > 0) {
                this.prevStepStep();
            }
            if (this.cube.isRotating() || this.cube3D.isRotating()) {
                PleaseWaitPane i2 = this.pleaseWaitPane;
                synchronized (i2) {
                    this.pleaseWaitPane.setCanCancel(false);
                    this.pleaseWaitPane.init();
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                while (RCMain.this.pleaseWaitPane.pleaseWait() && (RCMain.this.cube.isRotating() || RCMain.this.cube3D.isRotating())) {
                                    Thread.sleep(10L);
                                }
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            RCMain.this.pleaseWaitPane.setVisible(false);
                        }
                    }.start();
                    this.pleaseWaitPane.setLocationRelativeTo(this.mainWindow);
                    this.pleaseWaitPane.setVisible(true);
                }
            }
            this.currentStepStepPanel.removeAll();
            this.createStepSteps();
            if (ss.getSteps() > 0) {
                for (i2 = 0; i2 <= ss.getSteps(); ++i2) {
                    this.currentStepStepPanel.add(this.currentStepSteps[i2]);
                }
            }
            this.currentStepStepPanel.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcStep() {
        this.nextStepButton.setEnabled(this.currentStep + 1 <= this.currentSolution.getSteps());
        this.prevStepButton.setEnabled(this.currentStep > 0);
        if (this.currentStep < this.currentSolution.getSteps()) {
            SolutionStep ss = this.currentSolution.getStep(this.currentStep);
            this.currentStepBorder.setTitle("Steg " + (this.currentStep + 1) + " av " + this.currentSolution.getSteps());
            this.currentStepLabel.repaint();
            this.currentStepLabel.setText("<html>" + ss.getDescription() + "</html>");
            this.cube3D.clearRotations();
            if (this.cube.isRotating() || this.cube3D.isRotating()) {
                PleaseWaitPane pleaseWaitPane = this.pleaseWaitPane;
                synchronized (pleaseWaitPane) {
                    this.pleaseWaitPane.setCanCancel(false);
                    this.pleaseWaitPane.init();
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                while (RCMain.this.pleaseWaitPane.pleaseWait() && (RCMain.this.cube.isRotating() || RCMain.this.cube3D.isRotating())) {
                                    Thread.sleep(10L);
                                }
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            RCMain.this.pleaseWaitPane.setVisible(false);
                        }
                    }.start();
                    this.pleaseWaitPane.setLocationRelativeTo(this.mainWindow);
                    this.pleaseWaitPane.setVisible(true);
                }
            }
            this.currentStepStepPanel.removeAll();
            this.createStepSteps();
            if (ss.getSteps() > 0) {
                for (int i = 0; i <= ss.getSteps(); ++i) {
                    this.currentStepStepPanel.add(this.currentStepSteps[i]);
                }
            }
            if (this.stepHighlight != null) {
                this.cube3D.getCube3D().removeHighlight(this.stepHighlight);
            }
            this.stepHighlight = ss.hasHighlights() ? this.cube3D.getCube3D().highlightCubies(this.cube3D.getCube3D().convertFaceletsToCubies(ss.getHighlights()), Color.CYAN, 0, ss.isHighlightsStill()) : null;
            block10: for (int a = 0; a < ss.getRotations(); ++a) {
                switch (ss.getRotationType(a)) {
                    case 0: {
                        this.cube3D.makeFaceInFront(ss.getRotationFace(a));
                        continue block10;
                    }
                    case 1: {
                        this.cube3D.makeFaceInFrontUpsideDown(ss.getRotationFace(a));
                        continue block10;
                    }
                    case 2: {
                        this.cube3D.makeFaceOnSide(ss.getRotationFace(a));
                        continue block10;
                    }
                    case 3: {
                        this.cube3D.makeFaceOnSideUpsideDown(ss.getRotationFace(a));
                    }
                }
            }
            this.currentStepStepPanel.revalidate();
            this.currentStepStep = -1;
            this.nextStepStep();
        }
    }

    private void createStepSteps() {
        SolutionStep ss = this.currentSolution.getStep(this.currentStep);
        this.currentStepSteps = new JLabel[ss.getSteps() + 1];
        Integer[][][] cb = this.cube.getFaces();
        int lastType = -1;
        Map<String, Integer> lastDetails = null;
        for (int i = 0; i < ss.getSteps(); ++i) {
            BufferedImage img = null;
            switch (ss.getStepType(i)) {
                case 0: {
                    img = CubeViewerPseudo3D.createFaceInFront(100, 100, ss.getStep(i), cb);
                    break;
                }
                case 1: {
                    img = CubeViewerPseudo3D.createFaceInFrontUpsideDown(100, 100, ss.getStep(i), cb);
                    break;
                }
                case 2: {
                    img = CubeViewerPseudo3D.createFaceOnSide(100, 100, ss.getStep(i), cb);
                    break;
                }
                case 3: {
                    img = CubeViewerPseudo3D.createFaceOnSideUpsideDown(100, 100, ss.getStep(i), cb);
                }
            }
            lastType = ss.getStepType(i);
            lastDetails = ss.getStep(i);
            cb = CubeMath.rotateCube(cb, ss.getStep(i));
            this.currentStepSteps[i] = new JLabel(new ImageIcon(img));
        }
        BufferedImage img = null;
        switch (lastType) {
            case 0: {
                img = CubeViewerPseudo3D.createFaceInFrontNoAddon(100, 100, lastDetails, cb);
                break;
            }
            case 1: {
                img = CubeViewerPseudo3D.createFaceInFrontUpsideDownNoAddon(100, 100, lastDetails, cb);
                break;
            }
            case 2: {
                img = CubeViewerPseudo3D.createFaceOnSideNoAddon(100, 100, lastDetails, cb);
                break;
            }
            case 3: {
                img = CubeViewerPseudo3D.createFaceOnSideUpsideDownNoAddon(100, 100, lastDetails, cb);
            }
        }
        if (img != null) {
            this.currentStepSteps[ss.getSteps()] = new JLabel(new ImageIcon(img));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextStepStep() {
        SolutionStep ss = this.currentSolution.getStep(this.currentStep);
        if (this.currentStepStep < ss.getSteps()) {
            if (this.currentStepStep >= 0) {
                List<Map<String, Integer>> list = this.undoHistory;
                synchronized (list) {
                    this.undoHistory.add(0, ss.getStep(this.currentStepStep));
                }
                this.undoItem.setEnabled(true);
                this.cube.rotateCube(ss.getStep(this.currentStepStep));
                if (this.cube.isRotating()) {
                    this.statusLabel.setText(this.cube.getRotationQueueSize() - 1 + " snurrningar i k\u00f6");
                } else {
                    this.statusLabel.setText("0 snurrningar i k\u00f6");
                }
                this.currentStepStepPanel.remove(0);
                this.currentStepStepPanel.revalidate();
            } else {
                this.undoItem.setEnabled(false);
            }
            ++this.currentStepStep;
            this.calcStepStep();
        }
    }

    private void prevStepStep() {
        if (this.currentStepStep > 0) {
            --this.currentStepStep;
            if (this.currentStepStep >= 0) {
                this.undo();
                this.redoItem.setEnabled(false);
                this.currentStepStepPanel.add((Component)this.currentStepSteps[this.currentStepStep], 0);
                this.currentStepStepPanel.revalidate();
            }
            if (this.currentStepStep <= 0) {
                this.undoItem.setEnabled(false);
            }
            this.calcStepStep();
        }
    }

    private void calcStepStep() {
        SolutionStep ss = this.currentSolution.getStep(this.currentStep);
        if (ss.getSteps() > 0) {
            this.nextStepStepButton.setEnabled(this.currentStepStep < ss.getSteps());
            this.prevStepStepButton.setEnabled(this.currentStepStep > 0);
            if (this.currentStepStep < ss.getSteps()) {
                this.currentStepStepBorder.setTitle("Snurr " + (this.currentStepStep + 1) + " av " + ss.getSteps());
            } else {
                this.currentStepStepBorder.setTitle("Snurr " + ss.getSteps() + " av " + ss.getSteps());
            }
            this.currentStepStepBorderFix.repaint();
        } else {
            if (!this.nextStepButton.isEnabled()) {
                if (this.stepHighlight != null) {
                    this.cube3D.getCube3D().removeHighlight(this.stepHighlight);
                }
                this.stepHighlight = null;
            }
            this.prevStepStepButton.setEnabled(this.currentStepStep > 0);
            this.nextStepStepButton.setEnabled(this.currentStepStep < ss.getSteps());
            this.currentStepStepBorder.setTitle("Snurr N/A");
            this.currentStepStepBorderFix.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSolution() {
        Solver sol;
        this.cube3D.clearRotations();
        this.cube.waitForRotation();
        this.cube3D.waitForRotation();
        List<Map<String, Integer>> list = this.undoHistory;
        synchronized (list) {
            this.undoItem.setEnabled(!this.undoHistory.isEmpty());
            this.redoItem.setEnabled(!this.redoHistory.isEmpty());
        }
        this.loadCubeItem.setEnabled(true);
        this.godModeItem.setEnabled(true);
        this.autoRotItem.setEnabled(true);
        this.autoSolveItem.setEnabled(true);
        this.resetItem.setEnabled(true);
        this.shuffleItem.setEnabled(true);
        this.prevStepButton.setEnabled(false);
        this.nextStepButton.setEnabled(false);
        this.prevStepStepButton.setEnabled(false);
        this.nextStepStepButton.setEnabled(false);
        this.currentStepBorder.setTitle("Step N/A");
        this.currentStepLabel.repaint();
        this.currentStepLabel.setText("");
        this.currentStepStepBorder.setTitle("Snurr N/A");
        this.currentStepStepBorderFix.repaint();
        this.currentStepStepPanel.removeAll();
        this.solveButton.setText("L\u00f6s kuben \u00e5t mig");
        Solver solver = sol = this.solvers[this.solversList.getSelectedIndex()];
        synchronized (solver) {
            sol.init(this.cube);
            if (sol.canSolve()) {
                this.solvableLabel.setText("Ja");
                this.solveButton.setEnabled(!this.godModeItem.isSelected());
            } else {
                this.solvableLabel.setText("Nej");
                this.solveButton.setEnabled(false);
            }
        }
        this.currentSolution = null;
        if (this.stepHighlight != null) {
            this.cube3D.getCube3D().removeHighlight(this.stepHighlight);
        }
        this.stepHighlight = null;
        this.currentStepSteps = null;
        this.cube3D.unblockMouseRotation(this.rotationBlock);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void godModeSet(boolean godMode) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    static {
        MANE6_PATH = new String[]{"/res/rarity_filly_by_blackm3sh-d3d331z.png", "/res/pinkie_pie_filly_by_blackm3sh-d3d3y5k.png", "/res/applejack_filly_by_blackm3sh-d3d2y8u.png", "/res/friendship_is_magic_fillies_by_blackm3sh-d3d2xp6.png", "/res/twilight_sparkle_filly_by_blackm3sh-d3d2ybv.png", "/res/rainbow_dash_filly_by_blackm3sh-d3d2yhk.png"};
        BufferedImage tempSeal = null;
        BufferedImage[] tempMane6 = new BufferedImage[6];
        try {
            tempSeal = ImageIO.read(RCMain.class.getResourceAsStream(HIDDEN_SEAL_PATH));
            for (int face = 0; face < 6; ++face) {
                tempMane6[face] = ImageIO.read(RCMain.class.getResourceAsStream(MANE6_PATH[face]));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(RCMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        HIDDEN_SEAL = tempSeal;
        MANE6 = tempMane6;
    }
}

