/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.gui.graphics2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import rubikscube.game.RubiksCube;
import rubikscube.game.RubiksCubeListener;
import rubikscube.gui.graphics2d.PaintListener;

public class CubeViewer2D
implements PaintListener,
RubiksCubeListener {
    private static final int FACELET_MIN = 5;
    private static final int FACELET_PREF = 15;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private RubiksCube cube;
    private Component owner;
    private int orientation;
    private int oldOrientation;
    private Dimension oldSize;
    private Rectangle2D.Float[][][] facelets;

    public CubeViewer2D(RubiksCube cube, Component owner) {
        this.oldOrientation = this.orientation = 0;
        if (cube == null) {
            throw new NullPointerException("cube == null");
        }
        if (owner == null) {
            throw new NullPointerException("owner == null");
        }
        this.cube = cube;
        this.owner = owner;
        cube.addCubeListener(this);
        this.oldSize = new Dimension(-1, -1);
        this.facelets = new Rectangle2D.Float[cube.getFaces().length][cube.getSize()][cube.getSize()];
        for (int face = 0; face < cube.getFaces().length; ++face) {
            for (int x = 0; x < cube.getSize(); ++x) {
                for (int y = 0; y < cube.getSize(); ++y) {
                    this.facelets[face][x][y] = new Rectangle2D.Float();
                }
            }
        }
    }

    public void setCube(RubiksCube newCube) {
        if (newCube == null) {
            throw new NullPointerException("cube == null");
        }
        if (newCube.equals(this.cube)) {
            return;
        }
        if (this.cube.getSize() != newCube.getSize()) {
            this.facelets = new Rectangle2D.Float[newCube.getFaces().length][newCube.getSize()][newCube.getSize()];
            for (int face = 0; face < newCube.getFaces().length; ++face) {
                for (int x = 0; x < newCube.getSize(); ++x) {
                    for (int y = 0; y < newCube.getSize(); ++y) {
                        this.facelets[face][x][y] = new Rectangle2D.Float();
                    }
                }
            }
        }
        this.cube = newCube;
        this.cube.addCubeListener(this);
    }

    public RubiksCube getCube() {
        return this.cube;
    }

    public void setOrientation(int newOrientation) {
        if (newOrientation < 0 || newOrientation > 1) {
            return;
        }
        if (newOrientation != this.orientation) {
            this.oldSize = new Dimension(-1, -1);
        }
        this.oldOrientation = this.orientation;
        this.orientation = newOrientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public void onPaint(Component source, Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float width = source.getWidth();
        float height = source.getHeight();
        float cenX = width / 2.0f;
        float cenY = height / 2.0f;
        float radius = Math.min(width, height) / 2.0f - 10.0f;
        float faceletLength = radius / (float)(2 * this.cube.getSize());
        if (!source.getSize().equals(this.oldSize) || this.oldOrientation != this.orientation) {
            int y;
            int x;
            float baseX = 0.0f;
            float baseY = 0.0f;
            if (this.orientation == 0) {
                if (width < height) {
                    float fl = (height / 2.0f - 10.0f) / (float)(2 * this.cube.getSize());
                    faceletLength = fl * (float)this.cube.getSize() * 1.5f < radius ? fl : radius / (1.5f * (float)this.cube.getSize());
                }
                if (width != (float)this.oldSize.width || this.oldOrientation != this.orientation) {
                    for (int face = 0; face < this.cube.getFaces().length; ++face) {
                        if (face == 0 || face >= 4) {
                            baseX = cenX - faceletLength * (float)this.cube.getSize() / 2.0f;
                        } else if (face >= 1 && face <= 3) {
                            baseX = cenX - faceletLength * (float)this.cube.getSize() / 2.0f + faceletLength * (float)this.cube.getSize() * (float)(face - 2);
                        }
                        for (x = 0; x < this.cube.getSize(); ++x) {
                            for (y = 0; y < this.cube.getSize(); ++y) {
                                this.facelets[face][x][y].x = baseX + faceletLength * (float)x;
                                this.facelets[face][x][y].width = faceletLength;
                            }
                        }
                    }
                }
                if (height != (float)this.oldSize.height || this.oldOrientation != this.orientation) {
                    for (int face = 0; face < this.cube.getFaces().length; ++face) {
                        baseY = face == 0 ? cenY - faceletLength * (float)this.cube.getSize() * 2.0f : (face >= 1 && face <= 3 ? cenY - faceletLength * (float)this.cube.getSize() : cenY + faceletLength * (float)this.cube.getSize() * (float)(face - 4));
                        for (x = 0; x < this.cube.getSize(); ++x) {
                            for (y = 0; y < this.cube.getSize(); ++y) {
                                this.facelets[face][x][y].y = baseY + faceletLength * (float)y;
                                this.facelets[face][x][y].height = faceletLength;
                            }
                        }
                    }
                }
            } else if (this.orientation == 1) {
                if (height < width) {
                    float fl = (width / 2.0f - 10.0f) / (float)(2 * this.cube.getSize());
                    faceletLength = fl * (float)this.cube.getSize() * 1.5f < radius ? fl : radius / (1.5f * (float)this.cube.getSize());
                }
                if (width != (float)this.oldSize.width || this.oldOrientation != this.orientation) {
                    for (int face = 0; face < this.cube.getFaces().length; ++face) {
                        baseX = face == 0 ? cenX - faceletLength * (float)this.cube.getSize() * 2.0f : (face >= 1 && face <= 3 ? cenX - faceletLength * (float)this.cube.getSize() : cenX + faceletLength * (float)this.cube.getSize() * (float)(face - 4));
                        for (x = 0; x < this.cube.getSize(); ++x) {
                            for (y = 0; y < this.cube.getSize(); ++y) {
                                this.facelets[face][x][y].x = baseX + faceletLength * (float)y;
                                this.facelets[face][x][y].width = faceletLength;
                            }
                        }
                    }
                }
                if (height != (float)this.oldSize.height || this.oldOrientation != this.orientation) {
                    for (int face = 0; face < this.cube.getFaces().length; ++face) {
                        if (face == 0 || face >= 4) {
                            baseY = cenY - faceletLength + faceletLength * ((float)this.cube.getSize() / 2.0f);
                        } else if (face >= 1 && face <= 3) {
                            baseY = cenY - faceletLength + faceletLength * ((float)this.cube.getSize() / 2.0f) - faceletLength * (float)this.cube.getSize() * (float)(face - 2);
                        }
                        for (x = 0; x < this.cube.getSize(); ++x) {
                            for (y = 0; y < this.cube.getSize(); ++y) {
                                this.facelets[face][x][y].y = baseY - faceletLength * (float)x;
                                this.facelets[face][x][y].height = faceletLength;
                            }
                        }
                    }
                }
            }
            this.oldOrientation = this.orientation;
        }
        g2d.setStroke(new BasicStroke((int)faceletLength / 5));
        for (int face = 0; face < this.cube.getFaces().length; ++face) {
            for (int x = 0; x < this.cube.getSize(); ++x) {
                for (int y = 0; y < this.cube.getSize(); ++y) {
                    g2d.setColor(RubiksCube.FACE_COLORS[this.cube.getFacelet(face, x, y)]);
                    g2d.fill(this.facelets[face][x][y]);
                    g2d.setColor(Color.BLACK);
                    g2d.draw(this.facelets[face][x][y]);
                }
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.orientation == 0) {
            return new Dimension(this.cube.getSize() * 3 * 5, this.cube.getSize() * 4 * 5);
        }
        if (this.orientation == 1) {
            return new Dimension(this.cube.getSize() * 4 * 5, this.cube.getSize() * 3 * 5);
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.orientation == 0) {
            return new Dimension(this.cube.getSize() * 3 * 15, this.cube.getSize() * 4 * 15);
        }
        if (this.orientation == 1) {
            return new Dimension(this.cube.getSize() * 4 * 15, this.cube.getSize() * 3 * 15);
        }
        return null;
    }

    @Override
    public Dimension getMaximumSize() {
        return null;
    }

    @Override
    public void cubeChanged(Map<String, Integer> details) {
        this.owner.repaint();
    }

    @Override
    public void cubeEdited() {
        this.owner.repaint();
    }

    @Override
    public void godModeSet(boolean godMode) {
    }
}

