/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.gui.graphics2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import rubikscube.game.RubiksCube;
import rubikscube.gui.RCMain;

public class CubeViewerPseudo3D {
    private static PsuedoVariables createFrontVariables(int width, int height, int cubeSize) {
        PsuedoVariables pv = new PsuedoVariables();
        pv.cubeSize = cubeSize;
        pv.h = pv.w = (double)(Math.min(width, height) - 1);
        pv.offset = pv.w / 35.0;
        pv.baseX = (double)width / 2.0 - pv.w / 2.0;
        pv.baseY = (double)height / 2.0 - pv.h / 2.0;
        pv.stroke = pv.w / 35.0;
        pv.topBaseX = pv.offset + pv.stroke / 2.0;
        pv.topBaseY = pv.offset + pv.h / 5.0;
        pv.topW = (pv.w / 2.0 - pv.topBaseX) / (double)pv.cubeSize;
        pv.topH = (pv.h - pv.offset - pv.stroke - pv.topBaseY) / (double)pv.cubeSize / 4.0 * 3.0;
        pv.sideBaseX = pv.offset;
        pv.sideBaseY = pv.offset + pv.h / 5.0;
        pv.sideW = (pv.w / 2.0 - pv.sideBaseX) / (double)pv.cubeSize;
        pv.sideH = (pv.h - pv.offset - pv.sideBaseY) / (double)pv.cubeSize / 4.0 * 3.0;
        pv.frontBaseX = pv.w / 2.0;
        pv.frontBaseY = pv.sideBaseY;
        pv.frontW = pv.sideW;
        pv.frontH = pv.sideH;
        return pv;
    }

    private static Path2D.Double[][][] createTopSideFrontFaces(PsuedoVariables pv) {
        Path2D.Double[][][] faces = new Path2D.Double[3][pv.cubeSize][pv.cubeSize];
        for (int x = 0; x < pv.cubeSize; ++x) {
            for (int y = 0; y < pv.cubeSize; ++y) {
                faces[0][x][y] = new Path2D.Double();
                faces[0][x][y].moveTo(pv.baseX + pv.topBaseX + pv.topW * (double)x + pv.topW * (double)y, pv.baseY + pv.topBaseY - pv.topH / 3.0 * (double)x + pv.topH / 3.0 * (double)y);
                faces[0][x][y].lineTo(pv.baseX + pv.topBaseX + pv.topW * (double)(x + 1) + pv.topW * (double)y, pv.baseY + pv.topBaseY - pv.topH / 3.0 * (double)(x + 1) + pv.topH / 3.0 * (double)y);
                faces[0][x][y].lineTo(pv.baseX + pv.topBaseX + pv.topW * (double)(x + 2) + pv.topW * (double)y, pv.baseY + pv.topBaseY - pv.topH / 3.0 * (double)x + pv.topH / 3.0 * (double)y);
                faces[0][x][y].lineTo(pv.baseX + pv.topBaseX + pv.topW * (double)(x + 1) + pv.topW * (double)y, pv.baseY + pv.topBaseY - pv.topH / 3.0 * (double)(x - 1) + pv.topH / 3.0 * (double)y);
                faces[0][x][y].closePath();
                faces[1][x][y] = new Path2D.Double();
                faces[1][x][y].moveTo(pv.baseX + pv.sideBaseX + pv.sideW * (double)x, pv.baseY + pv.sideBaseY + pv.sideH * (double)y + pv.sideH / 3.0 * (double)x);
                faces[1][x][y].lineTo(pv.baseX + pv.sideBaseX + pv.sideW * (double)(x + 1), pv.baseY + pv.sideBaseY + pv.sideH * (double)y + pv.sideH / 3.0 * (double)(x + 1));
                faces[1][x][y].lineTo(pv.baseX + pv.sideBaseX + pv.sideW * (double)(x + 1), pv.baseY + pv.sideBaseY + pv.sideH * (double)(y + 1) + pv.sideH / 3.0 * (double)(x + 1));
                faces[1][x][y].lineTo(pv.baseX + pv.sideBaseX + pv.sideW * (double)x, pv.baseY + pv.sideBaseY + pv.sideH * (double)(y + 1) + pv.sideH / 3.0 * (double)x);
                faces[1][x][y].closePath();
                faces[2][x][y] = new Path2D.Double();
                faces[2][x][y].moveTo(pv.baseX + pv.frontBaseX + pv.frontW * (double)x, pv.baseY + pv.frontBaseY + pv.frontH * (double)y + pv.frontH / 3.0 * (double)(pv.cubeSize - x));
                faces[2][x][y].lineTo(pv.baseX + pv.frontBaseX + pv.frontW * (double)(x + 1), pv.baseY + pv.frontBaseY + pv.frontH * (double)y + pv.frontH / 3.0 * (double)(pv.cubeSize - 1 - x));
                faces[2][x][y].lineTo(pv.baseX + pv.frontBaseX + pv.frontW * (double)(x + 1), pv.baseY + pv.frontBaseY + pv.frontH * (double)(y + 1) + pv.frontH / 3.0 * (double)(pv.cubeSize - 1 - x));
                faces[2][x][y].lineTo(pv.baseX + pv.frontBaseX + pv.frontW * (double)x, pv.baseY + pv.frontBaseY + pv.frontH * (double)(y + 1) + pv.frontH / 3.0 * (double)(pv.cubeSize - x));
                faces[2][x][y].closePath();
            }
        }
        return faces;
    }

    private static void paintTopSideFrontGrid(PsuedoVariables pv, Graphics2D g2d) {
        Path2D.Double temp = new Path2D.Double();
        g2d.setColor(Color.BLACK);
        for (int i = 0; i <= pv.cubeSize; ++i) {
            temp.moveTo(pv.baseX + pv.sideBaseX + pv.sideW * (double)i, pv.baseY + pv.sideBaseY + pv.sideH * (double)pv.cubeSize + pv.sideH / 3.0 * (double)i);
            temp.lineTo(pv.baseX + pv.sideBaseX + pv.sideW * (double)i, pv.baseY + pv.sideBaseY + pv.sideH / 3.0 * (double)i);
            temp.lineTo(pv.baseX + pv.topBaseX + pv.topW * (double)pv.cubeSize + pv.topW * (double)i, pv.baseY + pv.topBaseY - pv.topH / 3.0 * (double)pv.cubeSize + pv.topH / 3.0 * (double)i);
            g2d.draw(temp);
            temp.reset();
            temp.moveTo(pv.baseX + pv.sideBaseX, pv.baseY + pv.sideBaseY + pv.sideH * (double)i);
            temp.lineTo(pv.baseX + pv.sideBaseX + pv.sideW * (double)pv.cubeSize, pv.baseY + pv.sideBaseY + pv.sideH * (double)i + pv.sideH / 3.0 * (double)pv.cubeSize);
            temp.lineTo(pv.baseX + pv.frontBaseX + pv.frontW * (double)pv.cubeSize, pv.baseY + pv.sideBaseY + pv.sideH * (double)i);
            g2d.draw(temp);
            temp.reset();
            temp.moveTo(pv.baseX + pv.sideBaseX + pv.sideW * (double)i, pv.baseY + pv.topBaseY - pv.topH / 3.0 * (double)pv.cubeSize + pv.topH / 3.0 * (double)(pv.cubeSize - i));
            temp.lineTo(pv.baseX + pv.topBaseX + pv.topW * (double)pv.cubeSize + pv.topW * (double)i, pv.baseY + pv.sideBaseY + pv.sideH / 3.0 * (double)(pv.cubeSize - i));
            temp.lineTo(pv.baseX + pv.topBaseX + pv.topW * (double)pv.cubeSize + pv.topW * (double)i, pv.baseY + pv.sideBaseY + pv.sideH * (double)pv.cubeSize + pv.sideH / 3.0 * (double)(pv.cubeSize - i));
            g2d.draw(temp);
            temp.reset();
        }
    }

    public static BufferedImage createFaceInFront(int width, int height, Map<String, Integer> details, Integer[][][] cube) {
        int face = details.get("face");
        int direction = details.get("direction");
        int cubeSize = cube[0].length;
        BufferedImage img = CubeViewerPseudo3D.createFaceInFront(width, height, face, cube);
        switch (details.get("method")) {
            case 10: {
                img = CubeViewerPseudo3D.addFrontFace(img, direction, cubeSize);
                break;
            }
            case 11: {
                img = CubeViewerPseudo3D.addFrontRow(img, face, details.get("rowcolumn"), direction, cubeSize);
                break;
            }
            case 12: {
                img = CubeViewerPseudo3D.addFrontColumn(img, face, details.get("rowcolumn"), direction, cubeSize);
            }
        }
        return img;
    }

    public static BufferedImage createFaceInFrontNoAddon(int width, int height, Map<String, Integer> details, Integer[][][] cube) {
        int face = details.get("face");
        return CubeViewerPseudo3D.createFaceInFront(width, height, face, cube);
    }

    public static BufferedImage createFaceInFront(int width, int height, int face, Integer[][][] cube) {
        BufferedImage ret = new BufferedImage(width, height, 2);
        Graphics2D g2d = ret.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int size = cube[0].length;
        if (RCMain.UNLOCKED) {
            int x = width / 2 - 50;
            int y = height / 2 - 50;
            g2d.drawImage((Image)RCMain.MANE6[cube[face][size / 2][size / 2]], x, y, null);
            g2d.dispose();
            return ret;
        }
        PsuedoVariables pv = CubeViewerPseudo3D.createFrontVariables(width, height, size);
        g2d.setStroke(new BasicStroke((int)pv.stroke));
        Path2D.Double[][][] faces = CubeViewerPseudo3D.createTopSideFrontFaces(pv);
        switch (face) {
            case 0: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[5][x][y]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[1][y][pv.cubeSize - 1 - x]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[0][x][y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 1: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[0][pv.cubeSize - 1 - y][x]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[5][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[1][x][y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 2: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[0][x][y]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[1][x][y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[2][x][y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 3: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[0][y][pv.cubeSize - 1 - x]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[2][x][y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[3][x][y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 4: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[2][x][y]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[1][pv.cubeSize - 1 - y][x]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[4][x][y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 5: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[0][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[3][x][y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[5][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
        }
        CubeViewerPseudo3D.paintTopSideFrontGrid(pv, g2d);
        g2d.dispose();
        return ret;
    }

    public static BufferedImage createFaceInFrontUpsideDown(int width, int height, Map<String, Integer> details, Integer[][][] cube) {
        int face = details.get("face");
        int direction = details.get("direction");
        int cubeSize = cube[0].length;
        BufferedImage img = CubeViewerPseudo3D.createFaceInFrontUpsideDown(width, height, face, cube);
        switch (details.get("method")) {
            case 10: {
                img = CubeViewerPseudo3D.addFrontFace(img, direction, cubeSize);
                break;
            }
            case 11: {
                img = CubeViewerPseudo3D.addFrontRowUpsideDown(img, face, details.get("rowcolumn"), direction, cubeSize);
                break;
            }
            case 12: {
                img = CubeViewerPseudo3D.addFrontColumnUpsideDown(img, face, details.get("rowcolumn"), direction, cubeSize);
            }
        }
        return img;
    }

    public static BufferedImage createFaceInFrontUpsideDownNoAddon(int width, int height, Map<String, Integer> details, Integer[][][] cube) {
        int face = details.get("face");
        return CubeViewerPseudo3D.createFaceInFrontUpsideDown(width, height, face, cube);
    }

    public static BufferedImage createFaceInFrontUpsideDown(int width, int height, int face, Integer[][][] cube) {
        BufferedImage ret = new BufferedImage(width, height, 2);
        Graphics2D g2d = ret.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int size = cube[0].length;
        if (RCMain.UNLOCKED) {
            int x = width / 2 - 50;
            int y = height / 2 - 50;
            g2d.drawImage((Image)RCMain.MANE6[cube[face][size / 2][size / 2]], x, y, null);
            g2d.dispose();
            return ret;
        }
        PsuedoVariables pv = CubeViewerPseudo3D.createFrontVariables(width, height, size);
        g2d.setStroke(new BasicStroke((int)pv.stroke));
        Path2D.Double[][][] faces = CubeViewerPseudo3D.createTopSideFrontFaces(pv);
        switch (face) {
            case 0: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[2][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[3][y][pv.cubeSize - 1 - x]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[0][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 1: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[4][pv.cubeSize - 1 - y][x]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[2][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[1][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 2: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[4][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[3][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[2][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 3: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[4][y][pv.cubeSize - 1 - x]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[5][x][y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[3][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 4: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[5][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[3][pv.cubeSize - 1 - y][x]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[4][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 5: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[4][x][y]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[1][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[5][x][y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
        }
        CubeViewerPseudo3D.paintTopSideFrontGrid(pv, g2d);
        g2d.dispose();
        return ret;
    }

    public static BufferedImage addFrontFace(BufferedImage img, int direction, int cubeSize) {
        PsuedoVariables pv = CubeViewerPseudo3D.createFrontVariables(img.getWidth(), img.getHeight(), cubeSize);
        BasicStroke s1 = new BasicStroke((int)pv.stroke);
        BasicStroke s2 = new BasicStroke((int)(pv.stroke * 2.0));
        BufferedImage ret = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        Graphics2D g2d = ret.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.drawImage((Image)img, 0, 0, null);
        double startX = -1.0;
        double startY = -1.0;
        double quadX = -1.0;
        double quadY = -1.0;
        double endX = -1.0;
        double endY = -1.0;
        switch (direction) {
            case 0: {
                startX = pv.baseX + pv.frontBaseX + pv.frontW * (double)cubeSize - pv.frontW / 2.0;
                startY = pv.baseY + pv.frontBaseY + pv.frontH / 2.0 + pv.frontH / 6.0;
                quadX = pv.baseX + pv.frontBaseX + pv.frontW / 2.0;
                quadY = pv.baseY + pv.frontBaseY + pv.frontH + pv.frontH / 2.0 - pv.frontH / 6.0;
                endX = pv.baseX + pv.frontBaseX + pv.frontW / 2.0;
                endY = pv.baseY + pv.frontBaseY + pv.frontH * (double)cubeSize + pv.frontH / 2.0 - pv.frontH / 6.0;
                break;
            }
            case 1: {
                startX = pv.baseX + pv.frontBaseX + pv.frontW / 2.0;
                startY = pv.baseY + pv.frontBaseY + pv.frontH + pv.frontH / 2.0 - pv.frontH / 6.0;
                quadX = pv.baseX + pv.frontBaseX + pv.frontW * (double)cubeSize - pv.frontW / 2.0;
                quadY = pv.baseY + pv.frontBaseY + pv.frontH / 2.0 + pv.frontH / 6.0;
                endX = pv.baseX + pv.frontBaseX + pv.frontW * (double)cubeSize - pv.frontW / 2.0;
                endY = pv.baseY + pv.frontBaseY + pv.frontH * (double)cubeSize - pv.frontH / 2.0 + pv.frontH / 6.0;
            }
        }
        Path2D.Double line = new Path2D.Double();
        Path2D.Double head = new Path2D.Double();
        line.moveTo(startX, startY);
        line.lineTo(quadX, quadY);
        line.lineTo(endX, endY);
        head.moveTo(endX, endY);
        head.lineTo(endX + pv.frontW / 4.0, endY - pv.frontH / 12.0);
        head.lineTo(endX, endY + pv.topH / 2.0);
        head.lineTo(endX - pv.frontW / 3.0, endY + pv.frontH / 8.0);
        head.closePath();
        g2d.setStroke(s2);
        g2d.setColor(Color.BLACK);
        g2d.draw(line);
        g2d.draw(head);
        g2d.setStroke(s1);
        g2d.setColor(Color.WHITE);
        g2d.draw(head);
        g2d.fill(head);
        g2d.draw(line);
        g2d.dispose();
        return ret;
    }

    public static BufferedImage addFrontRowUpsideDown(BufferedImage img, int face, int row, int direction, int cubeSize) {
        return CubeViewerPseudo3D.addFrontRow(img, face, cubeSize - 1 - row, direction == 0 ? 1 : 0, cubeSize);
    }

    public static BufferedImage addFrontRow(BufferedImage img, int face, int row, int direction, int cubeSize) {
        if (face == 5) {
            row = cubeSize - 1 - row;
            direction = direction == 0 ? 1 : 0;
        }
        PsuedoVariables pv = CubeViewerPseudo3D.createFrontVariables(img.getWidth(), img.getHeight(), cubeSize);
        BasicStroke s1 = new BasicStroke((int)pv.stroke);
        BasicStroke s2 = new BasicStroke((int)(pv.stroke * 2.0));
        BufferedImage ret = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        Graphics2D g2d = ret.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.drawImage((Image)img, 0, 0, null);
        double startX = -1.0;
        double startY = -1.0;
        double quadX = -1.0;
        double quadY = -1.0;
        double endX = -1.0;
        double endY = -1.0;
        Path2D.Double line = new Path2D.Double();
        Path2D.Double head = new Path2D.Double();
        switch (direction) {
            case 0: {
                startX = pv.baseX + pv.frontBaseX + pv.frontW * (double)cubeSize - pv.frontW / 2.0;
                startY = pv.baseY + pv.frontBaseY + pv.frontH / 2.0 + pv.frontH / 6.0 + pv.frontH * (double)row;
                quadX = pv.baseX + pv.frontBaseX;
                quadY = pv.baseY + pv.frontBaseY + pv.frontH + pv.frontH / 2.0 + pv.frontH * (double)row;
                endX = pv.baseX + pv.sideBaseX + pv.sideW / 2.0;
                endY = pv.baseY + pv.sideBaseY + pv.sideH / 2.0 + pv.sideH / 6.0 + pv.sideH * (double)row;
                head.moveTo(endX, endY);
                head.lineTo(endX, endY - pv.sideH / 4.0);
                head.lineTo(endX - pv.sideW / 2.0, endY - pv.sideH / 6.0);
                head.lineTo(endX, endY + pv.sideH / 4.0);
                break;
            }
            case 1: {
                startX = pv.baseX + pv.sideBaseX + pv.sideW / 2.0;
                startY = pv.baseY + pv.sideBaseY + pv.sideH / 2.0 + pv.sideH / 6.0 + pv.sideH * (double)row;
                quadX = pv.baseX + pv.frontBaseX;
                quadY = pv.baseY + pv.frontBaseY + pv.frontH + pv.frontH / 2.0 + pv.frontH * (double)row;
                endX = pv.baseX + pv.frontBaseX + pv.frontW * (double)cubeSize - pv.frontW / 2.0;
                endY = pv.baseY + pv.frontBaseY + pv.frontH / 2.0 + pv.frontH / 6.0 + pv.frontH * (double)row;
                head.moveTo(endX, endY);
                head.lineTo(endX, endY - pv.frontH / 4.0);
                head.lineTo(endX + pv.frontW / 2.0, endY - pv.frontH / 6.0);
                head.lineTo(endX, endY + pv.frontH / 4.0);
            }
        }
        head.closePath();
        line.moveTo(startX, startY);
        line.lineTo(quadX, quadY);
        line.lineTo(endX, endY);
        g2d.setStroke(s2);
        g2d.setColor(Color.BLACK);
        g2d.draw(line);
        g2d.draw(head);
        g2d.setStroke(s1);
        g2d.setColor(Color.WHITE);
        g2d.draw(head);
        g2d.fill(head);
        g2d.draw(line);
        g2d.dispose();
        return ret;
    }

    public static BufferedImage addFrontColumnUpsideDown(BufferedImage img, int face, int column, int direction, int cubeSize) {
        return CubeViewerPseudo3D.addFrontColumn(img, face, cubeSize - 1 - column, direction == 2 ? 3 : 2, cubeSize);
    }

    public static BufferedImage addFrontColumn(BufferedImage img, int face, int column, int direction, int cubeSize) {
        if (face == 5) {
            column = cubeSize - 1 - column;
            direction = direction == 2 ? 3 : 2;
        }
        PsuedoVariables pv = CubeViewerPseudo3D.createFrontVariables(img.getWidth(), img.getHeight(), cubeSize);
        BasicStroke s1 = new BasicStroke((int)pv.stroke);
        BasicStroke s2 = new BasicStroke((int)(pv.stroke * 2.0));
        BufferedImage ret = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        Graphics2D g2d = ret.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.drawImage((Image)img, 0, 0, null);
        double startX = -1.0;
        double startY = -1.0;
        double quadX = -1.0;
        double quadY = -1.0;
        double endX = -1.0;
        double endY = -1.0;
        Path2D.Double line = new Path2D.Double();
        Path2D.Double head = new Path2D.Double();
        switch (direction) {
            case 2: {
                startX = pv.baseX + pv.frontBaseX + pv.frontW / 2.0 + pv.frontW * (double)column;
                startY = pv.baseY + pv.frontBaseY + pv.frontH * (double)cubeSize + pv.frontH / 2.0 - pv.frontH / 6.0 - pv.frontH / 3.0 * (double)column;
                quadX = pv.baseX + pv.frontBaseX + pv.frontW / 2.0 + pv.frontW * (double)column;
                quadY = pv.baseY + pv.frontBaseY + pv.frontH - pv.frontH / 6.0 - pv.frontH / 3.0 * (double)column;
                endX = pv.baseX + pv.topBaseX + pv.topW + pv.topW * (double)column;
                endY = pv.baseY + pv.topBaseY - pv.topH / 3.0 * (double)column;
                head.moveTo(endX, endY);
                head.lineTo(endX + pv.topW / 4.0, endY - pv.topH / 12.0);
                head.lineTo(endX - pv.topW / 2.0, endY - pv.topH / 6.0);
                head.lineTo(endX - pv.topW / 3.0, endY + pv.topH / 8.0);
                break;
            }
            case 3: {
                startX = pv.baseX + pv.topBaseX + pv.topW + pv.topW * (double)column;
                startY = pv.baseY + pv.topBaseY - pv.topH / 3.0 * (double)column;
                quadX = pv.baseX + pv.frontBaseX + pv.frontW / 2.0 + pv.frontW * (double)column;
                quadY = pv.baseY + pv.frontBaseY + pv.frontH - pv.frontH / 6.0 - pv.frontH / 3.0 * (double)column;
                endX = pv.baseX + pv.frontBaseX + pv.frontW / 2.0 + pv.frontW * (double)column;
                endY = pv.baseY + pv.frontBaseY + pv.frontH * (double)cubeSize + pv.frontH / 2.0 - pv.frontH / 6.0 - pv.frontH / 3.0 * (double)column;
                head.moveTo(endX, endY);
                head.lineTo(endX + pv.frontW / 4.0, endY - pv.frontH / 12.0);
                head.lineTo(endX, endY + pv.topH / 2.0);
                head.lineTo(endX - pv.frontW / 3.0, endY + pv.frontH / 8.0);
            }
        }
        head.closePath();
        line.moveTo(startX, startY);
        line.lineTo(quadX, quadY);
        line.lineTo(endX, endY);
        g2d.setStroke(s2);
        g2d.setColor(Color.BLACK);
        g2d.draw(line);
        g2d.draw(head);
        g2d.setStroke(s1);
        g2d.setColor(Color.WHITE);
        g2d.draw(head);
        g2d.fill(head);
        g2d.draw(line);
        g2d.dispose();
        return ret;
    }

    public static BufferedImage createFaceOnSideNoAddon(int width, int height, Map<String, Integer> details, Integer[][][] cube) {
        int face = details.get("face");
        return CubeViewerPseudo3D.createFaceOnSide(width, height, face, cube);
    }

    public static BufferedImage createFaceOnSide(int width, int height, Map<String, Integer> details, Integer[][][] cube) {
        int face = details.get("face");
        int direction = details.get("direction");
        int cubeSize = cube[0].length;
        BufferedImage img = CubeViewerPseudo3D.createFaceOnSide(width, height, face, cube);
        switch (details.get("method")) {
            case 10: {
                img = CubeViewerPseudo3D.addSideFace(img, direction, cubeSize);
                break;
            }
            case 11: {
                img = CubeViewerPseudo3D.addSideRow(img, face, details.get("rowcolumn"), direction, cubeSize);
                break;
            }
            case 12: {
                img = CubeViewerPseudo3D.addSideColumn(img, face, details.get("rowcolumn"), direction, cubeSize);
            }
        }
        return img;
    }

    public static BufferedImage createFaceOnSide(int width, int height, int face, Integer[][][] cube) {
        BufferedImage ret = new BufferedImage(width, height, 2);
        Graphics2D g2d = ret.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int size = cube[0].length;
        if (RCMain.UNLOCKED) {
            int x = width / 2 - 50;
            int y = height / 2 - 50;
            g2d.drawImage((Image)RCMain.MANE6[cube[face][size / 2][size / 2]], x, y, null);
            g2d.dispose();
            return ret;
        }
        PsuedoVariables pv = CubeViewerPseudo3D.createFrontVariables(width, height, size);
        g2d.setStroke(new BasicStroke((int)pv.stroke));
        Path2D.Double[][][] faces = CubeViewerPseudo3D.createTopSideFrontFaces(pv);
        switch (face) {
            case 0: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[5][y][pv.cubeSize - 1 - x]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[0][x][y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[3][pv.cubeSize - 1 - y][x]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 1: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[0][x][y]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[1][x][y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[2][x][y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 2: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[0][y][pv.cubeSize - 1 - x]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[2][x][y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[3][x][y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 3: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[0][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[3][x][y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[5][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 4: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[2][y][pv.cubeSize - 1 - x]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[4][x][y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[3][y][pv.cubeSize - 1 - x]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 5: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[0][pv.cubeSize - 1 - y][x]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[5][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[1][x][y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
        }
        CubeViewerPseudo3D.paintTopSideFrontGrid(pv, g2d);
        g2d.dispose();
        return ret;
    }

    public static BufferedImage createFaceOnSideUpsideDownNoAddon(int width, int height, Map<String, Integer> details, Integer[][][] cube) {
        int face = details.get("face");
        return CubeViewerPseudo3D.createFaceOnSideUpsideDown(width, height, face, cube);
    }

    public static BufferedImage createFaceOnSideUpsideDown(int width, int height, Map<String, Integer> details, Integer[][][] cube) {
        int face = details.get("face");
        int direction = details.get("direction");
        int cubeSize = cube[0].length;
        BufferedImage img = CubeViewerPseudo3D.createFaceOnSideUpsideDown(width, height, face, cube);
        switch (details.get("method")) {
            case 10: {
                img = CubeViewerPseudo3D.addSideFace(img, direction, cubeSize);
                break;
            }
            case 11: {
                img = CubeViewerPseudo3D.addSideRowUpsideDown(img, face, details.get("rowcolumn"), direction, cubeSize);
                break;
            }
            case 12: {
                img = CubeViewerPseudo3D.addSideColumnUpsideDown(img, face, details.get("rowcolumn"), direction, cubeSize);
            }
        }
        return img;
    }

    public static BufferedImage createFaceOnSideUpsideDown(int width, int height, int face, Integer[][][] cube) {
        BufferedImage ret = new BufferedImage(width, height, 2);
        Graphics2D g2d = ret.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int size = cube[0].length;
        if (RCMain.UNLOCKED) {
            int x = width / 2 - 50;
            int y = height / 2 - 50;
            g2d.drawImage((Image)RCMain.MANE6[cube[face][size / 2][size / 2]], x, y, null);
            g2d.dispose();
            return ret;
        }
        PsuedoVariables pv = CubeViewerPseudo3D.createFrontVariables(width, height, cube[0].length);
        g2d.setStroke(new BasicStroke((int)pv.stroke));
        Path2D.Double[][][] faces = CubeViewerPseudo3D.createTopSideFrontFaces(pv);
        switch (face) {
            case 0: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[2][pv.cubeSize - 1 - y][x]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[0][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[1][pv.cubeSize - 1 - y][x]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 1: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[4][x][y]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[1][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[5][x][y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 2: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[4][pv.cubeSize - 1 - y][x]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[2][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[1][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 3: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[4][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[3][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[2][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 4: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[5][pv.cubeSize - 1 - y][x]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[4][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[1][y][pv.cubeSize - 1 - x]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
            case 5: {
                for (int x = 0; x < pv.cubeSize; ++x) {
                    for (int y = 0; y < pv.cubeSize; ++y) {
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[4][y][pv.cubeSize - 1 - x]]);
                        g2d.fill(faces[0][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[5][x][y]]);
                        g2d.fill(faces[1][x][y]);
                        g2d.setColor(RubiksCube.FACE_COLORS[cube[3][pv.cubeSize - 1 - x][pv.cubeSize - 1 - y]]);
                        g2d.fill(faces[2][x][y]);
                    }
                }
                break;
            }
        }
        CubeViewerPseudo3D.paintTopSideFrontGrid(pv, g2d);
        g2d.dispose();
        return ret;
    }

    public static BufferedImage addSideFace(BufferedImage img, int direction, int cubeSize) {
        PsuedoVariables pv = CubeViewerPseudo3D.createFrontVariables(img.getWidth(), img.getHeight(), cubeSize);
        BasicStroke s1 = new BasicStroke((int)pv.stroke);
        BasicStroke s2 = new BasicStroke((int)(pv.stroke * 2.0));
        BufferedImage ret = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        Graphics2D g2d = ret.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.drawImage((Image)img, 0, 0, null);
        double startX = -1.0;
        double startY = -1.0;
        double quadX = -1.0;
        double quadY = -1.0;
        double endX = -1.0;
        double endY = -1.0;
        switch (direction) {
            case 0: {
                startX = pv.baseX + pv.sideBaseX + pv.sideW * (double)cubeSize - pv.sideW / 2.0;
                startY = pv.baseY + pv.sideBaseY + pv.sideH + pv.sideH / 2.0 - pv.sideH / 6.0;
                quadX = pv.baseX + pv.sideBaseX + pv.sideW / 2.0;
                quadY = pv.baseY + pv.sideBaseY + pv.sideH / 2.0 + pv.sideH / 6.0;
                endX = pv.baseX + pv.sideBaseX + pv.sideW / 2.0;
                endY = pv.baseY + pv.sideBaseY + pv.sideH * (double)cubeSize - pv.sideH / 2.0 + pv.sideH / 6.0;
                break;
            }
            case 1: {
                startX = pv.baseX + pv.sideBaseX + pv.sideW / 2.0;
                startY = pv.baseY + pv.sideBaseY + pv.sideH / 2.0 + pv.sideH / 6.0;
                quadX = pv.baseX + pv.sideBaseX + pv.sideW * (double)cubeSize - pv.sideW / 2.0;
                quadY = pv.baseY + pv.sideBaseY + pv.sideH + pv.sideH / 2.0 - pv.sideH / 6.0;
                endX = pv.baseX + pv.sideBaseX + pv.sideW * (double)cubeSize - pv.sideW / 2.0;
                endY = pv.baseY + pv.sideBaseY + pv.sideH * (double)cubeSize + pv.sideH / 2.0 - pv.sideH / 6.0;
            }
        }
        Path2D.Double line = new Path2D.Double();
        Path2D.Double head = new Path2D.Double();
        line.moveTo(startX, startY);
        line.lineTo(quadX, quadY);
        line.lineTo(endX, endY);
        head.moveTo(endX, endY);
        head.lineTo(endX + pv.frontW / 3.0, endY + pv.frontH / 8.0);
        head.lineTo(endX, endY + pv.topH / 2.0);
        head.lineTo(endX - pv.frontW / 4.0, endY - pv.frontH / 12.0);
        head.closePath();
        g2d.setStroke(s2);
        g2d.setColor(Color.BLACK);
        g2d.draw(line);
        g2d.draw(head);
        g2d.setStroke(s1);
        g2d.setColor(Color.WHITE);
        g2d.draw(head);
        g2d.fill(head);
        g2d.draw(line);
        g2d.dispose();
        return ret;
    }

    public static BufferedImage addSideRowUpsideDown(BufferedImage img, int face, int row, int direction, int cubeSize) {
        return CubeViewerPseudo3D.addSideRow(img, face, cubeSize - 1 - row, direction == 0 ? 1 : 0, cubeSize);
    }

    public static BufferedImage addSideRow(BufferedImage img, int face, int row, int direction, int cubeSize) {
        return CubeViewerPseudo3D.addFrontRow(img, face, row, direction, cubeSize);
    }

    public static BufferedImage addSideColumnUpsideDown(BufferedImage img, int face, int column, int direction, int cubeSize) {
        return CubeViewerPseudo3D.addSideColumn(img, face, cubeSize - 1 - column, direction == 2 ? 3 : 2, cubeSize);
    }

    public static BufferedImage addSideColumn(BufferedImage img, int face, int column, int direction, int cubeSize) {
        if (face == 5) {
            column = cubeSize - 1 - column;
            direction = direction == 2 ? 3 : 2;
        }
        PsuedoVariables pv = CubeViewerPseudo3D.createFrontVariables(img.getWidth(), img.getHeight(), cubeSize);
        BasicStroke s1 = new BasicStroke((int)pv.stroke);
        BasicStroke s2 = new BasicStroke((int)(pv.stroke * 2.0));
        BufferedImage ret = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        Graphics2D g2d = ret.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.drawImage((Image)img, 0, 0, null);
        double startX = -1.0;
        double startY = -1.0;
        double quadX = -1.0;
        double quadY = -1.0;
        double endX = -1.0;
        double endY = -1.0;
        Path2D.Double line = new Path2D.Double();
        Path2D.Double head = new Path2D.Double();
        switch (direction) {
            case 2: {
                startX = pv.baseX + pv.sideBaseX + pv.sideW / 2.0 + pv.sideW * (double)column;
                startY = pv.baseY + pv.sideBaseY + pv.sideH * (double)cubeSize - pv.sideH / 2.0 + pv.sideH / 6.0 + pv.sideH / 3.0 * (double)column;
                quadX = pv.baseX + pv.sideBaseX + pv.sideW / 2.0 + pv.sideW * (double)column;
                quadY = pv.baseY + pv.sideBaseY + pv.sideH / 6.0 + pv.sideH / 3.0 * (double)column;
                endX = pv.baseX + pv.topBaseX + pv.topW * (double)cubeSize + pv.topW * (double)column;
                endY = pv.baseY + pv.topBaseY - pv.topH / 3.0 * (double)(cubeSize - 1 - column);
                head.moveTo(endX, endY);
                head.lineTo(endX - pv.topW / 4.0, endY - pv.topH / 12.0);
                head.lineTo(endX + pv.topW / 2.0, endY - pv.topH / 6.0);
                head.lineTo(endX + pv.topW / 3.0, endY + pv.topH / 8.0);
                break;
            }
            case 3: {
                startX = pv.baseX + pv.topBaseX + pv.topW * (double)cubeSize + pv.topW * (double)column;
                startY = pv.baseY + pv.topBaseY - pv.topH / 3.0 * (double)(cubeSize - 1 - column);
                quadX = pv.baseX + pv.sideBaseX + pv.sideW / 2.0 + pv.sideW * (double)column;
                quadY = pv.baseY + pv.sideBaseY + pv.sideH / 6.0 + pv.sideH / 3.0 * (double)column;
                endX = pv.baseX + pv.sideBaseX + pv.sideW / 2.0 + pv.sideW * (double)column;
                endY = pv.baseY + pv.sideBaseY + pv.sideH * (double)cubeSize - pv.sideH / 2.0 + pv.sideH / 6.0 + pv.sideH / 3.0 * (double)column;
                head.moveTo(endX, endY);
                head.lineTo(endX + pv.sideW / 3.0, endY + pv.sideH / 8.0);
                head.lineTo(endX, endY + pv.topH / 2.0);
                head.lineTo(endX - pv.sideW / 4.0, endY - pv.sideH / 12.0);
            }
        }
        head.closePath();
        line.moveTo(startX, startY);
        line.lineTo(quadX, quadY);
        line.lineTo(endX, endY);
        g2d.setStroke(s2);
        g2d.setColor(Color.BLACK);
        g2d.draw(line);
        g2d.draw(head);
        g2d.setStroke(s1);
        g2d.setColor(Color.WHITE);
        g2d.draw(head);
        g2d.fill(head);
        g2d.draw(line);
        g2d.dispose();
        return ret;
    }

    private static class PsuedoVariables {
        public int cubeSize;
        public double w;
        public double h;
        public double offset;
        public double baseX;
        public double baseY;
        public double stroke;
        public double topBaseX;
        public double topBaseY;
        public double topW;
        public double topH;
        public double sideBaseX;
        public double sideBaseY;
        public double sideW;
        public double sideH;
        public double frontBaseX;
        public double frontBaseY;
        public double frontW;
        public double frontH;

        private PsuedoVariables() {
        }
    }
}

