/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.gui.graphics2d;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import rubikscube.gui.graphics2d.PaintListener;

public class DrawPanel
extends JPanel {
    private List<PaintListener> pls = new ArrayList<PaintListener>();

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (int i = 0; i < this.pls.size(); ++i) {
            this.pls.get(i).onPaint(this, g);
        }
    }

    public void addPaintListener(PaintListener pl) {
        if (pl != null) {
            this.pls.add(pl);
        }
    }

    public void removePaintListener(PaintListener pl) {
        this.pls.remove(pl);
    }

    public void removePaintListener(int pl) {
        this.pls.remove(pl);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension min = new Dimension(0, 0);
        for (int i = 0; i < this.pls.size(); ++i) {
            Dimension dim = this.pls.get(i).getMinimumSize();
            if (dim == null) continue;
            if (dim.width > min.width) {
                min.width = dim.width;
            }
            if (dim.height <= min.height) continue;
            min.height = dim.height;
        }
        if (min.equals(new Dimension(0, 0))) {
            return super.getMinimumSize();
        }
        return min;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = new Dimension(0, 0);
        for (int i = 0; i < this.pls.size(); ++i) {
            Dimension dim = this.pls.get(i).getPreferredSize();
            if (dim == null) continue;
            if (dim.width > pref.width) {
                pref.width = dim.width;
            }
            if (dim.height <= pref.height) continue;
            pref.height = dim.height;
        }
        if (pref.equals(new Dimension(0, 0))) {
            return super.getPreferredSize();
        }
        return pref;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension max = new Dimension(0, 0);
        for (int i = 0; i < this.pls.size(); ++i) {
            Dimension dim = this.pls.get(i).getMaximumSize();
            if (dim == null) continue;
            if (dim.width > max.width) {
                max.width = dim.width;
            }
            if (dim.height <= max.height) continue;
            max.height = dim.height;
        }
        if (max.equals(new Dimension(0, 0))) {
            return super.getMaximumSize();
        }
        return max;
    }
}

