/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.gui.graphics3d;

import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.universe.Viewer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import javax.media.j3d.Behavior;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import rubikscube.gui.graphics3d.Cubie3D;
import rubikscube.gui.graphics3d.RubiksCube3D;

public class Cube3DRotate
extends Behavior {
    private WakeupCondition condition;
    private WakeupCriterion[] mouseEvents;
    private RubiksCube3D cube;
    private Transform3D xTrans = new Transform3D();
    private Transform3D yTrans = new Transform3D();
    private boolean mouse = false;
    private Point oldMouseLoc;
    private Cubie3D oldClosest;
    private Cubie3D.Face3D oldClosestFace;
    private UUID oldUUID;
    private PickCanvas pickCanvas;
    private boolean otherKey = false;
    private boolean spaceKey = false;
    private boolean rotateCube = false;
    private List<UUID> blocks = new ArrayList<UUID>();
    private List<UUID> rotationBlocks = new ArrayList<UUID>();

    public Cube3DRotate(Viewer viewer, RubiksCube3D cube) {
        if (viewer == null || cube == null) {
            throw new NullPointerException("all arguments must be non-null");
        }
        this.mouseEvents = new WakeupCriterion[]{new WakeupOnAWTEvent(501), new WakeupOnAWTEvent(502), new WakeupOnAWTEvent(506), new WakeupOnAWTEvent(503), new WakeupOnAWTEvent(401), new WakeupOnAWTEvent(402)};
        this.condition = new WakeupOr(this.mouseEvents);
        this.cube = cube;
        this.pickCanvas = new PickCanvas(viewer.getCanvas3D(), cube.getBranchGroup());
        this.pickCanvas.setMode(1024);
        this.pickCanvas.setShape((PickShape)new PickRay(), null);
        this.pickCanvas.setTolerance(0.0f);
        Cube3DRotate.enablePicking((Node)cube);
    }

    public void initialize() {
        this.wakeupOn(this.condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID block() {
        List<UUID> list = this.blocks;
        synchronized (list) {
            UUID id = UUID.randomUUID();
            this.blocks.add(id);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock(UUID id) {
        List<UUID> list = this.blocks;
        synchronized (list) {
            if (this.blocks.contains(id)) {
                this.blocks.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID blockRotation() {
        List<UUID> list = this.rotationBlocks;
        synchronized (list) {
            UUID id = UUID.randomUUID();
            this.rotationBlocks.add(id);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblockRotation(UUID id) {
        List<UUID> list = this.rotationBlocks;
        synchronized (list) {
            if (this.rotationBlocks.contains(id)) {
                this.rotationBlocks.remove(id);
            }
        }
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCondition cond = (WakeupCondition)criteria.nextElement();
            if (!(cond instanceof WakeupOnAWTEvent)) {
                System.err.println("cond not instanceof WakeupOnAWTEvent");
                continue;
            }
            AWTEvent[] events = ((WakeupOnAWTEvent)cond).getAWTEvent();
            if (!(events[events.length - 1] instanceof MouseEvent) && !(events[events.length - 1] instanceof KeyEvent)) {
                System.err.println("event not instanceof MouseEvent nor KeyEvent");
                continue;
            }
            AWTEvent event = events[events.length - 1];
            if (event instanceof MouseEvent) {
                this.doProcess((MouseEvent)event);
                continue;
            }
            this.doProcess((KeyEvent)event);
        }
        this.wakeupOn(this.condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(MouseEvent e) {
        boolean mouseBlock;
        boolean rotBlock;
        int button = e.getButton();
        int eventID = e.getID();
        Point mouseLoc = e.getPoint();
        this.pickCanvas.setShapeLocation(e);
        PickResult[] results = this.pickCanvas.pickAllSorted();
        Cubie3D.Face3D closestFace = null;
        Cubie3D closest = null;
        int[] face = null;
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                Node result;
                for (result = results[i].getObject(); result != null && !(result instanceof Cubie3D.Face3D) && !(result instanceof Cubie3D.Edges3D); result = result.getParent()) {
                }
                if (result == null) continue;
                if (result instanceof Cubie3D.Face3D) {
                    closestFace = (Cubie3D.Face3D)result;
                    face = this.cube.getFaceletPos(closestFace);
                }
                closest = (Cubie3D)result.getParent();
                break;
            }
        }
        if (eventID == 501 || eventID == 502) {
            this.mouse = eventID == 501;
            this.rotateCube = closest != null;
        }
        List<UUID> list = this.rotationBlocks;
        synchronized (list) {
            rotBlock = !this.rotationBlocks.isEmpty();
        }
        list = this.blocks;
        synchronized (list) {
            mouseBlock = !this.blocks.isEmpty();
        }
        if (eventID == 506) {
            if (!rotBlock && this.rotateCube) {
                int[] oldFace;
                if (!this.cube.getCube().isRotating() && !this.cube.getCube().isGodMode() && this.oldClosestFace != null && closestFace != null && this.oldClosestFace != closestFace && face != null && (oldFace = this.cube.getFaceletPos(this.oldClosestFace)) != null) {
                    if (oldFace[0] == face[0]) {
                        if (oldFace[1] == face[1]) {
                            this.cube.getCube().rotateColumn(face[0], face[1], oldFace[2] < face[2] ? 3 : 2);
                        } else if (oldFace[2] == face[2]) {
                            this.cube.getCube().rotateRow(face[0], face[2], oldFace[1] < face[1] ? 1 : 0);
                        }
                    } else {
                        this.calculateRotate(face, oldFace);
                    }
                    closestFace = null;
                }
            } else if (!mouseBlock && this.oldMouseLoc != null) {
                this.xTrans.rotY((double)(mouseLoc.x - this.oldMouseLoc.x) * this.cube.getXFactor());
                this.yTrans.rotX((double)(mouseLoc.y - this.oldMouseLoc.y) * this.cube.getYFactor());
                Transform3D currTrans = new Transform3D();
                this.cube.getTransform(currTrans);
                currTrans.mul(this.xTrans, currTrans);
                currTrans.mul(this.yTrans, currTrans);
                this.cube.setTransform(currTrans);
            }
        }
        if (!rotBlock && !mouseBlock) {
            if (closest != null) {
                if (this.oldClosest == null || closest != this.oldClosest) {
                    if (this.oldUUID != null) {
                        this.cube.removeHighlight(this.oldUUID);
                    }
                    this.oldUUID = this.cube.highlightCubie(closest, this.mouse && this.rotateCube ? Color.YELLOW : Color.RED, 0, false);
                } else if (this.mouse && this.rotateCube) {
                    this.cube.replaceHighlight(this.oldUUID, Color.YELLOW);
                    if (eventID == 501 && this.cube.getCube().isGodMode() && face != null) {
                        this.cube.getCube().scrollFacelet(face, button == 1);
                    }
                } else {
                    this.cube.replaceHighlight(this.oldUUID, Color.RED);
                }
                if (face != null) {
                    this.oldClosestFace = closestFace;
                }
            } else {
                if (this.oldClosest != null) {
                    this.cube.removeHighlight(this.oldUUID);
                }
                this.oldUUID = null;
                if (eventID != 506) {
                    this.oldClosestFace = null;
                }
            }
        } else if (this.oldUUID != null) {
            this.cube.removeHighlight(this.oldUUID);
            this.oldUUID = null;
        }
        this.oldClosest = closest;
        this.oldMouseLoc = mouseLoc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calculateRotate(int[] face, int[] oldFace) {
        block48: {
            int size = this.cube.getCube().getSize() - 1;
            switch (oldFace[0]) {
                case 0: {
                    switch (face[0]) {
                        case 1: {
                            if (oldFace[2] != face[1]) break;
                            this.cube.getCube().rotateRow(0, oldFace[2], 0);
                            return;
                        }
                        case 2: {
                            if (oldFace[1] != face[1]) break;
                            this.cube.getCube().rotateColumn(0, oldFace[1], 3);
                            return;
                        }
                        case 3: {
                            if (size - oldFace[2] != face[1]) break;
                            this.cube.getCube().rotateRow(0, oldFace[2], 1);
                            return;
                        }
                        case 5: {
                            if (oldFace[1] != face[1]) break;
                            this.cube.getCube().rotateColumn(0, oldFace[1], 2);
                        }
                    }
                    return;
                }
                case 1: {
                    switch (face[0]) {
                        case 5: {
                            if (oldFace[2] != size - face[2]) break;
                            this.cube.getCube().rotateRow(1, oldFace[2], 0);
                            return;
                        }
                        case 4: {
                            if (oldFace[1] != size - face[2]) break;
                            this.cube.getCube().rotateColumn(1, oldFace[1], 3);
                            return;
                        }
                        case 2: {
                            if (oldFace[2] != face[2]) break;
                            this.cube.getCube().rotateRow(1, oldFace[2], 1);
                            return;
                        }
                        case 0: {
                            if (oldFace[1] != face[2]) break;
                            this.cube.getCube().rotateColumn(1, oldFace[1], 2);
                        }
                    }
                    return;
                }
                case 2: {
                    switch (face[0]) {
                        case 1: {
                            if (oldFace[2] != face[2]) break;
                            this.cube.getCube().rotateRow(2, oldFace[2], 0);
                            return;
                        }
                        case 4: {
                            if (oldFace[1] != face[1]) break;
                            this.cube.getCube().rotateColumn(2, oldFace[1], 3);
                            return;
                        }
                        case 3: {
                            if (oldFace[2] != face[2]) break;
                            this.cube.getCube().rotateRow(2, oldFace[2], 1);
                            return;
                        }
                        case 0: {
                            if (oldFace[1] != face[1]) break;
                            this.cube.getCube().rotateColumn(2, oldFace[1], 2);
                        }
                    }
                    return;
                }
                case 3: {
                    switch (face[0]) {
                        case 2: {
                            if (oldFace[2] != face[2]) break;
                            this.cube.getCube().rotateRow(3, oldFace[2], 0);
                            return;
                        }
                        case 4: {
                            if (oldFace[1] != face[2]) break;
                            this.cube.getCube().rotateColumn(3, oldFace[1], 3);
                            return;
                        }
                        case 5: {
                            if (oldFace[2] != size - face[2]) break;
                            this.cube.getCube().rotateRow(3, oldFace[2], 1);
                            return;
                        }
                        case 0: {
                            if (oldFace[1] != size - face[2]) break;
                            this.cube.getCube().rotateColumn(3, oldFace[1], 2);
                        }
                    }
                    return;
                }
                case 4: {
                    switch (face[0]) {
                        case 1: {
                            if (oldFace[2] != size - face[1]) break;
                            this.cube.getCube().rotateRow(4, oldFace[2], 0);
                            return;
                        }
                        case 5: {
                            if (oldFace[1] != face[1]) break;
                            this.cube.getCube().rotateColumn(4, oldFace[1], 3);
                            return;
                        }
                        case 3: {
                            if (oldFace[2] != face[1]) break;
                            this.cube.getCube().rotateRow(4, oldFace[2], 1);
                            return;
                        }
                        case 2: {
                            if (oldFace[1] != face[1]) break;
                            this.cube.getCube().rotateColumn(4, oldFace[1], 2);
                        }
                    }
                    return;
                }
                case 5: {
                    switch (face[0]) {
                        case 1: {
                            if (oldFace[2] != size - face[2]) return;
                            this.cube.getCube().rotateRow(5, oldFace[2], 0);
                            break block48;
                        }
                        case 0: {
                            if (oldFace[1] != face[1]) return;
                            this.cube.getCube().rotateColumn(5, oldFace[1], 3);
                            break block48;
                        }
                        case 3: {
                            if (oldFace[2] != size - face[2]) return;
                            this.cube.getCube().rotateRow(5, oldFace[2], 1);
                            break block48;
                        }
                        case 4: {
                            if (oldFace[1] != face[1]) return;
                            this.cube.getCube().rotateColumn(5, oldFace[1], 2);
                        }
                    }
                }
            }
        }
    }

    private void doProcess(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int eventID = e.getID();
        if (keyCode == 32) {
            boolean newSpaceKey;
            boolean bl = newSpaceKey = eventID == 401 && !this.otherKey;
            if (newSpaceKey != this.spaceKey) {
                this.spaceKey = newSpaceKey;
                this.mouse = false;
                this.oldMouseLoc = null;
            }
        } else {
            this.otherKey = eventID == 401;
            boolean bl = this.spaceKey = this.spaceKey && !this.otherKey;
        }
        if (this.spaceKey && this.oldClosest != null) {
            this.cube.removeHighlight(this.oldUUID);
            this.oldClosest = null;
            this.oldUUID = null;
        }
    }

    private static void enablePicking(Node node) {
        block3: {
            block2: {
                node.setPickable(true);
                node.setCapability(1);
                if (!(node instanceof Group)) break block2;
                Group group = (Group)node;
                Enumeration e = group.getAllChildren();
                while (e.hasMoreElements()) {
                    Cube3DRotate.enablePicking((Node)e.nextElement());
                }
                break block3;
            }
            if (!(node instanceof Shape3D)) break block3;
            Shape3D shape = (Shape3D)node;
            PickTool.setCapabilities((Node)node, (int)4100);
            Enumeration e = shape.getAllGeometries();
            while (e.hasMoreElements()) {
                ((Geometry)e.nextElement()).setCapability(18);
            }
        }
    }
}

