/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.gui.graphics3d;

import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3f;
import rubikscube.game.RubiksCube;
import rubikscube.gui.graphics3d.Cube3DRotate;
import rubikscube.gui.graphics3d.RubiksCube3D;
import rubikscube.gui.utils.Tools3D;

public class CubeViewer3D
extends JPanel {
    private RubiksCube cube;
    private float cubieScale;
    private Transform3D xTrans = new Transform3D();
    private Transform3D yTrans = new Transform3D();
    private Transform3D zTrans = new Transform3D();
    private double rotAngle = 0.0;
    private boolean autoRotate = false;
    private Canvas3D canvas;
    private SimpleUniverse universe;
    private BranchGroup rootGroup;
    private BoundingSphere universeBounds;
    private Background background;
    private TransformGroup lightGroup;
    private AmbientLight ambientLight;
    private DirectionalLight dirLight1;
    private DirectionalLight dirLight2;
    private Cube3DRotate mouseBehavior;
    private RubiksCube3D cube3D;
    private final List<Quat4d> smoothList = new ArrayList<Quat4d>();
    private Thread smoothRotater;

    public CubeViewer3D(RubiksCube cube) {
        if (cube == null) {
            throw new NullPointerException("cube == null");
        }
        this.cube = cube;
        this.cubieScale = 0.9f / (float)cube.getSize();
        this.setLayout(new BorderLayout());
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        template.setSceneAntialiasing(2);
        GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template);
        this.canvas = new Canvas3D(config);
        this.canvas.setDoubleBufferEnable(true);
        this.universe = new SimpleUniverse(this.canvas);
        this.universe.getViewer().getView().setSceneAntialiasingEnable(true);
        this.rootGroup = new BranchGroup();
        this.universeBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), (double)(this.cubieScale * (float)cube.getSize()));
        this.background = new Background();
        this.background.setColor(Tools3D.getColor3f(new Color(225, 225, 225)));
        this.background.setApplicationBounds((Bounds)this.universeBounds);
        this.rootGroup.addChild((Node)this.background);
        this.lightGroup = new TransformGroup();
        this.ambientLight = new AmbientLight(Tools3D.getColor3f(Color.WHITE));
        this.ambientLight.setInfluencingBounds((Bounds)this.universeBounds);
        this.lightGroup.addChild((Node)this.ambientLight);
        this.dirLight1 = new DirectionalLight();
        Vector3f dir = new Vector3f(-0.5f, 0.1f, -1.0f);
        dir.normalize();
        this.dirLight1.setDirection(dir);
        this.dirLight1.setColor(Tools3D.getColor3f(Color.DARK_GRAY));
        this.dirLight1.setInfluencingBounds((Bounds)this.universeBounds);
        this.lightGroup.addChild((Node)this.dirLight1);
        this.dirLight2 = new DirectionalLight();
        dir = new Vector3f(0.2f, -5.0f, -1.0f);
        dir.normalize();
        this.dirLight2.setDirection(dir);
        this.dirLight2.setColor(Tools3D.getColor3f(Color.DARK_GRAY));
        this.dirLight2.setInfluencingBounds((Bounds)this.universeBounds);
        this.lightGroup.addChild((Node)this.dirLight2);
        this.rootGroup.addChild((Node)this.lightGroup);
        this.cube3D = new RubiksCube3D(this.cubieScale, cube);
        this.mouseBehavior = new Cube3DRotate(this.universe.getViewer(), this.cube3D);
        this.mouseBehavior.setSchedulingBounds((Bounds)this.universeBounds);
        this.cube3D.addChild((Node)this.mouseBehavior);
        this.rootGroup.addChild((Node)this.cube3D);
        this.rootGroup.compile();
        this.universe.addBranchGraph(this.rootGroup);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.add((Component)this.canvas, "Center");
        this.smoothRotater = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Quat4d targetQuat = null;
                while (true) {
                    boolean isEmpty;
                    List currTrans;
                    if (CubeViewer3D.this.autoRotate) {
                        CubeViewer3D.this.xTrans.rotX(Math.pow(Math.cos(CubeViewer3D.this.rotAngle), 2.0) * CubeViewer3D.this.cube3D.getXFactor());
                        CubeViewer3D.this.yTrans.rotY(Math.pow(Math.sin(CubeViewer3D.this.rotAngle), 2.0) * CubeViewer3D.this.cube3D.getYFactor());
                        CubeViewer3D.this.zTrans.rotZ(Math.cos(CubeViewer3D.this.rotAngle) * Math.sin(CubeViewer3D.this.rotAngle) * CubeViewer3D.this.cube3D.getZFactor());
                        CubeViewer3D.this.rotAngle += (CubeViewer3D.this.cube3D.getXFactor() + CubeViewer3D.this.cube3D.getYFactor() + CubeViewer3D.this.cube3D.getZFactor()) / 3.0 / 2.0;
                        while (CubeViewer3D.this.rotAngle >= Math.PI * 2) {
                            CubeViewer3D.this.rotAngle -= Math.PI * 2;
                        }
                        currTrans = new Transform3D();
                        CubeViewer3D.this.cube3D.getTransform((Transform3D)currTrans);
                        currTrans.mul(CubeViewer3D.this.xTrans, (Transform3D)currTrans);
                        currTrans.mul(CubeViewer3D.this.yTrans, (Transform3D)currTrans);
                        currTrans.mul(CubeViewer3D.this.zTrans, (Transform3D)currTrans);
                        CubeViewer3D.this.cube3D.setTransform((Transform3D)currTrans);
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(CubeViewer3D.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        continue;
                    }
                    currTrans = CubeViewer3D.this.smoothList;
                    synchronized (currTrans) {
                        if (targetQuat != null) {
                            CubeViewer3D.this.smoothList.remove(targetQuat);
                        }
                        targetQuat = !(isEmpty = CubeViewer3D.this.smoothList.isEmpty()) ? (Quat4d)CubeViewer3D.this.smoothList.get(0) : null;
                    }
                    if (isEmpty) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(CubeViewer3D.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        continue;
                    }
                    Transform3D trans = new Transform3D();
                    CubeViewer3D.this.cube3D.getTransform(trans);
                    Quat4d currQuat = new Quat4d();
                    trans.get(currQuat);
                    int ms = 1000;
                    double fpms = (double)CubeViewer3D.this.cube3D.getRPS() / 1000.0;
                    int frames = (int)Math.rint(fpms * (double)ms);
                    int sleep = (int)Math.rint((double)ms / (double)frames);
                    double xInc = (targetQuat.getX() - currQuat.getX()) / (double)frames;
                    double yInc = (targetQuat.getY() - currQuat.getY()) / (double)frames;
                    double zInc = (targetQuat.getZ() - currQuat.getZ()) / (double)frames;
                    UUID mouseBlock = CubeViewer3D.this.blockMouse();
                    for (int i = 0; i < frames; ++i) {
                        double x = currQuat.getX() + xInc;
                        double y = currQuat.getY() + yInc;
                        double z = currQuat.getZ() + zInc;
                        if (x > 1.0) {
                            x = 1.0;
                        }
                        if (x < -1.0) {
                            x = -1.0;
                        }
                        if (y > 1.0) {
                            y = 1.0;
                        }
                        if (y < -1.0) {
                            y = -1.0;
                        }
                        if (z > 1.0) {
                            z = 1.0;
                        }
                        if (z < -1.0) {
                            z = -1.0;
                        }
                        currQuat.setW(Math.sqrt(1.0 - x * x - y * y - z * z));
                        currQuat.setX(x);
                        currQuat.setY(y);
                        currQuat.setZ(z);
                        trans.setRotation(currQuat);
                        CubeViewer3D.this.cube3D.setTransform(trans);
                        try {
                            Thread.sleep(sleep);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(CubeViewer3D.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    trans.setRotation(targetQuat);
                    CubeViewer3D.this.cube3D.setTransform(trans);
                    CubeViewer3D.this.unblockMouse(mouseBlock);
                }
            }
        };
        this.smoothRotater.start();
    }

    public UUID blockMouse() {
        return this.mouseBehavior.block();
    }

    public void unblockMouse(UUID blockId) {
        this.mouseBehavior.unblock(blockId);
    }

    public UUID blockMouseRotation() {
        return this.mouseBehavior.blockRotation();
    }

    public void unblockMouseRotation(UUID blockId) {
        this.mouseBehavior.unblockRotation(blockId);
    }

    private void makeFaceFix(int face, Transform3D trans1) {
        switch (face) {
            case 0: {
                trans1.rotX(Math.toRadians(90.0));
                break;
            }
            case 1: {
                trans1.rotY(Math.toRadians(90.0));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                trans1.rotY(Math.toRadians(-90.0));
                break;
            }
            case 4: {
                trans1.rotX(Math.toRadians(-90.0));
                break;
            }
            case 5: {
                trans1.rotY(Math.toRadians(180.0));
            }
        }
    }

    public void makeFaceInFront(int face) {
        Transform3D trans1 = new Transform3D();
        Transform3D trans2 = new Transform3D();
        this.makeFaceFix(face, trans1);
        trans2.rotY(Math.toRadians(45.0));
        trans1.mul(trans2, trans1);
        trans2.rotX(Math.toRadians(30.0));
        trans1.mul(trans2, trans1);
        this.rotateSmooth(trans1);
    }

    public void makeFaceOnSide(int face) {
        Transform3D trans1 = new Transform3D();
        Transform3D trans2 = new Transform3D();
        this.makeFaceFix(face, trans1);
        trans2.rotY(Math.toRadians(-45.0));
        trans1.mul(trans2, trans1);
        trans2.rotX(Math.toRadians(30.0));
        trans1.mul(trans2, trans1);
        this.rotateSmooth(trans1);
    }

    public void makeFaceInFrontUpsideDown(int face) {
        Transform3D trans1 = new Transform3D();
        Transform3D trans2 = new Transform3D();
        this.makeFaceFix(face, trans1);
        trans2.rotZ(Math.toRadians(180.0));
        trans1.mul(trans2, trans1);
        trans2.rotY(Math.toRadians(45.0));
        trans1.mul(trans2, trans1);
        trans2.rotX(Math.toRadians(30.0));
        trans1.mul(trans2, trans1);
        this.rotateSmooth(trans1);
    }

    public void makeFaceOnSideUpsideDown(int face) {
        Transform3D trans1 = new Transform3D();
        Transform3D trans2 = new Transform3D();
        this.makeFaceFix(face, trans1);
        trans2.rotZ(Math.toRadians(180.0));
        trans1.mul(trans2, trans1);
        trans2.rotY(Math.toRadians(-45.0));
        trans1.mul(trans2, trans1);
        trans2.rotX(Math.toRadians(30.0));
        trans1.mul(trans2, trans1);
        this.rotateSmooth(trans1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateSmooth(Transform3D trans) {
        Quat4d targetQuat = new Quat4d();
        trans.get(targetQuat);
        List<Quat4d> list = this.smoothList;
        synchronized (list) {
            this.smoothList.add(targetQuat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateSmooth(Quat4d targetQuat) {
        List<Quat4d> list = this.smoothList;
        synchronized (list) {
            this.smoothList.add(new Quat4d(targetQuat));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRotations() {
        List<Quat4d> list = this.smoothList;
        synchronized (list) {
            int i = 1;
            while (i < this.smoothList.size()) {
                this.smoothList.remove(i);
            }
        }
    }

    public void waitForRotation() {
        try {
            while (this.isRotating()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CubeViewer3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRotating() {
        List<Quat4d> list = this.smoothList;
        synchronized (list) {
            return !this.smoothList.isEmpty();
        }
    }

    public void setRotateMS(int newMS) {
        this.cube3D.setRotateMS(newMS);
    }

    public int getRotateMS() {
        return this.cube3D.getRotateMS();
    }

    public void setRPS(float newRPS) {
        this.cube3D.setRPS(newRPS);
    }

    public float getRPS() {
        return this.cube3D.getRPS();
    }

    public RubiksCube3D getCube3D() {
        return this.cube3D;
    }

    public boolean autoRotate() {
        return this.autoRotate;
    }

    public void setAutoRotate(boolean b) {
        this.autoRotate = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.universe.cleanup();
            this.universe.removeAllLocales();
        }
        finally {
            super.finalize();
        }
    }
}

