/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.gui.graphics3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Primitive;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import rubikscube.game.CubeMath;
import rubikscube.gui.utils.Tools3D;

public class Cubie3D
extends Primitive {
    private float scale;
    private Face3D[][][] faces;
    private Edges3D edges;

    public Cubie3D(float scale, Color unusedFaceColor) {
        this(scale, Tools3D.getColor3f(unusedFaceColor));
    }

    public Cubie3D(float scale, Color3f unusedFaceColor) {
        if (scale < 0.0f) {
            throw new IllegalArgumentException("invalid scale");
        }
        this.scale = scale;
        float edge = scale / 12.0f;
        this.faces = new Face3D[6][1][1];
        for (int i = 0; i < this.faces.length; ++i) {
            this.faces[i][0][0] = new Face3D(i, edge, scale, unusedFaceColor);
            this.addChild((Node)this.faces[i][0][0]);
        }
        this.edges = new Edges3D(edge, scale);
        this.addChild((Node)this.edges);
    }

    public void rotateFace(int face, int direction) {
        this.faces = CubeMath.rotateFace(this.faces, face, direction);
    }

    public void rotateRow(int face, int direction) {
        this.faces = CubeMath.rotateRow(this.faces, face, 0, direction);
    }

    public void rotateColumn(int face, int direction) {
        this.faces = CubeMath.rotateColumn(this.faces, face, 0, direction);
    }

    public float getScale() {
        return this.scale;
    }

    public Shape3D getShape(int i) {
        return this.faces[i][0][0];
    }

    public Appearance getAppearance() {
        return this.edges.getAppearance();
    }

    public void setAppearance(Appearance ap) {
        this.edges.setAppearance(ap);
    }

    public Appearance getAppearance(int face) {
        return this.faces[face][0][0].getAppearance();
    }

    public void setAppearance(int face, Appearance ap) {
        this.faces[face][0][0].setAppearance(ap);
    }

    public class Edges3D
    extends Shape3D {
        private Edges3D(float edge, float scale) {
            Point3d[] pts = new Point3d[]{new Point3d((double)(edge / 2.0f), (double)(scale - edge / 2.0f), (double)(scale - edge / 2.0f)), new Point3d((double)edge, (double)(scale - edge), (double)scale), new Point3d((double)(scale - edge), (double)(scale - edge), (double)scale), new Point3d((double)(scale - edge / 2.0f), (double)(scale - edge / 2.0f), (double)(scale - edge / 2.0f)), new Point3d((double)(scale - edge), (double)scale, (double)(scale - edge)), new Point3d((double)edge, (double)scale, (double)(scale - edge)), new Point3d((double)edge, 0.0, (double)(scale - edge)), new Point3d((double)(scale - edge), 0.0, (double)(scale - edge)), new Point3d((double)(scale - edge / 2.0f), (double)(edge / 2.0f), (double)(scale - edge / 2.0f)), new Point3d((double)(scale - edge), (double)edge, (double)scale), new Point3d((double)edge, (double)edge, (double)scale), new Point3d((double)(edge / 2.0f), (double)(edge / 2.0f), (double)(scale - edge / 2.0f)), new Point3d((double)edge, (double)scale, (double)edge), new Point3d((double)(scale - edge), (double)scale, (double)edge), new Point3d((double)(scale - edge / 2.0f), (double)(scale - edge / 2.0f), (double)(edge / 2.0f)), new Point3d((double)(scale - edge), (double)(scale - edge), 0.0), new Point3d((double)edge, (double)(scale - edge), 0.0), new Point3d((double)(edge / 2.0f), (double)(scale - edge / 2.0f), (double)(edge / 2.0f)), new Point3d((double)(edge / 2.0f), (double)(edge / 2.0f), (double)(edge / 2.0f)), new Point3d((double)edge, (double)edge, 0.0), new Point3d((double)(scale - edge), (double)edge, 0.0), new Point3d((double)(scale - edge / 2.0f), (double)(edge / 2.0f), (double)(edge / 2.0f)), new Point3d((double)(scale - edge), 0.0, (double)edge), new Point3d((double)edge, 0.0, (double)edge), new Point3d((double)(scale - edge / 2.0f), (double)(scale - edge / 2.0f), (double)(scale - edge / 2.0f)), new Point3d((double)scale, (double)(scale - edge), (double)(scale - edge)), new Point3d((double)scale, (double)(scale - edge), (double)edge), new Point3d((double)(scale - edge / 2.0f), (double)(scale - edge / 2.0f), (double)(edge / 2.0f)), new Point3d((double)(scale - edge), (double)scale, (double)edge), new Point3d((double)(scale - edge), (double)scale, (double)(scale - edge)), new Point3d((double)(scale - edge), 0.0, (double)(scale - edge)), new Point3d((double)(scale - edge), 0.0, (double)edge), new Point3d((double)(scale - edge / 2.0f), (double)(edge / 2.0f), (double)(edge / 2.0f)), new Point3d((double)scale, (double)edge, (double)edge), new Point3d((double)scale, (double)edge, (double)(scale - edge)), new Point3d((double)(scale - edge / 2.0f), (double)(edge / 2.0f), (double)(scale - edge / 2.0f)), new Point3d((double)edge, (double)scale, (double)(scale - edge)), new Point3d((double)edge, (double)scale, (double)edge), new Point3d((double)(edge / 2.0f), (double)(scale - edge / 2.0f), (double)(edge / 2.0f)), new Point3d(0.0, (double)(scale - edge), (double)edge), new Point3d(0.0, (double)(scale - edge), (double)(scale - edge)), new Point3d((double)(edge / 2.0f), (double)(scale - edge / 2.0f), (double)(scale - edge / 2.0f)), new Point3d((double)(edge / 2.0f), (double)(edge / 2.0f), (double)(scale - edge / 2.0f)), new Point3d(0.0, (double)edge, (double)(scale - edge)), new Point3d(0.0, (double)edge, (double)edge), new Point3d((double)(edge / 2.0f), (double)(edge / 2.0f), (double)(edge / 2.0f)), new Point3d((double)edge, 0.0, (double)edge), new Point3d((double)edge, 0.0, (double)(scale - edge)), new Point3d((double)(edge / 2.0f), (double)(scale - edge / 2.0f), (double)(scale - edge / 2.0f)), new Point3d(0.0, (double)(scale - edge), (double)(scale - edge)), new Point3d(0.0, (double)edge, (double)(scale - edge)), new Point3d((double)(edge / 2.0f), (double)(edge / 2.0f), (double)(scale - edge / 2.0f)), new Point3d((double)edge, (double)edge, (double)scale), new Point3d((double)edge, (double)(scale - edge), (double)scale), new Point3d((double)(scale - edge), (double)(scale - edge), (double)scale), new Point3d((double)(scale - edge), (double)edge, (double)scale), new Point3d((double)(scale - edge / 2.0f), (double)(edge / 2.0f), (double)(scale - edge / 2.0f)), new Point3d((double)scale, (double)edge, (double)(scale - edge)), new Point3d((double)scale, (double)(scale - edge), (double)(scale - edge)), new Point3d((double)(scale - edge / 2.0f), (double)(scale - edge / 2.0f), (double)(scale - edge / 2.0f)), new Point3d((double)(scale - edge / 2.0f), (double)(scale - edge / 2.0f), (double)(edge / 2.0f)), new Point3d((double)scale, (double)(scale - edge), (double)edge), new Point3d((double)scale, (double)edge, (double)edge), new Point3d((double)(scale - edge / 2.0f), (double)(edge / 2.0f), (double)(edge / 2.0f)), new Point3d((double)(scale - edge), (double)edge, 0.0), new Point3d((double)(scale - edge), (double)(scale - edge), 0.0), new Point3d((double)edge, (double)(scale - edge), 0.0), new Point3d((double)edge, (double)edge, 0.0), new Point3d((double)(edge / 2.0f), (double)(edge / 2.0f), (double)(edge / 2.0f)), new Point3d(0.0, (double)edge, (double)edge), new Point3d(0.0, (double)(scale - edge), (double)edge), new Point3d((double)(edge / 2.0f), (double)(scale - edge / 2.0f), (double)(edge / 2.0f))};
            GeometryInfo gi = new GeometryInfo(5);
            gi.setCoordinates(pts);
            gi.setStripCounts(new int[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6});
            gi.setContourCounts(new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
            NormalGenerator ng = new NormalGenerator();
            ng.setCreaseAngle(30.0);
            ng.generateNormals(gi);
            this.setCapability(14);
            this.setCapability(15);
            this.setGeometry((Geometry)gi.getGeometryArray());
            this.setAppearance(Tools3D.getAppearance(Color.BLACK));
        }
    }

    public class Face3D
    extends Shape3D {
        private Face3D(int face, float edge, float scale, Color3f unusedFaceColor) {
            Point3d[] pts = new Point3d[4];
            switch (face) {
                case 2: {
                    pts[0] = new Point3d((double)edge, (double)edge, (double)scale);
                    pts[1] = new Point3d((double)(scale - edge), (double)edge, (double)scale);
                    pts[2] = new Point3d((double)(scale - edge), (double)(scale - edge), (double)scale);
                    pts[3] = new Point3d((double)edge, (double)(scale - edge), (double)scale);
                    break;
                }
                case 5: {
                    pts[0] = new Point3d((double)edge, (double)(scale - edge), 0.0);
                    pts[1] = new Point3d((double)(scale - edge), (double)(scale - edge), 0.0);
                    pts[2] = new Point3d((double)(scale - edge), (double)edge, 0.0);
                    pts[3] = new Point3d((double)edge, (double)edge, 0.0);
                    break;
                }
                case 3: {
                    pts[0] = new Point3d((double)scale, (double)(scale - edge), (double)edge);
                    pts[1] = new Point3d((double)scale, (double)(scale - edge), (double)(scale - edge));
                    pts[2] = new Point3d((double)scale, (double)edge, (double)(scale - edge));
                    pts[3] = new Point3d((double)scale, (double)edge, (double)edge);
                    break;
                }
                case 1: {
                    pts[0] = new Point3d(0.0, (double)edge, (double)edge);
                    pts[1] = new Point3d(0.0, (double)edge, (double)(scale - edge));
                    pts[2] = new Point3d(0.0, (double)(scale - edge), (double)(scale - edge));
                    pts[3] = new Point3d(0.0, (double)(scale - edge), (double)edge);
                    break;
                }
                case 0: {
                    pts[0] = new Point3d((double)edge, (double)scale, (double)edge);
                    pts[1] = new Point3d((double)edge, (double)scale, (double)(scale - edge));
                    pts[2] = new Point3d((double)(scale - edge), (double)scale, (double)(scale - edge));
                    pts[3] = new Point3d((double)(scale - edge), (double)scale, (double)edge);
                    break;
                }
                case 4: {
                    pts[0] = new Point3d((double)(scale - edge), 0.0, (double)edge);
                    pts[1] = new Point3d((double)(scale - edge), 0.0, (double)(scale - edge));
                    pts[2] = new Point3d((double)edge, 0.0, (double)(scale - edge));
                    pts[3] = new Point3d((double)edge, 0.0, (double)edge);
                }
            }
            GeometryInfo gi = new GeometryInfo(5);
            gi.setCoordinates(pts);
            gi.setStripCounts(new int[]{4});
            gi.setContourCounts(new int[]{1});
            NormalGenerator ng = new NormalGenerator();
            ng.setCreaseAngle(0.0);
            ng.generateNormals(gi);
            this.setCapability(14);
            this.setCapability(15);
            this.setGeometry((Geometry)gi.getGeometryArray());
            this.setAppearance(Tools3D.getAppearance(unusedFaceColor));
        }

        public int getFace() {
            for (int i = 0; i < 6; ++i) {
                if (Cubie3D.this.faces[i][0][0] != this) continue;
                return i;
            }
            return -1;
        }
    }
}

