/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.gui.graphics3d;

import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;
import rubikscube.game.CubeMath;
import rubikscube.game.RubiksCube;
import rubikscube.game.RubiksCubeListener;
import rubikscube.gui.graphics3d.Cubie3D;
import rubikscube.gui.utils.Tools3D;

public class RubiksCube3D
extends TransformGroup
implements RubiksCubeListener {
    public static final int PRIORITY_NONE = 0;
    public static final int PRIORITY_LOWEST = 1000;
    public static final int PRIORITY_LOW = 2000;
    public static final int PRIORITY_MEDIUM = 3000;
    public static final int PRIORITY_HIGH = 4000;
    public static final int PRIORITY_HIGHEST = 5000;
    private float scale;
    private float offset;
    private RubiksCube cube;
    private int rotateMS;
    private float rps;
    private final Object rotationLock = new Object();
    private final Object cubiesLock = new Object();
    private Cubie3D[][][] cubies;
    private Color3f[][][] orgCubieLight;
    private Cubie3D[][][] faces;
    private BranchGroup branchGroup = new BranchGroup();
    private double xFactor;
    private double yFactor = this.xFactor = 0.0075;
    private double zFactor = this.xFactor;
    private final Map<UUID, int[][]> highArrays = new HashMap<UUID, int[][]>();
    private final Map<UUID, Cubie3D[]> trackArray = new HashMap<UUID, Cubie3D[]>();
    private final Map<UUID, Color> highlights = new HashMap<UUID, Color>();
    private final Map<UUID, Integer> priorities = new HashMap<UUID, Integer>();

    public RubiksCube3D(float scale, RubiksCube cube) {
        if (cube == null) {
            throw new NullPointerException("cube == null");
        }
        this.cube = cube;
        this.scale = scale;
        this.offset = scale * 0.05f;
        cube.addCubeListener(this);
        this.setCapability(17);
        this.setCapability(18);
        this.setCapability(14);
        this.setCapability(12);
        this.setCapability(13);
        this.rotateMS = 500;
        this.rps = 60.0f;
        this.buildCube();
    }

    private void buildCube() {
        this.cubies = new Cubie3D[this.cube.getSize()][this.cube.getSize()][this.cube.getSize()];
        this.orgCubieLight = new Color3f[this.cube.getSize()][this.cube.getSize()][this.cube.getSize()];
        this.faces = new Cubie3D[6][this.cube.getSize()][this.cube.getSize()];
        for (int x = 0; x < this.cubies.length; ++x) {
            for (int y = 0; y < this.cubies[x].length; ++y) {
                for (int z = 0; z < this.cubies[x][y].length; ++z) {
                    this.cubies[x][y][z] = new Cubie3D(this.scale, Color.GRAY);
                    this.cubies[x][y][z].setCapability(64);
                    this.cubies[x][y][z].setCapability(16);
                    this.orgCubieLight[x][y][z] = new Color3f();
                    this.cubies[x][y][z].getAppearance().getMaterial().getEmissiveColor(this.orgCubieLight[x][y][z]);
                    Transform3D trans = new Transform3D();
                    trans.setTranslation(new Vector3d((double)((this.scale + this.offset) * (float)x - this.scale * ((float)this.cube.getSize() / 2.0f) - this.offset * ((float)(this.cube.getSize() - 1) / 2.0f)), (double)((this.scale + this.offset) * (float)y - this.scale * ((float)this.cube.getSize() / 2.0f) - this.offset * ((float)(this.cube.getSize() - 1) / 2.0f)), (double)((this.scale + this.offset) * (float)z - this.scale * ((float)this.cube.getSize() / 2.0f) - this.offset * ((float)(this.cube.getSize() - 1) / 2.0f))));
                    TransformGroup tg = new TransformGroup();
                    tg.setCapability(18);
                    tg.setCapability(17);
                    tg.setCapability(12);
                    tg.setCapability(13);
                    tg.setTransform(trans);
                    tg.addChild((Node)this.cubies[x][y][z]);
                    this.branchGroup.addChild((Node)tg);
                    if (y == this.cube.getSize() - 1) {
                        this.faces[0][x][z] = this.cubies[x][y][z];
                    }
                    if (x == 0) {
                        this.faces[1][z][this.cube.getSize() - 1 - y] = this.cubies[x][y][z];
                    }
                    if (z == this.cube.getSize() - 1) {
                        this.faces[2][x][this.cube.getSize() - 1 - y] = this.cubies[x][y][z];
                    }
                    if (x == this.cube.getSize() - 1) {
                        this.faces[3][this.cube.getSize() - 1 - z][this.cube.getSize() - 1 - y] = this.cubies[x][y][z];
                    }
                    if (y == 0) {
                        this.faces[4][x][this.cube.getSize() - 1 - z] = this.cubies[x][y][z];
                    }
                    if (z != 0) continue;
                    this.faces[5][x][y] = this.cubies[x][y][z];
                }
            }
        }
        this.addChild((Node)this.branchGroup);
        this.reset();
    }

    public BranchGroup getBranchGroup() {
        return this.branchGroup;
    }

    public double getXFactor() {
        return this.xFactor;
    }

    public double getYFactor() {
        return this.yFactor;
    }

    public double getZFactor() {
        return this.zFactor;
    }

    public void setFactor(double factor) {
        this.yFactor = this.zFactor = factor;
        this.xFactor = this.zFactor;
    }

    public void setFactor(double xFactor, double yFactor, double zFactor) {
        this.xFactor = xFactor;
        this.yFactor = yFactor;
        this.zFactor = zFactor;
    }

    public RubiksCube getCube() {
        return this.cube;
    }

    public void setRotateMS(int newMS) {
        if (newMS < 0) {
            return;
        }
        this.rotateMS = newMS;
    }

    public int getRotateMS() {
        return this.rotateMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRPS(float newRPS) {
        if (newRPS <= 0.0f) {
            return;
        }
        Object object = this.cubiesLock;
        synchronized (object) {
            this.rps = newRPS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getRPS() {
        Object object = this.cubiesLock;
        synchronized (object) {
            return this.rps;
        }
    }

    private void rotateFace(int face, int direction) {
        switch (face) {
            case 0: {
                this.rotateRow(1, 0, direction == 0 ? 1 : 0);
                break;
            }
            case 1: {
                this.rotateColumn(2, 0, direction == 0 ? 2 : 3);
                break;
            }
            case 2: {
                this.rotateRow(0, this.cube.getSize() - 1, direction);
                break;
            }
            case 3: {
                this.rotateColumn(2, this.cube.getSize() - 1, direction == 0 ? 3 : 2);
                break;
            }
            case 4: {
                this.rotateRow(2, this.cube.getSize() - 1, direction);
                break;
            }
            case 5: {
                this.rotateRow(0, 0, direction == 0 ? 1 : 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateRow(int face, int row, int direction) {
        Cubie3D[] cubieArray;
        Object object = this.cubiesLock;
        synchronized (object) {
            for (Cubie3D cubie : cubieArray = this.intArrayToCubieArray(this.getRow0(face, row))) {
                cubie.rotateRow(face, direction);
            }
            this.faces = CubeMath.rotateRow(this.faces, face, row, direction);
            this.synchronizeCubies();
        }
        object = this.rotationLock;
        synchronized (object) {
            boolean invert = direction == 0;
            double angle = Math.toRadians(90.0f / this.rps);
            Transform3D tempTrans = new Transform3D();
            if (face == 0) {
                tempTrans.rotZ((double)(invert ? 1 : -1) * angle);
            } else if (face >= 1 && face <= 3) {
                tempTrans.rotY((double)(invert ? -1 : 1) * angle);
            } else if (face == 4) {
                tempTrans.rotZ((double)(invert ? -1 : 1) * angle);
            } else {
                tempTrans.rotY((double)(invert ? 1 : -1) * angle);
            }
            Transform3D currTrans = new Transform3D();
            int i = 0;
            while ((float)i < this.rps) {
                for (int a = 0; a < cubieArray.length; ++a) {
                    ((TransformGroup)cubieArray[a].getParent()).getTransform(currTrans);
                    currTrans.mul(tempTrans, currTrans);
                    ((TransformGroup)cubieArray[a].getParent()).setTransform(currTrans);
                }
                try {
                    Thread.sleep((long)((float)this.rotateMS / this.rps));
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateColumn(int face, int column, int direction) {
        Cubie3D[] cubieArray;
        Object object = this.cubiesLock;
        synchronized (object) {
            for (Cubie3D cubie : cubieArray = this.intArrayToCubieArray(this.getColumn0(face, column))) {
                cubie.rotateColumn(face, direction);
            }
            this.faces = CubeMath.rotateColumn(this.faces, face, column, direction);
            this.synchronizeCubies();
        }
        object = this.rotationLock;
        synchronized (object) {
            boolean invert = direction == 2;
            double angle = Math.toRadians(90.0f / this.rps);
            Transform3D tempTrans = new Transform3D();
            if (face == 1) {
                tempTrans.rotZ((double)(invert ? -1 : 1) * angle);
            } else if (face == 3) {
                tempTrans.rotZ((double)(invert ? 1 : -1) * angle);
            } else {
                tempTrans.rotX((double)(invert ? -1 : 1) * angle);
            }
            Transform3D currTrans = new Transform3D();
            int i = 0;
            while ((float)i < this.rps) {
                for (int a = 0; a < cubieArray.length; ++a) {
                    ((TransformGroup)cubieArray[a].getParent()).getTransform(currTrans);
                    currTrans.mul(tempTrans, currTrans);
                    ((TransformGroup)cubieArray[a].getParent()).setTransform(currTrans);
                }
                try {
                    Thread.sleep((long)((float)this.rotateMS / this.rps));
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public int[][] convertFaceletsToCubies(int[][] facelets) {
        int[][] ret = new int[facelets.length][3];
        int size = this.cube.getSize() - 1;
        block8: for (int i = 0; i < facelets.length; ++i) {
            switch (facelets[i][0]) {
                case 0: {
                    ret[i][0] = facelets[i][1];
                    ret[i][1] = size;
                    ret[i][2] = facelets[i][2];
                    continue block8;
                }
                case 1: {
                    ret[i][0] = 0;
                    ret[i][1] = size - facelets[i][2];
                    ret[i][2] = facelets[i][1];
                    continue block8;
                }
                case 2: {
                    ret[i][0] = facelets[i][1];
                    ret[i][1] = size - facelets[i][2];
                    ret[i][2] = size;
                    continue block8;
                }
                case 3: {
                    ret[i][0] = size;
                    ret[i][1] = size - facelets[i][2];
                    ret[i][2] = size - facelets[i][1];
                    continue block8;
                }
                case 4: {
                    ret[i][0] = facelets[i][1];
                    ret[i][1] = 0;
                    ret[i][2] = size - facelets[i][2];
                    continue block8;
                }
                case 5: {
                    ret[i][0] = facelets[i][1];
                    ret[i][1] = facelets[i][2];
                    ret[i][2] = 0;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID highlightCube(Color highlight, int priority) {
        UUID randomID = UUID.randomUUID();
        Object object = this.cubiesLock;
        synchronized (object) {
            this.highArrays.put(randomID, null);
            this.highlights.put(randomID, highlight);
            this.priorities.put(randomID, priority);
            this.updateHighlights0();
        }
        return randomID;
    }

    public UUID highlightCubie(Cubie3D cubie, Color highlight, int priority, boolean still) {
        return this.highlightCubie(this.getCubiePos(cubie), highlight, priority, still);
    }

    public UUID highlightCubie(int[] xyz, Color highlight, int priority, boolean still) {
        return this.highlightCubie(xyz[0], xyz[1], xyz[2], highlight, priority, still);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID highlightCubie(int x, int y, int z, Color highlight, int priority, boolean still) {
        UUID randomID = UUID.randomUUID();
        Object object = this.cubiesLock;
        synchronized (object) {
            if (still) {
                this.highArrays.put(randomID, new int[][]{{x, y, z}});
            } else {
                this.trackArray.put(randomID, new Cubie3D[]{this.cubies[x][y][z]});
            }
            this.highlights.put(randomID, highlight);
            this.priorities.put(randomID, priority);
            this.updateHighlights0();
        }
        return randomID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID highlightCubies(int[][] cubies, Color highlight, int priority, boolean still) {
        UUID randomID = UUID.randomUUID();
        Object object = this.cubiesLock;
        synchronized (object) {
            if (still) {
                this.highArrays.put(randomID, cubies);
            } else {
                this.trackArray.put(randomID, this.intArrayToCubieArray(cubies));
            }
            this.highlights.put(randomID, highlight);
            this.priorities.put(randomID, priority);
            this.updateHighlights0();
        }
        return randomID;
    }

    private void highlightCubie0(int[] xyz, Color highlight) {
        this.highlightCubie0(xyz[0], xyz[1], xyz[2], highlight);
    }

    private void highlightCubie0(int x, int y, int z, Color highlight) {
        this.highlightCubie0(this.cubies[x][y][z], highlight);
    }

    private void highlightCubie0(Cubie3D cubie, Color highlight) {
        cubie.getAppearance().getMaterial().setEmissiveColor(Tools3D.getColor3f(highlight));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID highlightFace(int face, Color highlight, int priority, boolean still) {
        UUID randomID = UUID.randomUUID();
        Object object = this.cubiesLock;
        synchronized (object) {
            int[][] cubieArray = this.getFace0(face);
            if (still) {
                this.highArrays.put(randomID, cubieArray);
            } else {
                this.trackArray.put(randomID, this.intArrayToCubieArray(cubieArray));
            }
            this.highlights.put(randomID, highlight);
            this.priorities.put(randomID, priority);
            this.updateHighlights0();
        }
        return randomID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID highlightRow(int face, int row, Color highlight, int priority, boolean still) {
        UUID randomID = UUID.randomUUID();
        Object object = this.cubiesLock;
        synchronized (object) {
            int[][] cubieArray = this.getRow0(face, row);
            if (still) {
                this.highArrays.put(randomID, cubieArray);
            } else {
                this.trackArray.put(randomID, this.intArrayToCubieArray(cubieArray));
            }
            this.highlights.put(randomID, highlight);
            this.priorities.put(randomID, priority);
            this.updateHighlights0();
        }
        return randomID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID highlightColumn(int face, int column, Color highlight, int priority, boolean still) {
        UUID randomID = UUID.randomUUID();
        Object object = this.cubiesLock;
        synchronized (object) {
            int[][] cubieArray = this.getColumn0(face, column);
            if (still) {
                this.highArrays.put(randomID, cubieArray);
            } else {
                this.trackArray.put(randomID, this.intArrayToCubieArray(cubieArray));
            }
            this.highlights.put(randomID, highlight);
            this.priorities.put(randomID, priority);
            this.updateHighlights0();
        }
        return randomID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceHighlight(UUID id, Color highlight) {
        Object object = this.cubiesLock;
        synchronized (object) {
            this.replaceHighlight0(id, highlight);
        }
    }

    private void replaceHighlight0(UUID id, Color highlight) {
        if (highlight != null && this.highlights.containsKey(id) && !this.highlights.get(id).equals(highlight)) {
            this.highlights.put(id, highlight);
            this.updateHighlights0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllHighlights(boolean still) {
        Object object = this.cubiesLock;
        synchronized (object) {
            UUID[] ids;
            if (still) {
                ids = this.highArrays.keySet().toArray(new UUID[0]);
                new ArrayList().toArray();
                this.highArrays.clear();
            } else {
                ids = this.trackArray.keySet().toArray(new UUID[0]);
                this.trackArray.clear();
            }
            for (UUID id : ids) {
                this.priorities.remove(id);
                this.highlights.remove(id);
            }
            this.updateHighlights0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlight(UUID id) {
        Object object = this.cubiesLock;
        synchronized (object) {
            this.highArrays.remove(id);
            this.highlights.remove(id);
            this.trackArray.remove(id);
            this.priorities.remove(id);
            this.updateHighlights0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cubie3D[][][] getAllCubies() {
        Cubie3D[][][] ret = new Cubie3D[this.cube.getSize()][this.cube.getSize()][this.cube.getSize()];
        Object object = this.cubiesLock;
        synchronized (object) {
            for (int x = 0; x < ret.length; ++x) {
                for (int y = 0; y < ret[x].length; ++y) {
                    System.arraycopy(this.cubies[x][y], 0, ret[x][y], 0, ret[x][y].length);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getFace(int face) {
        Object object = this.cubiesLock;
        synchronized (object) {
            return this.getFace0(face);
        }
    }

    public int[][] getFace0(int face) {
        if (face == 0) {
            return this.getRow(1, 0);
        }
        if (face == 1) {
            return this.getColumn(2, 0);
        }
        if (face == 2) {
            return this.getRow(0, this.cube.getSize() - 1);
        }
        if (face == 3) {
            return this.getColumn(2, this.cube.getSize() - 1);
        }
        if (face == 4) {
            return this.getRow(2, this.cube.getSize() - 1);
        }
        return this.getRow(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getRow(int face, int row) {
        Object object = this.cubiesLock;
        synchronized (object) {
            return this.getRow0(face, row);
        }
    }

    private int[][] getRow0(int face, int row) {
        int[][] ret = new int[this.cube.getSize() * this.cube.getSize()][3];
        int i = 0;
        for (int x = 0; x < this.cubies.length; ++x) {
            for (int y = 0; y < this.cubies[x].length; ++y) {
                if (face == 0) {
                    ret[i][0] = x;
                    ret[i][1] = y;
                    ret[i++][2] = row;
                    continue;
                }
                if (face == 4) {
                    ret[i][0] = x;
                    ret[i][1] = y;
                    ret[i++][2] = this.cube.getSize() - 1 - row;
                    continue;
                }
                if (face == 5) {
                    ret[i][0] = x;
                    ret[i][1] = row;
                    ret[i++][2] = y;
                    continue;
                }
                ret[i][0] = x;
                ret[i][1] = this.cube.getSize() - 1 - row;
                ret[i++][2] = y;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getColumn(int face, int column) {
        Object object = this.cubiesLock;
        synchronized (object) {
            return this.getColumn0(face, column);
        }
    }

    private int[][] getColumn0(int face, int column) {
        int[][] ret = new int[this.cube.getSize() * this.cube.getSize()][3];
        int i = 0;
        for (int x = 0; x < this.cubies.length; ++x) {
            for (int y = 0; y < this.cubies[x].length; ++y) {
                if (face == 1) {
                    ret[i][0] = x;
                    ret[i][1] = y;
                    ret[i++][2] = column;
                    continue;
                }
                if (face == 3) {
                    ret[i][0] = x;
                    ret[i][1] = y;
                    ret[i++][2] = this.cube.getSize() - 1 - column;
                    continue;
                }
                ret[i][0] = column;
                ret[i][1] = x;
                ret[i++][2] = y;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getCubiePos(Cubie3D cubie) {
        Object object = this.cubiesLock;
        synchronized (object) {
            return this.getCubiePos0(cubie);
        }
    }

    private int[] getCubiePos0(Cubie3D cubie) {
        for (int x = 0; x < this.cube.getSize(); ++x) {
            for (int y = 0; y < this.cube.getSize(); ++y) {
                for (int z = 0; z < this.cube.getSize(); ++z) {
                    if (this.cubies[x][y][z] != cubie) continue;
                    return new int[]{x, y, z};
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getFaceletPos(Cubie3D.Face3D face) {
        Object object = this.cubiesLock;
        synchronized (object) {
            return this.getFaceletPos0(face);
        }
    }

    private int[] getFaceletPos0(Cubie3D.Face3D face) {
        Cubie3D cubie = (Cubie3D)face.getParent();
        int[] cubiePos = this.getCubiePos0(cubie);
        int size = this.cube.getSize() - 1;
        switch (face.getFace()) {
            case 0: {
                if (cubiePos[1] != size) break;
                return new int[]{0, cubiePos[0], cubiePos[2]};
            }
            case 1: {
                if (cubiePos[0] != 0) break;
                return new int[]{1, cubiePos[2], size - cubiePos[1]};
            }
            case 2: {
                if (cubiePos[2] != size) break;
                return new int[]{2, cubiePos[0], size - cubiePos[1]};
            }
            case 3: {
                if (cubiePos[0] != size) break;
                return new int[]{3, size - cubiePos[2], size - cubiePos[1]};
            }
            case 4: {
                if (cubiePos[1] != 0) break;
                return new int[]{4, cubiePos[0], size - cubiePos[2]};
            }
            case 5: {
                if (cubiePos[2] != 0) break;
                return new int[]{5, cubiePos[0], cubiePos[1]};
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cubie3D[] intArrayToCubieArray(int[][] intArray) {
        Cubie3D[] ret;
        Object object = this.cubiesLock;
        synchronized (object) {
            ret = new Cubie3D[intArray.length];
            for (int i = 0; i < intArray.length; ++i) {
                ret[i] = this.cubies[intArray[i][0]][intArray[i][1]][intArray[i][2]];
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeCubies() {
        Object object = this.cubiesLock;
        synchronized (object) {
            this.synchronizeCubie0();
        }
    }

    private void synchronizeCubie0() {
        for (int x = 0; x < this.cube.getSize(); ++x) {
            for (int y = 0; y < this.cube.getSize(); ++y) {
                for (int z = 0; z < this.cube.getSize(); ++z) {
                    if (y == this.cube.getSize() - 1) {
                        this.cubies[x][y][z] = this.faces[0][x][z];
                        continue;
                    }
                    if (x == 0) {
                        this.cubies[x][y][z] = this.faces[1][z][this.cube.getSize() - 1 - y];
                        continue;
                    }
                    if (z == this.cube.getSize() - 1) {
                        this.cubies[x][y][z] = this.faces[2][x][this.cube.getSize() - 1 - y];
                        continue;
                    }
                    if (x == this.cube.getSize() - 1) {
                        this.cubies[x][y][z] = this.faces[3][this.cube.getSize() - 1 - z][this.cube.getSize() - 1 - y];
                        continue;
                    }
                    if (y == 0) {
                        this.cubies[x][y][z] = this.faces[4][x][this.cube.getSize() - 1 - z];
                        continue;
                    }
                    if (z != 0) continue;
                    this.cubies[x][y][z] = this.faces[5][x][y];
                }
            }
        }
        this.updateHighlights0();
    }

    private void startView(boolean start) {
        VirtualUniverse universe;
        Locale locale = this.getLocale();
        VirtualUniverse virtualUniverse = universe = locale == null ? null : this.getLocale().getVirtualUniverse();
        if (this.isLive() && universe != null && universe instanceof SimpleUniverse) {
            if (start) {
                ((SimpleUniverse)universe).getViewer().getView().startView();
            } else {
                ((SimpleUniverse)universe).getViewer().getView().stopView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Object object = this.cubiesLock;
        synchronized (object) {
            Object object2 = this.rotationLock;
            synchronized (object2) {
                this.reset0();
            }
        }
    }

    private void reset0() {
        for (int face = 0; face < 6; ++face) {
            for (int x = 0; x < this.cube.getSize(); ++x) {
                for (int y = 0; y < this.cube.getSize(); ++y) {
                    Tools3D.changeAppearance(this.faces[face][x][y].getAppearance(face), RubiksCube.FACE_COLORS[this.cube.getFacelet(face, x, y)]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHighlights() {
        Object object = this.cubiesLock;
        synchronized (object) {
            this.startView(false);
            this.updateHighlights0();
            this.startView(true);
        }
    }

    private void updateHighlights0() {
        for (int x = 0; x < this.cube.getSize(); ++x) {
            for (int y = 0; y < this.cube.getSize(); ++y) {
                for (int z = 0; z < this.cube.getSize(); ++z) {
                    this.highlightCubie0(this.cubies[x][y][z], this.orgCubieLight[x][y][z].get());
                }
            }
        }
        if (this.priorities.isEmpty()) {
            return;
        }
        ArrayList<UUID> ids = new ArrayList<UUID>();
        UUID[] keys = this.priorities.keySet().toArray(new UUID[0]);
        Integer[] values = this.priorities.values().toArray(new Integer[0]);
        int min = Integer.MIN_VALUE;
        while (ids.size() < this.priorities.size()) {
            int i;
            int newMin = Integer.MAX_VALUE;
            for (i = 0; i < this.priorities.size(); ++i) {
                if (values[i] >= newMin || values[i] <= min) continue;
                newMin = values[i];
            }
            for (i = 0; i < this.priorities.size(); ++i) {
                if (values[i] != newMin) continue;
                ids.add(keys[i]);
            }
            min = newMin;
        }
        for (UUID id : ids) {
            int i;
            if (this.highArrays.containsKey(id)) {
                int[][] intArray = this.highArrays.get(id);
                if (intArray != null) {
                    for (i = 0; i < intArray.length; ++i) {
                        this.highlightCubie0(intArray[i], this.highlights.get(id));
                    }
                    continue;
                }
                for (int x = 0; x < this.cube.getSize(); ++x) {
                    for (int y = 0; y < this.cube.getSize(); ++y) {
                        for (int z = 0; z < this.cube.getSize(); ++z) {
                            this.highlightCubie0(x, y, z, this.highlights.get(id));
                        }
                    }
                }
                continue;
            }
            Cubie3D[] cubieArray = this.trackArray.get(id);
            for (i = 0; i < cubieArray.length; ++i) {
                this.highlightCubie0(cubieArray[i], this.highlights.get(id));
            }
        }
    }

    @Override
    public void cubeChanged(Map<String, Integer> details) {
        int method = details.get("method");
        int face = details.get("face");
        int direction = details.get("direction");
        if (method == 10) {
            this.rotateFace(face, direction);
        } else if (method == 11) {
            this.rotateRow(face, details.get("rowcolumn"), direction);
        } else if (method == 12) {
            this.rotateColumn(face, details.get("rowcolumn"), direction);
        }
    }

    @Override
    public void cubeEdited() {
        this.reset();
    }

    @Override
    public void godModeSet(boolean godMode) {
    }
}

