/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.gui.utils;

import java.awt.geom.Path2D;

public class Tools {
    public static Path2D.Float createDigit(int n, float size, float x, float y) {
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("n must be between 0 and 9 (n=" + n + ")");
        }
        Path2D.Float path = new Path2D.Float();
        if (n == 0 || n == 2 || n == 3 || n >= 5) {
            Tools.top(path, size, x, y);
        }
        if (n == 0 || n >= 4 && n <= 6 || n >= 8) {
            Tools.topLeft(path, size, x, y);
        }
        if (n != 2) {
            Tools.bottomRight(path, size, x, y);
        }
        if (n >= 2 && n <= 6 || n >= 8) {
            Tools.middle(path, size, x, y);
        }
        if (n == 0 || n == 2 || n == 6 || n == 8) {
            Tools.bottomLeft(path, size, x, y);
        }
        if (n != 5 && n != 6) {
            Tools.topRight(path, size, x, y);
        }
        if (n == 0 || n == 2 || n == 3 || n == 5 || n == 6 || n == 8) {
            Tools.bottom(path, size, x, y);
        }
        return path;
    }

    public static Path2D.Float createNegativeDigit(int n, float size, float x, float y) {
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("n must be between 0 and 9 (n=" + n + ")");
        }
        Path2D.Float path = new Path2D.Float();
        if (n == 1 || n == 4) {
            Tools.top(path, size, x, y);
        }
        if (n >= 1 && n <= 3 || n == 7) {
            Tools.topLeft(path, size, x, y);
        }
        if (n == 5 || n == 6) {
            Tools.topRight(path, size, x, y);
        }
        if (n <= 1 || n == 7) {
            Tools.middle(path, size, x, y);
        }
        if (n == 1 || n >= 3 && n <= 5 || n == 7 || n == 9) {
            Tools.bottomLeft(path, size, x, y);
        }
        if (n == 2) {
            Tools.bottomRight(path, size, x, y);
        }
        if (n == 1 || n == 4 || n == 7 || n == 9) {
            Tools.bottom(path, size, x, y);
        }
        return path;
    }

    private static void top(Path2D.Float path, float size, float x, float y) {
        float offset = size / 30.0f;
        path.moveTo(x + offset * 2.0f, y + offset);
        path.lineTo(x - offset * 2.0f + size * 2.0f / 3.0f, y + offset);
        path.lineTo((double)x - (double)offset * 6.2 + (double)(size * 2.0f / 3.0f), (double)(y + offset + size / 7.0f));
        path.lineTo((double)x + (double)offset * 6.2, (double)(y + offset + size / 7.0f));
    }

    private static void topLeft(Path2D.Float path, float size, float x, float y) {
        float offset = size / 30.0f;
        path.moveTo(x + offset, y + offset * 2.0f);
        path.lineTo(x + offset, y - offset * 2.0f / 3.0f + size / 2.0f);
        path.lineTo((double)(x + offset + size / 7.0f), (double)y - (double)offset * 3.2 + (double)(size / 2.0f));
        path.lineTo((double)(x + offset + size / 7.0f), (double)y + (double)offset * 6.2);
    }

    private static void topRight(Path2D.Float path, float size, float x, float y) {
        float offset = size / 30.0f;
        path.moveTo(x - offset + size * 2.0f / 3.0f, y + offset * 2.0f);
        path.lineTo(x - offset + size * 2.0f / 3.0f, y - offset * 2.0f / 3.0f + size / 2.0f);
        path.lineTo((double)(x - offset + size * 2.0f / 3.0f - size / 7.0f), (double)y - (double)offset * 3.2 + (double)(size / 2.0f));
        path.lineTo((double)(x - offset + size * 2.0f / 3.0f - size / 7.0f), (double)y + (double)offset * 6.2);
    }

    private static void middle(Path2D.Float path, float size, float x, float y) {
        float offset = size / 30.0f;
        path.moveTo(x + offset + size / 21.0f, y + size / 2.0f);
        path.lineTo((double)x + (double)offset * 6.2, (double)y - (double)offset * 2.2 + (double)(size / 2.0f));
        path.lineTo((double)x - (double)offset * 6.2 + (double)(size * 2.0f / 3.0f), (double)y - (double)offset * 2.2 + (double)(size / 2.0f));
        path.lineTo(x - offset - size / 21.0f + size * 2.0f / 3.0f, y + size / 2.0f);
        path.lineTo((double)x - (double)offset * 6.2 + (double)(size * 2.0f / 3.0f), (double)y + (double)offset * 2.2 + (double)(size / 2.0f));
        path.lineTo((double)x + (double)offset * 6.2, (double)y + (double)offset * 2.2 + (double)(size / 2.0f));
    }

    private static void bottomLeft(Path2D.Float path, float size, float x, float y) {
        float offset = size / 30.0f;
        path.moveTo(x + offset, y + offset * 2.0f / 3.0f + size / 2.0f);
        path.lineTo(x + offset, y - offset * 2.0f + size);
        path.lineTo((double)(x + offset + size / 7.0f), (double)y - (double)offset * 6.2 + (double)size);
        path.lineTo((double)(x + offset + size / 7.0f), (double)y + (double)offset * 3.2 + (double)(size / 2.0f));
    }

    private static void bottomRight(Path2D.Float path, float size, float x, float y) {
        float offset = size / 30.0f;
        path.moveTo(x - offset + size * 2.0f / 3.0f, y + offset * 2.0f / 3.0f + size / 2.0f);
        path.lineTo(x - offset + size * 2.0f / 3.0f, y - offset * 2.0f + size);
        path.lineTo((double)(x - offset + size * 2.0f / 3.0f - size / 7.0f), (double)y - (double)offset * 6.2 + (double)size);
        path.lineTo((double)(x - offset + size * 2.0f / 3.0f - size / 7.0f), (double)y + (double)offset * 3.2 + (double)(size / 2.0f));
    }

    private static void bottom(Path2D.Float path, float size, float x, float y) {
        float offset = size / 30.0f;
        path.moveTo(x + offset * 2.0f, y - offset + size);
        path.lineTo(x - offset * 2.0f + size * 2.0f / 3.0f, y - offset + size);
        path.lineTo((double)x - (double)offset * 6.2 + (double)(size * 2.0f / 3.0f), (double)(y - offset + size * 6.0f / 7.0f));
        path.lineTo((double)x + (double)offset * 6.2, (double)(y - offset + size * 6.0f / 7.0f));
    }
}

