/*
 * Decompiled with CFR 0.152.
 */
package rubikscube.gui.utils;

import java.awt.Color;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;

public class Tools3D {
    public static void replaceAppearance(Node node, Appearance ap) {
        try {
            Group group = (Group)node;
            Enumeration e = group.getAllChildren();
            while (e.hasMoreElements()) {
                Tools3D.replaceAppearance((Node)e.nextElement(), ap);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            Shape3D shape = (Shape3D)node;
            ap.setCapability(3);
            ap.setCapability(5);
            shape.setAppearance(ap);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static void setCapabilities(Node node) {
        try {
            Group group = (Group)node;
            Enumeration e = group.getAllChildren();
            while (e.hasMoreElements()) {
                Tools3D.setCapabilities((Node)e.nextElement());
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            Shape3D shape = (Shape3D)node;
            Appearance ap = shape.getAppearance();
            RenderingAttributes ra = ap.getRenderingAttributes();
            ColoringAttributes ca = ap.getColoringAttributes();
            if (ra == null) {
                ra = new RenderingAttributes();
                ap.setRenderingAttributes(ra);
            }
            if (ca == null) {
                ca = new ColoringAttributes();
                ap.setColoringAttributes(ca);
            }
            shape.setCapability(14);
            shape.setCapability(15);
            ap.setCapability(12);
            ap.setCapability(13);
            ra.setCapability(4);
            ra.setCapability(11);
            ra.setCapability(9);
            ra.setCapability(10);
            ca.setCapability(0);
            ca.setCapability(1);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static void setDepthBufferEnable(boolean b, Node node) {
        try {
            Group group = (Group)node;
            Enumeration e = group.getAllChildren();
            while (e.hasMoreElements()) {
                Tools3D.setDepthBufferEnable(b, (Node)e.nextElement());
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            Shape3D shape = (Shape3D)node;
            RenderingAttributes ra = shape.getAppearance().getRenderingAttributes();
            ra.setDepthBufferEnable(b);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static Color3f getColor3f(Color color) {
        return new Color3f(color);
    }

    public static Color4f getColor4f(Color color) {
        return new Color4f(color);
    }

    public static Appearance getAppearance(Color color) {
        return Tools3D.getAppearance(new Color3f(color));
    }

    public static Appearance getAppearance(Color3f color) {
        Color color2d = color.get();
        Color3f black = Tools3D.getColor3f(Color.BLACK);
        Color3f color2 = Tools3D.getColor3f(new Color((int)((float)color2d.getRed() * 0.75f), (int)((float)color2d.getGreen() * 0.75f), (int)((float)color2d.getBlue() * 0.75f)));
        Appearance ap = new Appearance();
        Material mat = new Material(color2, black, color, black, 70.0f);
        mat.setCapability(0);
        mat.setCapability(1);
        ap.setMaterial(mat);
        ColoringAttributes ca = new ColoringAttributes(color, 1);
        ca.setCapability(0);
        ca.setCapability(1);
        ap.setColoringAttributes(ca);
        return ap;
    }

    public static void changeAppearance(Appearance ap, Color color) {
        Tools3D.changeAppearance(ap, new Color3f(color));
    }

    public static void changeAppearance(Appearance ap, Color3f color) {
        Color color2d = color.get();
        Color3f color2 = Tools3D.getColor3f(new Color((int)((float)color2d.getRed() * 0.75f), (int)((float)color2d.getGreen() * 0.75f), (int)((float)color2d.getBlue() * 0.75f)));
        Material mat = ap.getMaterial();
        mat.setAmbientColor(color2);
        mat.setDiffuseColor(color);
        ap.getColoringAttributes().setColor(color);
    }
}

