/*
 * Decompiled with CFR 0.152.
 */
package sinuous;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class Sinuous
extends JPanel {
    private Window owner;
    private Thread gameLoop;
    private Thread dotSpawner;
    private Thread repainter;
    private Thread mouseLocator;
    private boolean run = true;
    private boolean onlyInView = true;
    private int sleep = 1;
    private Random r = new Random();
    private Rectangle screenBounds = new Rectangle();
    private Rectangle gameBounds = new Rectangle();
    private final List<Dot> dots = new ArrayList<Dot>();
    private final List<Maelstrom> maelstroms = new ArrayList<Maelstrom>();
    private final Point mouseLoc = new Point();
    private final List<Double> mouseX = new ArrayList<Double>();
    private final List<Double> mouseY = new ArrayList<Double>();
    private final List<Long> mouseStamps = new ArrayList<Long>();
    private double spawnRate = 20.0;
    private Color playerDot = new Color(0, 50, 255);
    private Color[] dotColors = new Color[]{new Color(255, 20, 20), new Color(0, 150, 150), new Color(255, 200, 0)};

    public Sinuous(Window own) {
        this.owner = own;
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        this.screenBounds.setBounds(gds[0].getDefaultConfiguration().getBounds());
        this.screenBounds.width = this.screenBounds.x + this.screenBounds.width;
        this.screenBounds.height = this.screenBounds.y + this.screenBounds.height;
        for (int i = 1; i < gds.length; ++i) {
            Rectangle gdb = gds[i].getDefaultConfiguration().getBounds();
            if (gdb.x < this.screenBounds.x) {
                this.screenBounds.x = gdb.x;
            }
            if (gdb.y < this.screenBounds.y) {
                this.screenBounds.y = gdb.y;
            }
            if (gdb.x + gdb.width > this.screenBounds.width) {
                this.screenBounds.width = gdb.x + gdb.width;
            }
            if (gdb.y + gdb.height <= this.screenBounds.height) continue;
            this.screenBounds.width = gdb.y + gdb.height;
        }
        this.screenBounds.width -= this.screenBounds.x;
        this.screenBounds.height -= this.screenBounds.y;
        if (!this.onlyInView) {
            this.gameBounds.setBounds(this.screenBounds);
        }
        this.gameLoop = new Thread(){
            private long now;
            private long start;
            private Double[] mX;
            private Double[] mY;
            private Long[] mS;
            private double tX;
            private double tY;
            private Dot[] ds;
            private Maelstrom[] ms;
            private Rectangle gB = new Rectangle();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (Sinuous.this.run) {
                        int i;
                        int i2;
                        this.start = System.nanoTime();
                        this.now = System.currentTimeMillis();
                        Point point = Sinuous.this.mouseLoc;
                        synchronized (point) {
                            this.mX = new Double[Sinuous.this.mouseX.size()];
                            Sinuous.this.mouseX.toArray(this.mX);
                            this.mY = new Double[Sinuous.this.mouseY.size()];
                            Sinuous.this.mouseY.toArray(this.mY);
                            this.mS = new Long[Sinuous.this.mouseStamps.size()];
                            Sinuous.this.mouseStamps.toArray(this.mS);
                            this.tX = ((Sinuous)Sinuous.this).mouseLoc.x;
                            this.tY = ((Sinuous)Sinuous.this).mouseLoc.y;
                        }
                        for (int i3 = 1; i3 < this.mX.length; ++i3) {
                            if (this.now - this.mS[i3] >= 500L) {
                                this.mS[i3] = Long.MAX_VALUE;
                                continue;
                            }
                            Double[] doubleArray = this.mX;
                            int n = i3;
                            Double.valueOf(doubleArray[n] + -100.0 / (double)(1000 / Sinuous.this.sleep));
                            doubleArray = this.mY;
                            n = i3;
                            Double.valueOf(doubleArray[n] + 100.0 / (double)(1000 / Sinuous.this.sleep));
                        }
                        if (this.mS.length > 0) {
                            double w = this.tX - this.mX[0];
                            double h = this.tY - this.mY[0];
                            if (w != 0.0 || h != 0.0) {
                                double len = Math.sqrt(w * w + h * h);
                                double nW = len / 100.0 * (double)Sinuous.this.sleep * w / len;
                                double nH = len / 100.0 * (double)Sinuous.this.sleep * h / len;
                                this.tX = this.mX[0] + nW;
                                this.tY = this.mY[0] + nH;
                            }
                        }
                        Object w = Sinuous.this.mouseLoc;
                        synchronized (w) {
                            for (int i4 = this.mS.length - 1; i4 >= 0; --i4) {
                                if (this.mS[i4] == Long.MAX_VALUE) {
                                    Sinuous.this.mouseX.remove(i4);
                                    Sinuous.this.mouseY.remove(i4);
                                    Sinuous.this.mouseStamps.remove(i4);
                                    continue;
                                }
                                Sinuous.this.mouseX.set(i4, this.mX[i4]);
                                Sinuous.this.mouseY.set(i4, this.mY[i4]);
                            }
                            Sinuous.this.mouseX.add(0, this.tX);
                            Sinuous.this.mouseY.add(0, this.tY);
                            Sinuous.this.mouseStamps.add(0, this.now);
                        }
                        w = Sinuous.this.dots;
                        synchronized (w) {
                            this.ds = new Dot[Sinuous.this.dots.size()];
                            Sinuous.this.dots.toArray(this.ds);
                        }
                        w = Sinuous.this.maelstroms;
                        synchronized (w) {
                            this.ms = new Maelstrom[Sinuous.this.maelstroms.size()];
                            Sinuous.this.maelstroms.toArray(this.ms);
                        }
                        w = Sinuous.this.gameBounds;
                        synchronized (w) {
                            this.gB.setBounds(Sinuous.this.gameBounds);
                        }
                        for (int i5 = 0; i5 < this.ds.length; ++i5) {
                            double col = 5.0 + this.ds[i5].dia / 2.0;
                            double xDist = this.ds[i5].x - this.tX;
                            double yDist = this.ds[i5].y - this.tY;
                            if (!(xDist < col) && !(yDist < col) || !(xDist * xDist + yDist * yDist < col * col)) continue;
                            this.ds[i5].dia = 20.0;
                        }
                        for (Maelstrom maelstrom : this.ms) {
                            for (int i6 = 0; i6 < this.ds.length; ++i6) {
                                double xDist = maelstrom.x - this.ds[i6].x;
                                double yDist = maelstrom.y - this.ds[i6].y;
                                double dist2 = xDist * xDist + yDist * yDist;
                                double col2 = Math.pow(maelstrom.radius, 2.0);
                                if (!(dist2 < col2)) continue;
                                double rads = Math.atan2(yDist, xDist);
                                this.ds[i6].xvel = Math.cos(this.ds[i6].rad) * this.ds[i6].vel + Math.cos(rads) * maelstrom.radius / 2.0 * Math.pow(1.0 - dist2 / col2, 4.0) / (double)(1000 / Sinuous.this.sleep);
                                this.ds[i6].yvel = Math.sin(this.ds[i6].rad) * this.ds[i6].vel + Math.sin(rads) * maelstrom.radius / 2.0 * Math.pow(1.0 - dist2 / col2, 4.0) / (double)(1000 / Sinuous.this.sleep);
                                this.ds[i6].rad = Math.atan2(this.ds[i6].yvel, this.ds[i6].xvel);
                                this.ds[i6].vel = Math.sqrt(Math.pow(this.ds[i6].xvel, 2.0) + Math.pow(this.ds[i6].yvel, 2.0));
                            }
                        }
                        for (i2 = 0; i2 < this.ds.length; ++i2) {
                            this.ds[i2].x += this.ds[i2].xvel / (double)(1000 / Sinuous.this.sleep);
                            this.ds[i2].y += this.ds[i2].yvel / (double)(1000 / Sinuous.this.sleep);
                            if (!(this.ds[i2].x < (double)this.gB.x - this.ds[i2].dia || this.ds[i2].x > (double)(this.gB.x + this.gB.width) + this.ds[i2].dia || this.ds[i2].y < (double)this.gB.y - this.ds[i2].dia) && !(this.ds[i2].y > (double)(this.gB.y + this.gB.height) + this.ds[i2].dia)) continue;
                            this.ds[i2] = null;
                        }
                        for (i2 = 0; i2 < this.ms.length; ++i2) {
                            this.ms[i2].x += this.ms[i2].xvel / (double)(1000 / Sinuous.this.sleep);
                            this.ms[i2].y += this.ms[i2].yvel / (double)(1000 / Sinuous.this.sleep);
                            if (!(this.ms[i2].x < (double)this.gB.x - this.ms[i2].dia || this.ms[i2].x > (double)(this.gB.x + this.gB.width) + this.ms[i2].dia || this.ms[i2].y < (double)this.gB.y - this.ms[i2].dia) && !(this.ms[i2].y > (double)(this.gB.y + this.gB.height) + this.ms[i2].dia)) continue;
                            this.ms[i2] = null;
                        }
                        List i7 = Sinuous.this.dots;
                        synchronized (i7) {
                            for (i = this.ds.length - 1; i >= 0; --i) {
                                if (this.ds[i] != null) continue;
                                Sinuous.this.dots.remove(i);
                            }
                        }
                        i7 = Sinuous.this.maelstroms;
                        synchronized (i7) {
                            for (i = this.ms.length - 1; i >= 0; --i) {
                                if (this.ms[i] != null) continue;
                                Sinuous.this.maelstroms.remove(i);
                            }
                        }
                        int time = (int)Math.rint((double)Sinuous.this.sleep - (double)(System.nanoTime() - this.start) / 1.0E7);
                        if (time > 0) {
                            Thread.sleep(time);
                            continue;
                        }
                        Thread.sleep(1L);
                    }
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Sinuous.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.dotSpawner = new Thread(){
            private double lastCreate;
            private long now;
            private long start;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.lastCreate = System.currentTimeMillis();
                    while (Sinuous.this.run) {
                        this.start = System.nanoTime();
                        this.now = System.currentTimeMillis();
                        if (Sinuous.this.spawnRate == 0.0) {
                            this.lastCreate = this.now;
                        } else {
                            while ((double)this.now - this.lastCreate >= 1000.0 / Sinuous.this.spawnRate) {
                                this.lastCreate += 1000.0 / Sinuous.this.spawnRate;
                                Dot dot = new Dot();
                                dot.x = (double)(((Sinuous)Sinuous.this).gameBounds.width + ((Sinuous)Sinuous.this).gameBounds.height) * Sinuous.this.r.nextDouble();
                                if (dot.x >= (double)((Sinuous)Sinuous.this).gameBounds.width) {
                                    dot.y = dot.x - (double)((Sinuous)Sinuous.this).gameBounds.width;
                                    dot.x = ((Sinuous)Sinuous.this).gameBounds.width - 1;
                                } else {
                                    dot.y = 0.0;
                                }
                                dot.x += (double)((Sinuous)Sinuous.this).gameBounds.x;
                                dot.y += (double)((Sinuous)Sinuous.this).gameBounds.y;
                                dot.x += dot.dia;
                                dot.y -= dot.dia;
                                dot.vel = 100.0 + 100.0 * Sinuous.this.r.nextDouble();
                                dot.rad = Math.toRadians(130.0 + 10.0 * Sinuous.this.r.nextDouble());
                                dot.xvel = Math.cos(dot.rad) * dot.vel;
                                dot.yvel = Math.sin(dot.rad) * dot.vel;
                                if (Sinuous.this.r.nextDouble() < 0.01) {
                                    dot.dia = 15.0 + 7.0 * Sinuous.this.r.nextDouble();
                                    Maelstrom mael = new Maelstrom(dot);
                                    mael.radius = 75 + Sinuous.this.r.nextInt(150);
                                    List list = Sinuous.this.maelstroms;
                                    synchronized (list) {
                                        Sinuous.this.maelstroms.add(mael);
                                        continue;
                                    }
                                }
                                dot.dia = 7.0 + 3.0 * Sinuous.this.r.nextDouble();
                                List list = Sinuous.this.dots;
                                synchronized (list) {
                                    Sinuous.this.dots.add(dot);
                                }
                            }
                        }
                        int time = (int)Math.rint((double)Sinuous.this.sleep - (double)(System.nanoTime() - this.start) / 1.0E7);
                        if (time > 0) {
                            Thread.sleep(time);
                            continue;
                        }
                        Thread.sleep(1L);
                    }
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Sinuous.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.repainter = new Thread(){

            @Override
            public void run() {
                try {
                    while (Sinuous.this.run) {
                        Sinuous.this.repaint();
                        Thread.sleep(16L);
                    }
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Sinuous.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent e) {
                if (Sinuous.this.onlyInView) {
                    Rectangle rectangle = Sinuous.this.gameBounds;
                    synchronized (rectangle) {
                        Sinuous.this.gameBounds.setBounds(Sinuous.this.getBounds());
                        Sinuous.this.gameBounds.setLocation(Sinuous.this.getLocationOnScreen());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentMoved(ComponentEvent e) {
                if (Sinuous.this.onlyInView) {
                    Rectangle rectangle = Sinuous.this.gameBounds;
                    synchronized (rectangle) {
                        Sinuous.this.gameBounds.setBounds(Sinuous.this.getBounds());
                        Sinuous.this.gameBounds.setLocation(Sinuous.this.getLocationOnScreen());
                    }
                }
            }
        });
        this.owner.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentMoved(ComponentEvent e) {
                if (Sinuous.this.onlyInView) {
                    Rectangle rectangle = Sinuous.this.gameBounds;
                    synchronized (rectangle) {
                        Sinuous.this.gameBounds.setBounds(Sinuous.this.getBounds());
                        Sinuous.this.gameBounds.setLocation(Sinuous.this.getLocationOnScreen());
                    }
                }
            }
        });
        this.mouseLocator = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (Sinuous.this.run) {
                        Point point = Sinuous.this.mouseLoc;
                        synchronized (point) {
                            Sinuous.this.mouseLoc.setLocation(MouseInfo.getPointerInfo().getLocation());
                        }
                        Thread.sleep(Sinuous.this.sleep);
                    }
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Sinuous.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.repainter.start();
        this.mouseLocator.start();
    }

    public void start() {
        this.gameLoop.start();
        this.dotSpawner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Maelstrom[] maelTemp;
        Dot[] dotTemp;
        Double[] yTemp;
        Double[] xTemp;
        long start = System.nanoTime();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setColor(new Color(30, 30, 30));
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        Point loc = new Point();
        if (this.onlyInView) {
            Rectangle rectangle = this.gameBounds;
            synchronized (rectangle) {
                loc.setLocation(this.gameBounds.getLocation());
            }
        } else {
            loc.setLocation(this.getLocationOnScreen());
        }
        g2d.setColor(this.playerDot);
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(1.5f));
        Point point = this.mouseLoc;
        synchronized (point) {
            xTemp = new Double[this.mouseX.size()];
            this.mouseX.toArray(xTemp);
            yTemp = new Double[this.mouseY.size()];
            this.mouseY.toArray(yTemp);
        }
        Path2D.Double path = new Path2D.Double();
        if (xTemp.length > 0) {
            path.moveTo(xTemp[xTemp.length - 1] - (double)loc.x, yTemp[yTemp.length - 1] - (double)loc.y);
            for (int i = xTemp.length - 1; i >= 0; --i) {
                path.lineTo(xTemp[i] - (double)loc.x, yTemp[i] - (double)loc.y);
            }
            g2d.draw(path);
            path.reset();
            path.append(new Ellipse2D.Double(xTemp[0] - 5.0 - (double)loc.x, yTemp[0] - 5.0 - (double)loc.y, 10.0, 10.0), false);
            g2d.fill(path);
            g2d.setColor(this.playerDot.brighter().brighter().brighter());
            g2d.draw(path);
        }
        g2d.setStroke(oldStroke);
        List<Dot> list = this.dots;
        synchronized (list) {
            dotTemp = new Dot[this.dots.size()];
            this.dots.toArray(dotTemp);
        }
        g2d.setColor(this.dotColors[0]);
        for (int i = 0; i < dotTemp.length; ++i) {
            path.reset();
            path.append(new Ellipse2D.Double(dotTemp[i].x - dotTemp[i].dia / 2.0 - (double)loc.x, dotTemp[i].y - dotTemp[i].dia / 2.0 - (double)loc.y, dotTemp[i].dia, dotTemp[i].dia), false);
            g2d.fill(path);
        }
        List<Maelstrom> list2 = this.maelstroms;
        synchronized (list2) {
            maelTemp = new Maelstrom[this.maelstroms.size()];
            this.maelstroms.toArray(maelTemp);
        }
        g2d.setColor(this.dotColors[1]);
        for (int i = 0; i < maelTemp.length; ++i) {
            path.reset();
            path.append(new Ellipse2D.Double(maelTemp[i].x - maelTemp[i].dia / 2.0 - (double)loc.x, maelTemp[i].y - maelTemp[i].dia / 2.0 - (double)loc.y, maelTemp[i].dia, maelTemp[i].dia), false);
            g2d.fill(path);
            path.reset();
            path.append(new Ellipse2D.Double(maelTemp[i].x - maelTemp[i].radius / 2.0 - (double)loc.x, maelTemp[i].y - maelTemp[i].radius / 2.0 - (double)loc.y, maelTemp[i].radius, maelTemp[i].radius), false);
            g2d.draw(path);
        }
        g2d.setColor(new Color(80, 80, 80));
        g2d.fillRect(0, 0, 7, this.getHeight());
        g2d.fillRect(this.getWidth() - 7, 0, 7, this.getHeight());
        g2d.fillRect(0, 0, this.getWidth(), 7);
        g2d.fillRect(0, this.getHeight() - 7, this.getWidth(), 7);
        String nDots = "Number of dots: " + this.dots.size();
        String updateMs = "Update ms: " + (double)(System.nanoTime() - start) / 1.0E7;
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D nDotsBounds = fm.getStringBounds(nDots, g);
        Rectangle2D updateMsBounds = fm.getStringBounds(updateMs, g);
        int pad = 5;
        Rectangle2D.Double sBounds = new Rectangle2D.Double(0.0, 0.0, (double)pad + (nDotsBounds.getWidth() > updateMsBounds.getWidth() ? nDotsBounds.getWidth() : updateMsBounds.getWidth()) + (double)pad, (double)pad + nDotsBounds.getHeight() + (double)pad + updateMsBounds.getHeight() + (double)pad);
        g2d.setColor(new Color(50, 50, 150, 150));
        g2d.fillRoundRect(7, 7, (int)Math.rint(((RectangularShape)sBounds).getWidth()), (int)Math.rint(((RectangularShape)sBounds).getHeight()), pad * 2, pad * 2);
        g2d.setColor(new Color(50, 50, 150));
        g2d.drawRoundRect(7, 7, (int)Math.rint(((RectangularShape)sBounds).getWidth()), (int)Math.rint(((RectangularShape)sBounds).getHeight()), pad * 2, pad * 2);
        g2d.setColor(Color.WHITE);
        int sY = 7 + pad + fm.getMaxAscent();
        g2d.drawString(nDots, 7 + pad, sY);
        g2d.drawString(updateMs, 7 + pad, sY += pad + fm.getMaxAscent());
    }

    public double getSpawnRate() {
        return this.spawnRate;
    }

    public void setSpawnRate(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.spawnRate = d;
    }

    public boolean getOnlyInView() {
        return this.onlyInView;
    }

    public void setOnlyInView(boolean b) {
        this.onlyInView = b;
        if (b) {
            this.gameBounds.setBounds(this.getBounds());
            this.gameBounds.setLocation(this.getLocationOnScreen());
        } else {
            this.gameBounds.setBounds(this.screenBounds);
        }
    }

    private class Maelstrom
    extends Dot {
        double radius;

        public Maelstrom(Dot dot) {
            this.radius = 0.0;
            this.x = dot.x;
            this.y = dot.y;
            this.dia = dot.dia;
            this.vel = dot.vel;
            this.rad = dot.rad;
            this.xvel = dot.xvel;
            this.yvel = dot.yvel;
        }
    }

    private class Dot {
        double x = 0.0;
        double y = 0.0;
        double dia = 0.0;
        double vel = 0.0;
        double rad = 0.0;
        double xvel = 0.0;
        double yvel = 0.0;

        private Dot() {
        }
    }
}

