﻿// See https://aka.ms/new-console-template for more information

using System.Reflection;
using System.Runtime.CompilerServices;
using System.Runtime.Loader;

const string ExePath = @"C:\Program Files (x86)\Steam\steamapps\common\Dave the Diver\DaveTheDiver.exe";
RunDynamicLoader(ExePath, out var weakRef);

//var lastAsses = AppDomain.CurrentDomain.GetAssemblies().Select(a => a.GetName().Name).ToHashSet();
var lastAsses = new HashSet<string>();
for (var i = 0; i < 10 && TryUseRef(weakRef, ctx =>
{
    var asses = AppDomain.CurrentDomain.GetAssemblies().Select(a => a.GetName().Name).ToHashSet();
    string gone = "";
    if (lastAsses.Count > 0)
    {
        lastAsses.ExceptWith(asses);
        gone = string.Join("\n\t", lastAsses.OrderBy(x => x));
        if (!string.IsNullOrEmpty(gone))
            gone = "\n\t" + gone;
        }
    lastAsses = asses;
    Log($"Unloading try {i + 1}/10 {ctx.GetType().Name}[name={ctx.Name ?? "null"}]: "
        + $"ctxAssemblies=[{ctx.Assemblies.Count()}], "
        + $"appAssemblies=[{asses.Count}]{gone}");
})
        ; i++)
{
    GC.Collect();
    GC.WaitForPendingFinalizers();
}
if (TryUseRef(weakRef, ctx =>
        Log($"{ctx.GetType().Name}[name={ctx.Name ?? "null"}] did not unload correctly: "
            + $"ctxAssemblies=[{ctx.Assemblies.Count()}], "
            + $"appAssemblies=[{AppDomain.CurrentDomain.GetAssemblies().Length}]")))
    return;

static void Log(string msg)
{
    Console.WriteLine($"[{DateTime.Now:HH\\:mm\\:ss\\.fff}] {msg}");
}

[MethodImpl(MethodImplOptions.NoInlining)]
static bool TryUseRef<T>(WeakReference<T> weakRef, Action<T> action) where T : class
{
    if (!weakRef.TryGetTarget(out var obj))
        return false;
    action(obj);
    return true;
}

const string BasePluginName = "BepInEx.Unity.IL2CPP.BasePlugin";

[MethodImpl(MethodImplOptions.NoInlining)]
static void RunDynamicLoader(string exePath, out WeakReference<AssemblyLoadContext> weakRef)
{
    var ctx = new BepInExLoadContext(exePath);
    weakRef = new WeakReference<AssemblyLoadContext>(ctx, true);

    var a_dynamicLoader = ctx.LoadFromAssemblyName(new AssemblyName("DynamicLoader"));
    var t_plugin = a_dynamicLoader.GetExportedTypes()
        .FirstOrDefault(t => t.BaseType?.FullName == BasePluginName);
    if (t_plugin == null)
        throw new ArgumentNullException(nameof(t_plugin), $"Could not find any {BasePluginName}");
    var plugin = Activator.CreateInstance(t_plugin, new[] { new Action<string>(Log) });

    var m_load = t_plugin.GetMethod("Load");
    if (m_load == null)
        throw new ArgumentNullException(nameof(m_load), "Could not find Load()");
    var load = m_load.CreateDelegate<BasePlugin_Load>(plugin);

    load();
    ctx.Unload();
}

delegate void BasePlugin_Load();