﻿using System.Reflection;
using System.Runtime.Loader;

namespace DynamicLoader;

public class ChainedLoadContext : AssemblyLoadContext
{
    public AssemblyLoadContext Context { get; }
    public ChainedLoadContext(string name, AssemblyLoadContext ctx, bool isCollectible = false) : base(name, isCollectible: isCollectible)
    {
        Context = ctx;
    }

    protected override Assembly Load(AssemblyName assemblyName)
    {
        var result = Context.LoadFromAssemblyName(assemblyName);
        if (result != null)
            return result;
        return null;
    }
}
