﻿using BepInEx;
using BepInEx.Logging;
using BepInEx.Unity.IL2CPP;
using HarmonyLib;
using Il2CppInterop.Runtime.Injection;
using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using UnityEngine;

namespace TestPlugin;

[BepInPlugin(MyPluginInfo.PLUGIN_GUID, MyPluginInfo.PLUGIN_NAME, MyPluginInfo.PLUGIN_VERSION)]
public class Plugin : BasePlugin
{
    private static FieldInfo f_managerGo = AppDomain.CurrentDomain.GetAssemblies()
        .First(ass => ass.GetName().Name == "BepInEx.Unity.IL2CPP")
        .GetTypes()
        .First(t => t.FullName == "BepInEx.Unity.IL2CPP.Utils.Il2CppUtils")
        .GetField("managerGo", BindingFlags.NonPublic | BindingFlags.Static);

    private static readonly Harmony patches = new Harmony(MyPluginInfo.PLUGIN_GUID);
    public static new ManualLogSource Log { get; private set; }

    private GameObject managerGo;
    private PluginBehaviour behaviour;

    private static Type FindType(string fullName)
    {
        return AppDomain.CurrentDomain.GetAssemblies()
            .SelectMany(ass => ass.GetTypes())
            .First(t => t.FullName == fullName);
    }

    public override void Load()
    {
        Log = base.Log;
        Log.LogInfo($"Plugin {MyPluginInfo.PLUGIN_GUID} patching...");
        patches.PatchAll();
        Log.LogInfo($"Plugin {MyPluginInfo.PLUGIN_GUID} patched!");
        try
        {
            f_managerGo.SetValue(null, null);
            Log.LogInfo($"Plugin {MyPluginInfo.PLUGIN_GUID} AddComponent...");
            behaviour = AddComponent<PluginBehaviour>();
            Log.LogInfo($"Plugin {MyPluginInfo.PLUGIN_GUID} AddComponent!");
            managerGo = (GameObject) f_managerGo.GetValue(null);
            Log.LogInfo($"Plugin {MyPluginInfo.PLUGIN_GUID} is loaded!");
        }
        catch
        {
            patches.UnpatchSelf();
        }
    }

    public override bool Unload()
    {
        if (behaviour != null)
        {
            UnityEngine.Object.DestroyImmediate(behaviour);
            behaviour = null;
        }
        if (managerGo != null)
        {
            UnityEngine.Object.DestroyImmediate(managerGo);
            if (f_managerGo.GetValue(null) == managerGo)
                f_managerGo.SetValue(null, null);
            managerGo = null;
        }

        // behövs för att recompila samma assembly igen
        {
            var injectedTypes = Traverse.Create(typeof(ClassInjector))
                .Field<HashSet<string>>("InjectedTypes")
                .Value;
            var removedInjectedTypes = typeof(Plugin).Assembly
                .GetTypes()
                .Where(t => injectedTypes.Remove(t.FullName))
                .ToList();
            var nativePtr = Il2CppInterop.Runtime.Il2CppClassPointerStore.GetNativeClassPointer(typeof(PluginBehaviour));
            Log.LogError("ptr: " + nativePtr.ToString() + ", injected: " + string.Join(", ", removedInjectedTypes.Select(t => t.FullDescription())));

            //internal static readonly Dictionary<(string _namespace, string _class, IntPtr imagePtr), IntPtr> s_ClassNameLookup = new();
            var s_ClassNameLookup = Traverse.Create(FindType("Il2CppInterop.Runtime.Injection.InjectorHelpers"))
                .Field<Dictionary<(string _namespace, string _class, IntPtr imagePtr), IntPtr>>("s_ClassNameLookup")
                .Value;
            var ourTypeNames = typeof(Plugin).Assembly
                .GetTypes()
                .Select(t => (t.Namespace ?? string.Empty, t.Name))
                .ToHashSet();
            var ourLookups = s_ClassNameLookup
                .Where(kv => ourTypeNames
                    .Contains((kv.Key._namespace, kv.Key._class)))
                .ToList();
            foreach (var kv in ourLookups)
                s_ClassNameLookup.Remove(kv.Key);
            Log.LogError("lookup\n" + string.Join("\n", ourLookups));
        }

        //internal static readonly Dictionary<IntPtr, (MethodInfo, Dictionary<IntPtr, IntPtr>)> InflatedMethodFromContextDictionary = new();
        var inflatedMethodFromContextDictionary = Traverse.Create(typeof(ClassInjector))
            .Field<Dictionary<IntPtr, (MethodInfo, Dictionary<IntPtr, IntPtr>)>>("InflatedMethodFromContextDictionary")
            .Value;
        var ourInflatedMethods = inflatedMethodFromContextDictionary
            .Where(kv => kv.Value.Item1.DeclaringType.Assembly == typeof(Plugin).Assembly)
            .ToList();
        foreach (var kv in ourInflatedMethods)
            inflatedMethodFromContextDictionary.Remove(kv.Key);
        Log.LogError("inflatedMethods\n" + string.Join("\n", ourInflatedMethods.Select(kv => kv.Value.Item1.FullDescription())));

        //private static readonly ConcurrentDictionary<(Type type, FieldAttributes attrs), IntPtr> _injectedFieldTypes = new();
        var injectedFieldTypes = Traverse.Create(typeof(ClassInjector))
            .Field<ConcurrentDictionary<(Type type, FieldAttributes attrs), IntPtr>>("_injectedFieldTypes")
            .Value;
        var ourTypes = typeof(Plugin).Assembly
            .GetTypes()
            .ToHashSet();
        var ourInjectedFields = injectedFieldTypes
            .Where(kv => kv.Key.type.IsGenericType)
            .Where(kv => kv.Key.type.GenericTypeArguments.Any(gen => ourTypes.Contains(gen)))
            .ToList();
        foreach (var kv in ourInjectedFields)
            injectedFieldTypes.TryRemove(kv.Key, out var _);
        Log.LogError("injectedFieldTypes\n" + string.Join("\n", ourInjectedFields.Select(kv => kv.Key.type.FullDescription())));

    Log.LogInfo($"Plugin {MyPluginInfo.PLUGIN_GUID} is unloaded!");
        return base.Unload();
    }
}

public class PluginBehaviour : MonoBehaviour
{
    public PluginBehaviour(IntPtr ptr) : base(ptr) { }
    public PluginBehaviour() : base(ClassInjector.DerivedConstructorPointer<PluginBehaviour>())
    {
        ClassInjector.DerivedConstructorBody(this);
    }

    public void Awake()
    {
        Plugin.Log.LogInfo($"Behaviour awake WOOOOWOWOWOOOWOWO");
        //Tjenna(123123);
    }

    /*
    public void OnDestroy()
    {
        Plugin.Log.LogInfo($"Behaviour destroy");
    }
    */

    /*
    public void Tjenna<T>(T obj)
    {
        Plugin.Log.LogInfo("TJENNA " + obj.ToString());
    }
    */
}

