﻿;
(function ($, window, document, app) {
    'use strict';

    var model = app.namespace('app'),
        defaults = {};

    model.TypeFast = function (options) {
        this.options = $.extend({}, defaults, options);
        this.wordList = this.options.wordList;
        this.$words = $('.words').find('span');
        this.$wordForm = $('#type-fast-form');
        this.$wordInput = this.$wordForm.find('#word');
        this.wordCounter = 0;
        this.ajaxService = new app.service.Ajax();
        this.timerStarted = false;
        this.$scoreModal = $('#submit-score-modal');
        this.$scoreForm = this.$scoreModal.find('#submit-score-form');
        this.$highscoreModal = $('#highscore-modal');
        this.currentPoints = 0;
    };

    model.TypeFast.prototype.init = function () {
        this.$wordInput.focus();
        this.$wordInput.keydown(this.interceptSpace.bind(this));
        this.$wordInput.keyup(this.startTimer.bind(this));
        
        $(this.$words[this.wordCounter]).addClass('highlight');
        this.$wordForm.on('submit', this.submitWordForm.bind(this));
        this.$scoreForm.on('submit', this.submitScoreForm.bind(this));
    };

    model.TypeFast.prototype.submitWordForm = function (e) {
        e.preventDefault();
        var url = this.$wordForm[0].action + '?' + this.$wordForm.serialize();

        this.highlightCurrentWord();
        this.markWordAsRightOrWrong();
        this.hideShowChunks();
        this.$wordInput.val('');

        this.ajaxService.getAsync(url)
            .done(function (data) {
                this.currentPoints = data.totalCorrectWords;
            }.bind(this))
            .fail(function (error) {

            }.bind(this))
            .always(function () {

            }.bind(this));
    };

    model.TypeFast.prototype.hideShowChunks = function () {
        if (this.wordCounter % 5 === 0) {
            var chunkNrToHide = this.wordCounter / 5;
            $('#chunk' + chunkNrToHide).hide();
            var chunkNrToShow = chunkNrToHide + 2;
            $('#chunk' + chunkNrToShow).show();
        }
    }

    model.TypeFast.prototype.markWordAsRightOrWrong = function () {
        var currentWord = this.wordList[0];
        var $currentWord = $('#' + currentWord + this.wordCounter);
        if (currentWord === this.$wordInput.val()) {
            $currentWord.addClass('text-success');
        } else {
            $currentWord.addClass('text-danger'); 
        }
        this.wordList.splice(0, 1);
    };

    model.TypeFast.prototype.highlightCurrentWord = function () {
        $(this.$words[this.wordCounter]).removeClass('highlight');
        this.wordCounter++;
        $(this.$words[this.wordCounter]).addClass('highlight');
    };

    model.TypeFast.prototype.interceptSpace = function (e) {
        if (e.keyCode === 32) {
            this.$wordForm.submit();
            return false;
        } 
    };

    model.TypeFast.prototype.getTimeRemaining = function () {
        var t = Date.parse(this.endTime) - Date.parse(new Date());
        var seconds = Math.floor((t / 1000));
        return seconds;
    };

    model.TypeFast.prototype.initializeClock = function () {
        this.updateClock();
        this.countdownInterval = setInterval(this.updateClock.bind(this), 1000);
    };

    model.TypeFast.prototype.updateClock = function() {
        var $clock = $('#clock');
        var secondsSpan = $clock.find('#seconds');
        var secondsRemaining = this.getTimeRemaining();
        
        secondsSpan.text(secondsRemaining);

        if (secondsRemaining <= 5) {
            secondsSpan.addClass('text-danger');
        }

        if (secondsRemaining <= 0) {
            clearInterval(this.countdownInterval);
            this.$wordInput.prop('disabled', true);
            this.$wordInput.val('Thanks for competing!');

            setTimeout(function() {
                this.$scoreModal.modal('show');
                this.$scoreModal.find('#name').focus();
                this.$scoreModal.find('#pointsMessage').text('You got ' + this.currentPoints + ' correct words!');
                $clock.hide();
                $clock.html('<a href="/"><span class="glyphicon glyphicon-refresh"></span></a>');
                $clock.fadeIn(2000);
            }.bind(this), 2000);
        }
    }

    model.TypeFast.prototype.startTimer = function (e) {
        if (!this.timerStarted && (this.$wordInput.val().length > 0 || e.keyCode === 32)) {
            this.endTime = new Date(Date.parse(new Date()) + 59 * 1000);
            this.initializeClock();
            this.timerStarted = true;
        }
    }

    model.TypeFast.prototype.submitScoreForm = function (e) {
        e.preventDefault();

        var url = this.$scoreForm[0].action + '?' + this.$scoreForm.serialize();

        this.ajaxService.getAsync(url)
            .done(function (data) {
                this.$scoreModal.modal('hide');
                this.showHighscore();
            }.bind(this))
            .fail(function (error) {    

            }.bind(this))
            .always(function () {

            }.bind(this));
    }

    model.TypeFast.prototype.showHighscore = function () {
        this.ajaxService.getAsync(this.options.getHighscoreModalUrl)
            .done(function (data) {
                this.$highscoreModal.html(data);
                this.$highscoreModal.modal('show');
            }.bind(this))
            .fail(function (error) {

            }.bind(this))
            .always(function () {

            }.bind(this));
    }

}(jQuery, window, document, app));