-- ConsoleHelper for FS22
-- Version 1.0.0.0 (2021/11/27)
-- Author: BigBlueHH 

ConsoleHelper = {};
local modRootSettingsDirectory = "modsSettings/";
local modSettingsDirectory = getUserProfileAppPath()..modRootSettingsDirectory.."ConsoleHelper/";
local chFR = {[1]=nil, [2]=nil, [3]=nil}

addConsoleCommand("chT", "print a table recursively", "chT", ConsoleHelper);
function ConsoleHelper:chT(str, value)
	t = ConsoleHelper:stringToTable(str);
	n = 1;
	if not ConsoleHelper:isEmpty(value) then
		n = tonumber(value);
	end;
	print ("### chT ### BEGIN ### Table: "..str);
	print (t)
	DebugUtil.printTableRecursively(t,".",0,n);
	print ("### chT ### END ### Table: "..str);
end;

addConsoleCommand("chF", "call a function/method", "chF", ConsoleHelper);
function ConsoleHelper:chF(str, arg1, arg2, arg3)
	local depth=1;
	local Result={[1]=nil,[2]=nil,[3]=nil}

	print("### chF ### BEGIN");
	if not ConsoleHelper:isEmpty(str) then
		if not ConsoleHelper:isEmpty(arg1) and not ConsoleHelper:isEmpty(arg2) and not ConsoleHelper:isEmpty(arg3) then
			print("Call: "..str.."("..arg1..", "..arg2..", "..arg3..")");
			Result[1], Result[2], Result[3] = assert(loadstring('return '..str..'(...)'))(arg1,arg2,arg3);
		elseif not ConsoleHelper:isEmpty(str) and not ConsoleHelper:isEmpty(arg1) and not ConsoleHelper:isEmpty(arg2) then
			print("Call: "..str.."("..arg1..", "..arg2..")");
			Result[1], Result[2], Result[3] = assert(loadstring('return '..str..'(...)'))(arg1,arg2);
		elseif not ConsoleHelper:isEmpty(str) and not ConsoleHelper:isEmpty(arg1) then
			print("Call: "..str.."("..arg1..")");
			Result[1], Result[2], Result[3] = assert(loadstring('return '..str..'(...)'))(arg1);
		elseif not ConsoleHelper:isEmpty(str) then
			print("Call: "..str.."()");
			Result[1], Result[2], Result[3] = assert(loadstring('return '..str..'(...)'))();
		end;	
		for k1,v1 in pairs(Result) do
			if v1 ~= nil then
				chFR[k1]=v1;
				print("Result"..k1.." ("..type(v1)..") :");
				if type(v1)=="table" then
					DebugUtil.printTableRecursively(v1,".",0,depth);
				else
					print(v1);
				end;
			end;
		end;	
	else
		print ("toDo show example");
	end;
	print("### chF ### END");
end;

addConsoleCommand("chV", "get/set field value", "chV", ConsoleHelper);
function ConsoleHelper:chV(str, arg1)
	print("### chV ### BEGIN");
	if not ConsoleHelper:isEmpty(str) and not ConsoleHelper:isEmpty(arg1) then
		if arg1 == 'true' then
			arg1 = true;
		elseif arg1 == 'false' then
			arg1 = false;
		end;
		print("Name : "..str);
		print("Old Value: "..tostring(ConsoleHelper:stringToTable(str))); 
		t = getfenv(0);
		for w, d in string.gfind(str, "([%w_]+)(.?)") do
			if d == "." then
				if tonumber(w) ~= nil then
					t = t[tonumber(w)];
				else
					t = t[tostring(w)];
				end;
			else	  
				if type(arg1) == 'string' and tonumber(arg1) ~= nil then
					t[w] = tonumber(arg1);			
				else
					t[w] = arg1;
				end;			  
			end;
		end;
		print("New Value: "..tostring(ConsoleHelper:stringToTable(str)));
	elseif not ConsoleHelper:isEmpty(str) then
		print("Name : "..str);
		print("Value: "..tostring(ConsoleHelper:stringToTable(str)));
	else
		print ("toDo show example");
	end;
	print("### chV ### END");
end;

function ConsoleHelper:stringToTable(str)
	local levels = string.split(str, ".");
	local levelsDepth = table.getn(levels);
	local tmpTable = getfenv(0);
	local result;
	if levels ~= nil and levelsDepth > 0 then
		for k,v in pairs(levels) do
			if tonumber(v) ~= nil then
				tmpTable = tmpTable[tonumber(v)];
			else
				tmpTable = tmpTable[tostring(v)];
			end;
		end;
		result = tmpTable;
	else
		print("something went wrong");
	end;
	return result;
end;

function ConsoleHelper:isEmpty(s)
  return s == nil or s == '';
end

function ConsoleHelper:loadMap() end;
function ConsoleHelper:loadSavegame() end;
function ConsoleHelper:saveSavegame() end;
function ConsoleHelper:update(dt) end;
function ConsoleHelper:mouseEvent(posX, posY, isDown, isUp, button) end;
function ConsoleHelper:keyEvent(unicode, sym, modifier, isDown) end;
function ConsoleHelper:draw() end;
function ConsoleHelper:delete()end;
function ConsoleHelper:deleteMap() end;